/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.jee;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlID;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.List;
import org.apache.openejb.jee.Empty;
import org.apache.openejb.jee.Method;
import org.apache.openejb.jee.Text;
import org.apache.openejb.jee.TextMap;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="method-permissionType", propOrder={"descriptions", "roleName", "unchecked", "method"})
public class MethodPermission {
    @XmlTransient
    protected TextMap description = new TextMap();
    @XmlElement(name="role-name", required=true)
    protected List<String> roleName;
    protected Empty unchecked;
    @XmlElement(required=true)
    protected List<Method> method;
    @XmlAttribute
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlID
    protected String id;

    public MethodPermission() {
    }

    public MethodPermission(String className, String ejbName, String methodName, String ... roles) {
        this(new Method(ejbName, className, methodName), roles);
    }

    public MethodPermission(String ejbName, java.lang.reflect.Method method, String ... roles) {
        this(new Method(ejbName, method), roles);
    }

    public MethodPermission(Method method, String ... roles) {
        this.getMethod().add(method);
        for (String role : roles) {
            this.getRoleName().add(role);
        }
    }

    public MethodPermission setUnchecked() {
        this.unchecked = new Empty();
        return this;
    }

    @XmlElement(name="description", required=true)
    public Text[] getDescriptions() {
        return this.description.toArray();
    }

    public void setDescriptions(Text[] text) {
        this.description.set(text);
    }

    public String getDescription() {
        return this.description.get();
    }

    public List<String> getRoleName() {
        if (this.roleName == null) {
            this.roleName = new ArrayList<String>();
        }
        return this.roleName;
    }

    public boolean getUnchecked() {
        return this.unchecked != null;
    }

    public void setUnchecked(boolean b) {
        this.unchecked = b ? new Empty() : null;
    }

    public List<Method> getMethod() {
        if (this.method == null) {
            this.method = new ArrayList<Method>();
        }
        return this.method;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }
}

