/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.threads.task;

import jakarta.enterprise.concurrent.LastExecution;
import jakarta.enterprise.concurrent.SkippedException;
import jakarta.enterprise.concurrent.Trigger;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.openejb.threads.impl.ContextServiceImpl;
import org.apache.openejb.threads.impl.ManagedScheduledExecutorServiceImpl;
import org.apache.openejb.threads.task.CUTask;

public abstract class TriggerTask<T>
extends CUTask<T> {
    protected final ManagedScheduledExecutorServiceImpl executorService;
    protected final Trigger trigger;
    protected final Date initiallyScheduled;
    protected final String id;
    protected final AtomicReference<Future<T>> futureRef;
    protected volatile LastExecution lastExecution;
    protected volatile boolean skipped;
    protected volatile boolean done;
    protected volatile boolean cancelled;
    private volatile T result;
    private volatile Date nextRun;

    protected TriggerTask(Object original, ContextServiceImpl contextService, ManagedScheduledExecutorServiceImpl es, Trigger trigger, Date taskScheduledTime, String id, AtomicReference<Future<T>> ref) {
        super(original, contextService);
        this.executorService = es;
        this.trigger = trigger;
        this.initiallyScheduled = taskScheduledTime;
        this.id = id;
        this.futureRef = ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleNextRun() {
        TriggerTask triggerTask = this;
        synchronized (triggerTask) {
            if (this.cancelled) {
                return;
            }
            this.nextRun = this.trigger.getNextRunTime(this.lastExecution, this.initiallyScheduled);
            if (this.nextRun == null) {
                this.done = true;
                return;
            }
            ScheduledFuture<Object> future = this.executorService.getDelegate().schedule(this::invokeExecute, this.millisUntilNextRun(), TimeUnit.MILLISECONDS);
            this.futureRef.set(future);
            this.taskSubmitted(future, this.executorService, this.delegate);
        }
    }

    private T execute() throws Exception {
        long wait = this.millisUntilNextRun();
        if (wait > 0L) {
            Thread.sleep(wait);
        }
        ZonedDateTime runStart = ZonedDateTime.now();
        try {
            this.skipped = this.trigger.skipRun(this.lastExecution, this.initiallyScheduled);
            if (!this.skipped) {
                this.result = this.doInvoke();
                this.taskDone(this.future, this.executor, this.delegate, null);
                this.lastExecution = new LastExecutionImpl(this.id, this.result, this.nextRun, runStart, ZonedDateTime.now());
            } else {
                this.result = null;
                this.lastExecution = new LastExecutionImpl(this.id, this.result, this.nextRun, null, null);
            }
        }
        catch (RuntimeException re) {
            SkippedException skippedException = new SkippedException((Throwable)re);
            this.taskAborted((Throwable)skippedException);
            throw skippedException;
        }
        this.scheduleNextRun();
        return this.result;
    }

    public T invokeExecute() throws Exception {
        return (T)this.invoke(this::execute);
    }

    protected long millisUntilNextRun() {
        if (this.nextRun == null) {
            return 0L;
        }
        return this.nextRun.getTime() - ManagedScheduledExecutorServiceImpl.nowMs();
    }

    protected abstract T doInvoke() throws Exception;

    public String getId() {
        return this.id;
    }

    public boolean isDone() {
        return this.done;
    }

    public T getResult() {
        return this.result;
    }

    public boolean isSkipped() {
        return this.skipped;
    }

    public LastExecution getLastExecution() {
        return this.lastExecution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelScheduling() {
        TriggerTask triggerTask = this;
        synchronized (triggerTask) {
            this.cancelled = true;
            this.done = true;
        }
    }

    private static class LastExecutionImpl
    implements LastExecution {
        private final String identityName;
        private final Object result;
        private final ZonedDateTime scheduledStart;
        private final ZonedDateTime runStart;
        private final ZonedDateTime runEnd;

        public LastExecutionImpl(String identityName, Object result, Date scheduledStart, ZonedDateTime runStart, ZonedDateTime runEnd) {
            this.identityName = identityName;
            this.result = result;
            this.scheduledStart = scheduledStart.toInstant().atZone(ZoneId.systemDefault());
            this.runStart = runStart;
            this.runEnd = runEnd;
        }

        public String getIdentityName() {
            return this.identityName;
        }

        public Object getResult() {
            return this.result;
        }

        public ZonedDateTime getScheduledStart(ZoneId zone) {
            return this.scheduledStart.withZoneSameInstant(zone);
        }

        public ZonedDateTime getRunStart(ZoneId zone) {
            if (this.runStart == null) {
                return null;
            }
            return this.runStart.withZoneSameInstant(zone);
        }

        public ZonedDateTime getRunEnd(ZoneId zone) {
            if (this.runEnd == null) {
                return null;
            }
            return this.runEnd.withZoneSameInstant(zone);
        }

        public String toString() {
            return "LastExecutionImpl{" + (String)(this.identityName != null ? "identityName='" + this.identityName + "', " : "") + "result=" + String.valueOf(this.result) + ", scheduledStart=" + String.valueOf(this.scheduledStart) + ", runStart=" + String.valueOf(this.runStart) + ", runEnd=" + String.valueOf(this.runEnd) + "}";
        }
    }
}

