/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.context;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.PartialResponseWriter;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.myfaces.util.CDataEndEscapeFilterWriter;
import org.apache.myfaces.util.IllegalXmlCharacterFilterWriter;

public class PartialResponseWriterImpl
extends PartialResponseWriter {
    private ResponseWriter cdataDoubleBufferWriter = null;
    private Writer doubleBuffer = null;
    private List<StackEntry> nestingStack = new ArrayList<StackEntry>(4);

    public PartialResponseWriterImpl(ResponseWriter writer) {
        super(writer.cloneWithWriter((Writer)new IllegalXmlCharacterFilterWriter((Writer)writer)));
    }

    public void startCDATA() throws IOException {
        if (!this.isDoubleBufferEnabled()) {
            super.startCDATA();
        } else {
            this.cdataDoubleBufferWriter.write("<![CDATA[");
        }
        this.openDoubleBuffer();
    }

    private void openDoubleBuffer() {
        this.doubleBuffer = new CDataEndEscapeFilterWriter((Writer)(this.cdataDoubleBufferWriter == null ? this.getWrapped() : this.cdataDoubleBufferWriter));
        this.cdataDoubleBufferWriter = this.getWrapped().cloneWithWriter(this.doubleBuffer);
        StackEntry entry = new StackEntry(this.cdataDoubleBufferWriter, this.doubleBuffer);
        this.nestingStack.add(0, entry);
    }

    public void endCDATA() throws IOException {
        this.closeDoubleBuffer(false);
        if (this.isDoubleBufferEnabled()) {
            this.cdataDoubleBufferWriter.write("]]>");
        } else {
            super.endCDATA();
        }
    }

    private void closeDoubleBuffer(boolean force) throws IOException {
        if (!this.isDoubleBufferEnabled()) {
            return;
        }
        if (force) {
            while (!this.nestingStack.isEmpty()) {
                this.popAndEncodeCurrentStackEntry();
            }
        } else {
            this.popAndEncodeCurrentStackEntry();
        }
    }

    private void popAndEncodeCurrentStackEntry() throws IOException {
        StackEntry parent;
        this.nestingStack.remove(0);
        StackEntry stackEntry = parent = this.nestingStack.isEmpty() ? null : this.nestingStack.get(0);
        if (parent != null) {
            this.cdataDoubleBufferWriter = parent.getWriter();
            this.doubleBuffer = parent.getDoubleBuffer();
        } else {
            this.cdataDoubleBufferWriter = null;
            this.doubleBuffer = null;
        }
    }

    public void endInsert() throws IOException {
        this.closeDoubleBuffer(true);
        super.endInsert();
    }

    public void endUpdate() throws IOException {
        this.closeDoubleBuffer(true);
        super.endUpdate();
    }

    public void endExtension() throws IOException {
        this.closeDoubleBuffer(true);
        super.endExtension();
    }

    public void endEval() throws IOException {
        this.closeDoubleBuffer(true);
        super.endEval();
    }

    public void endError() throws IOException {
        this.closeDoubleBuffer(true);
        super.endError();
    }

    public void endElement(String name) throws IOException {
        if (this.isDoubleBufferEnabled()) {
            this.cdataDoubleBufferWriter.endElement(name);
        } else {
            super.endElement(name);
        }
    }

    public void writeComment(Object comment) throws IOException {
        if (this.isDoubleBufferEnabled()) {
            this.cdataDoubleBufferWriter.writeComment(comment);
        } else {
            super.writeComment(comment);
        }
    }

    private boolean isDoubleBufferEnabled() {
        return !this.nestingStack.isEmpty();
    }

    public void startElement(String name, UIComponent component) throws IOException {
        if (this.isDoubleBufferEnabled()) {
            this.cdataDoubleBufferWriter.startElement(name, component);
        } else {
            super.startElement(name, component);
        }
    }

    public void writeText(Object text, String property) throws IOException {
        if (this.isDoubleBufferEnabled()) {
            this.cdataDoubleBufferWriter.writeText(text, property);
        } else {
            super.writeText(text, property);
        }
    }

    public void writeText(char[] text, int off, int len) throws IOException {
        if (this.isDoubleBufferEnabled()) {
            this.cdataDoubleBufferWriter.writeText(text, off, len);
        } else {
            super.writeText(text, off, len);
        }
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this.isDoubleBufferEnabled()) {
            this.cdataDoubleBufferWriter.write(cbuf, off, len);
        } else {
            super.write(cbuf, off, len);
        }
    }

    public ResponseWriter cloneWithWriter(Writer writer) {
        return super.cloneWithWriter(writer);
    }

    public void writeURIAttribute(String name, Object value, String property) throws IOException {
        if (this.isDoubleBufferEnabled()) {
            this.cdataDoubleBufferWriter.writeURIAttribute(name, value, property);
        } else {
            super.writeURIAttribute(name, value, property);
        }
    }

    public void close() throws IOException {
        if (this.isDoubleBufferEnabled()) {
            this.closeDoubleBuffer(true);
            super.endCDATA();
        }
        super.close();
    }

    public void flush() throws IOException {
        if (this.isDoubleBufferEnabled()) {
            this.cdataDoubleBufferWriter.flush();
        }
        super.flush();
    }

    public void writeAttribute(String name, Object value, String property) throws IOException {
        if (this.isDoubleBufferEnabled()) {
            this.cdataDoubleBufferWriter.writeAttribute(name, value, property);
        } else {
            super.writeAttribute(name, value, property);
        }
    }

    public void writeText(Object object, UIComponent component, String string) throws IOException {
        if (this.isDoubleBufferEnabled()) {
            this.cdataDoubleBufferWriter.writeText(object, component, string);
        } else {
            super.writeText(object, component, string);
        }
    }

    public Writer append(char c) throws IOException {
        if (this.isDoubleBufferEnabled()) {
            this.cdataDoubleBufferWriter.append(c);
            return this;
        }
        return super.append(c);
    }

    public Writer append(CharSequence csq, int start, int end) throws IOException {
        if (this.isDoubleBufferEnabled()) {
            this.cdataDoubleBufferWriter.append(csq, start, end);
            return this;
        }
        return super.append(csq, start, end);
    }

    public Writer append(CharSequence csq) throws IOException {
        if (this.isDoubleBufferEnabled()) {
            this.cdataDoubleBufferWriter.append(csq);
            return this;
        }
        return super.append(csq);
    }

    public void write(char[] cbuf) throws IOException {
        if (this.isDoubleBufferEnabled()) {
            this.cdataDoubleBufferWriter.write(cbuf);
        } else {
            super.write(cbuf);
        }
    }

    public void write(int c) throws IOException {
        if (this.isDoubleBufferEnabled()) {
            this.cdataDoubleBufferWriter.write(c);
        } else {
            super.write(c);
        }
    }

    public void write(String str, int off, int len) throws IOException {
        if (this.isDoubleBufferEnabled()) {
            this.cdataDoubleBufferWriter.write(str, off, len);
        } else {
            super.write(str, off, len);
        }
    }

    public void write(String str) throws IOException {
        if (this.isDoubleBufferEnabled()) {
            this.cdataDoubleBufferWriter.write(str);
        } else {
            super.write(str);
        }
    }

    static class StackEntry {
        private ResponseWriter writer;
        private Writer doubleBuffer;

        StackEntry(ResponseWriter writer, Writer doubleBuffer) {
            this.writer = writer;
            this.doubleBuffer = doubleBuffer;
        }

        public ResponseWriter getWriter() {
            return this.writer;
        }

        public void setWriter(ResponseWriter writer) {
            this.writer = writer;
        }

        public Writer getDoubleBuffer() {
            return this.doubleBuffer;
        }

        public void setDoubleBuffer(Writer doubleBuffer) {
            this.doubleBuffer = doubleBuffer;
        }
    }
}

