/*
 * Decompiled with CFR 0.152.
 */
package org.jabsorb;

import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.jabsorb.ExceptionTransformer;
import org.jabsorb.JSONRPCResult;
import org.jabsorb.JSONSerializer;
import org.jabsorb.callback.CallbackController;
import org.jabsorb.callback.InvocationCallback;
import org.jabsorb.localarg.LocalArgController;
import org.jabsorb.localarg.LocalArgResolver;
import org.jabsorb.reflect.AccessibleObjectKey;
import org.jabsorb.reflect.ClassAnalyzer;
import org.jabsorb.reflect.ClassData;
import org.jabsorb.serializer.AccessibleObjectResolver;
import org.jabsorb.serializer.Serializer;
import org.jabsorb.serializer.impl.ReferenceSerializer;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONRPCBridge
implements Serializable {
    public static final String CALLABLE_REFERENCE_METHOD_PREFIX = ".ref";
    public static final String CONSTRUCTOR_FLAG = "$constructor";
    public static final String OBJECT_METHOD_PREFIX = ".obj";
    private static final long serialVersionUID = 2L;
    private static final ExceptionTransformer IDENTITY_EXCEPTION_TRANSFORMER = new ExceptionTransformer(){
        private static final long serialVersionUID = 2L;

        @Override
        public Object transform(Throwable t) {
            return t;
        }
    };
    private static final Logger log = LoggerFactory.getLogger(JSONRPCBridge.class);
    private static final JSONRPCBridge globalBridge = new JSONRPCBridge();
    private static JSONSerializer ser = new JSONSerializer();
    private ExceptionTransformer exceptionTransformer = IDENTITY_EXCEPTION_TRANSFORMER;
    private CallbackController cbc = null;
    private final Map classMap = new HashMap();
    private final Map objectMap = new HashMap();
    private final Map referenceMap = new HashMap();
    private final Serializer referenceSerializer = new ReferenceSerializer(this);
    private final Set referenceSet = new HashSet();
    private final Set callableReferenceSet = new HashSet();
    private boolean referencesEnabled = false;

    public static JSONRPCBridge getGlobalBridge() {
        return globalBridge;
    }

    public static JSONSerializer getSerializer() {
        return ser;
    }

    public static void registerLocalArgResolver(Class argClazz, Class contextInterface, LocalArgResolver argResolver) {
        LocalArgController.registerLocalArgResolver(argClazz, contextInterface, argResolver);
    }

    public static void setSerializer(JSONSerializer ser) {
        JSONRPCBridge.ser = ser;
    }

    public static void unregisterLocalArgResolver(Class argClazz, Class contextInterface, LocalArgResolver argResolver) {
        LocalArgController.unregisterLocalArgResolver(argClazz, contextInterface, argResolver);
    }

    private static void uniqueMethods(Set m, String prefix, Map methodMap) {
        for (Map.Entry mentry : methodMap.entrySet()) {
            AccessibleObjectKey mk = (AccessibleObjectKey)mentry.getKey();
            m.add(prefix + mk.getMethodName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReference(Object o) {
        Map map = this.referenceMap;
        synchronized (map) {
            this.referenceMap.put(System.identityHashCode(o), o);
        }
    }

    public JSONRPCResult call(Object[] context, JSONObject jsonReq) {
        AccessibleObject ao;
        Object javascriptObject;
        StringTokenizer t;
        JSONArray fixups;
        Object requestId;
        JSONArray arguments;
        String encodedMethod;
        try {
            encodedMethod = jsonReq.getString("method");
            arguments = jsonReq.getJSONArray("params");
            requestId = jsonReq.opt("id");
            fixups = jsonReq.optJSONArray("fixups");
        }
        catch (JSONException e) {
            log.error("no method or parameters in request");
            return new JSONRPCResult(591, null, "method with the requested number of arguments not found (session may have timed out)");
        }
        if (log.isDebugEnabled()) {
            if (fixups != null) {
                log.debug("call " + encodedMethod + "(" + String.valueOf(arguments) + "), requestId=" + String.valueOf(requestId));
            } else {
                log.debug("call " + encodedMethod + "(" + String.valueOf(arguments) + "), fixups=" + String.valueOf(fixups) + ", requestId=" + String.valueOf(requestId));
            }
        }
        if (fixups != null) {
            try {
                for (int i = 0; i < fixups.length(); ++i) {
                    JSONArray assignment = fixups.getJSONArray(i);
                    JSONArray fixup = assignment.getJSONArray(0);
                    JSONArray original = assignment.getJSONArray(1);
                    JSONRPCBridge.applyFixup(arguments, fixup, original);
                }
            }
            catch (JSONException e) {
                log.error("error applying fixups", (Throwable)e);
                return new JSONRPCResult(594, requestId, "invalid or unexpected data in fixups: " + e.getMessage());
            }
        }
        String className = (t = new StringTokenizer(encodedMethod, ".")).hasMoreElements() ? t.nextToken() : null;
        String methodName = t.hasMoreElements() ? t.nextToken() : null;
        int objectStartIndex = encodedMethod.indexOf(91);
        int objectEndIndex = encodedMethod.indexOf(93);
        int objectID = encodedMethod.startsWith(OBJECT_METHOD_PREFIX) && objectStartIndex != -1 && objectEndIndex != -1 && objectStartIndex < objectEndIndex ? Integer.parseInt(encodedMethod.substring(objectStartIndex + 1, objectEndIndex)) : 0;
        if (objectID == 0 && encodedMethod.equals("system.listMethods")) {
            return new JSONRPCResult(0, requestId, this.getSystemMethods());
        }
        try {
            javascriptObject = this.getObjectContext(objectID, className);
            Map methodMap = this.getAccessibleObjectMap(objectID, className, methodName);
            ao = AccessibleObjectResolver.resolveMethod(methodMap, methodName, arguments, ser);
            if (ao == null) {
                throw new NoSuchMethodException("method with the requested number of arguments not found (session may have timed out)");
            }
        }
        catch (NoSuchMethodException e) {
            if (e.getMessage().equals("constructor not found")) {
                return new JSONRPCResult(594, requestId, "constructor not found");
            }
            return new JSONRPCResult(591, requestId, "method with the requested number of arguments not found (session may have timed out)");
        }
        JSONRPCResult r = AccessibleObjectResolver.invokeAccessibleObject(ao, context, arguments, javascriptObject, requestId, ser, this.cbc, this.exceptionTransformer);
        return r;
    }

    public synchronized void enableReferences() throws Exception {
        if (!this.referencesEnabled) {
            this.registerSerializer(this.referenceSerializer);
            this.referencesEnabled = true;
            log.info("enabled references on this bridge");
        }
    }

    public CallbackController getCallbackController() {
        return this.cbc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getReference(int objectId) {
        Map map = this.referenceMap;
        synchronized (map) {
            return this.referenceMap.get(objectId);
        }
    }

    public boolean isCallableReference(Class clazz) {
        if (this == globalBridge) {
            return false;
        }
        if (!this.referencesEnabled) {
            return false;
        }
        if (this.callableReferenceSet.contains(clazz)) {
            return true;
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!this.callableReferenceSet.contains(interfaces[i])) continue;
            return true;
        }
        for (Class superClass = clazz.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            if (!this.callableReferenceSet.contains(superClass)) continue;
            return true;
        }
        return globalBridge.isCallableReference(clazz);
    }

    public boolean isReference(Class clazz) {
        if (this == globalBridge) {
            return false;
        }
        if (!this.referencesEnabled) {
            return false;
        }
        if (this.referenceSet.contains(clazz)) {
            return true;
        }
        return globalBridge.isReference(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class lookupClass(String name) {
        Map map = this.classMap;
        synchronized (map) {
            return (Class)this.classMap.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object lookupObject(Object key) {
        Map map = this.objectMap;
        synchronized (map) {
            ObjectInstance oi = (ObjectInstance)this.objectMap.get(key);
            if (oi != null) {
                return oi.getObject();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCallableReference(Class clazz) throws Exception {
        if (this == globalBridge) {
            throw new Exception("Can't register callable reference on global bridge");
        }
        if (!this.referencesEnabled) {
            this.enableReferences();
        }
        Set set = this.callableReferenceSet;
        synchronized (set) {
            this.callableReferenceSet.add(clazz);
        }
        if (log.isDebugEnabled()) {
            log.debug("registered callable reference " + clazz.getName());
        }
    }

    public void registerCallback(InvocationCallback callback, Class contextInterface) {
        if (this.cbc == null) {
            this.cbc = new CallbackController();
        }
        this.cbc.registerCallback(callback, contextInterface);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerClass(String name, Class clazz) throws Exception {
        Map map = this.classMap;
        synchronized (map) {
            Class exists = (Class)this.classMap.get(name);
            if (exists != null && exists != clazz) {
                throw new Exception("different class registered as " + name);
            }
            if (exists == null) {
                this.classMap.put(name, clazz);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("registered class " + clazz.getName() + " as " + name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerObject(Object key, Object o) {
        ObjectInstance oi = new ObjectInstance(o);
        Map map = this.objectMap;
        synchronized (map) {
            this.objectMap.put(key, oi);
        }
        if (log.isDebugEnabled()) {
            log.debug("registered object " + o.hashCode() + " of class " + o.getClass().getName() + " as " + String.valueOf(key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerObject(Object key, Object o, Class interfaceClass) {
        ObjectInstance oi = new ObjectInstance(o, interfaceClass);
        Map map = this.objectMap;
        synchronized (map) {
            this.objectMap.put(key, oi);
        }
        if (log.isDebugEnabled()) {
            log.debug("registered object " + o.hashCode() + " of class " + interfaceClass.getName() + " as " + String.valueOf(key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerReference(Class clazz) throws Exception {
        if (this == globalBridge) {
            throw new Exception("Can't register reference on global bridge");
        }
        if (!this.referencesEnabled) {
            this.enableReferences();
        }
        Set set = this.referenceSet;
        synchronized (set) {
            this.referenceSet.add(clazz);
        }
        if (log.isDebugEnabled()) {
            log.debug("registered reference " + clazz.getName());
        }
    }

    public void registerSerializer(Serializer serializer) throws Exception {
        ser.registerSerializer(serializer);
    }

    public void setCallbackController(CallbackController cbc) {
        this.cbc = cbc;
    }

    public void setExceptionTransformer(ExceptionTransformer exceptionTransformer) {
        this.exceptionTransformer = exceptionTransformer;
    }

    public void unregisterCallback(InvocationCallback callback, Class contextInterface) {
        if (this.cbc == null) {
            return;
        }
        this.cbc.unregisterCallback(callback, contextInterface);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterClass(String name) {
        Map map = this.classMap;
        synchronized (map) {
            Class clazz = (Class)this.classMap.get(name);
            if (clazz != null) {
                this.classMap.remove(name);
                if (log.isDebugEnabled()) {
                    log.debug("unregistered class " + clazz.getName() + " from " + name);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterObject(Object key) {
        Map map = this.objectMap;
        synchronized (map) {
            ObjectInstance oi = (ObjectInstance)this.objectMap.get(key);
            if (oi.getObject() != null) {
                this.objectMap.remove(key);
                if (log.isDebugEnabled()) {
                    log.debug("unregistered object " + oi.getObject().hashCode() + " of class " + oi.getClazz().getName() + " from " + String.valueOf(key));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void allInstanceMethods(Set m) {
        Map map = this.objectMap;
        synchronized (map) {
            for (Map.Entry oientry : this.objectMap.entrySet()) {
                Object key = oientry.getKey();
                if (!(key instanceof String)) continue;
                String name = (String)key;
                ObjectInstance oi = (ObjectInstance)oientry.getValue();
                ClassData cd = ClassAnalyzer.getClassData(oi.getClazz());
                JSONRPCBridge.uniqueMethods(m, name + ".", cd.getMethodMap());
                JSONRPCBridge.uniqueMethods(m, name + ".", cd.getStaticMethodMap());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void allCallableReferences(Set m) {
        Set set = this.callableReferenceSet;
        synchronized (set) {
            for (Class clazz : this.callableReferenceSet) {
                ClassData cd = ClassAnalyzer.getClassData(clazz);
                JSONRPCBridge.uniqueMethods(m, ".ref[" + clazz.getName() + "].", cd.getStaticMethodMap());
                JSONRPCBridge.uniqueMethods(m, ".ref[" + clazz.getName() + "].", cd.getMethodMap());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void allStaticMethods(Set m) {
        Map map = this.classMap;
        synchronized (map) {
            for (Map.Entry cdentry : this.classMap.entrySet()) {
                String name = (String)cdentry.getKey();
                Class clazz = (Class)cdentry.getValue();
                ClassData cd = ClassAnalyzer.getClassData(clazz);
                JSONRPCBridge.uniqueMethods(m, name + ".", cd.getStaticMethodMap());
            }
        }
    }

    public static void applyFixup(Object object, JSONArray fixup, JSONArray original) throws JSONException {
        int last = fixup.length() - 1;
        if (last < 0) {
            throw new JSONException("fixup path must contain at least 1 reference");
        }
        Object originalObject = JSONRPCBridge.traverse(object, original, false);
        Object fixupParent = JSONRPCBridge.traverse(object, fixup, true);
        if (fixupParent instanceof JSONObject) {
            String objRef = fixup.optString(last, null);
            if (objRef == null) {
                throw new JSONException("last fixup reference not a string");
            }
            ((JSONObject)fixupParent).put(objRef, originalObject);
        } else {
            int arrRef = fixup.optInt(last, -1);
            if (arrRef == -1) {
                throw new JSONException("last fixup reference not a valid array index");
            }
            ((JSONArray)fixupParent).put(arrRef, originalObject);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map getAccessibleObjectMap(int objectID, String className, String methodName) throws NoSuchMethodException {
        HashMap methodMap = new HashMap();
        if (objectID == 0) {
            ObjectInstance oi = this.resolveObject(className);
            ClassData classData = this.resolveClass(className);
            if (oi != null) {
                methodMap.putAll(ClassAnalyzer.getClassData(oi.getClazz()).getMethodMap());
                return methodMap;
            } else if (methodName.equals(CONSTRUCTOR_FLAG)) {
                try {
                    methodMap.putAll(ClassAnalyzer.getClassData(this.lookupClass(className)).getConstructorMap());
                    return methodMap;
                }
                catch (Exception e) {
                    throw new NoSuchMethodException("constructor not found");
                }
            } else {
                if (classData == null) throw new NoSuchMethodException("method with the requested number of arguments not found (session may have timed out)");
                methodMap.putAll(classData.getStaticMethodMap());
            }
            return methodMap;
        } else {
            ObjectInstance oi = this.resolveObject(objectID);
            if (oi == null) {
                throw new NoSuchMethodException();
            }
            ClassData cd = ClassAnalyzer.getClassData(oi.getClazz());
            methodMap.putAll(cd.getMethodMap());
        }
        return methodMap;
    }

    private Object getObjectContext(int objectID, String className) {
        ObjectInstance oi;
        Object objectContext = objectID == 0 ? ((oi = this.resolveObject(className)) != null ? oi.getObject() : null) : ((oi = this.resolveObject(objectID)) != null ? oi.getObject() : null);
        return objectContext;
    }

    private static Object next(Object prev, int idx) throws JSONException {
        if (prev == null) {
            throw new JSONException("cannot traverse- missing object encountered");
        }
        if (prev instanceof JSONArray) {
            return ((JSONArray)prev).get(idx);
        }
        throw new JSONException("not an array");
    }

    private static Object next(Object prev, String ref) throws JSONException {
        if (prev == null) {
            throw new JSONException("cannot traverse- missing object encountered");
        }
        if (prev instanceof JSONObject) {
            return ((JSONObject)prev).get(ref);
        }
        throw new JSONException("not an object");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassData resolveClass(String className) {
        Class clazz;
        ClassData cd = null;
        Map map = this.classMap;
        synchronized (map) {
            clazz = (Class)this.classMap.get(className);
        }
        if (clazz != null) {
            cd = ClassAnalyzer.getClassData(clazz);
        }
        if (cd != null) {
            if (log.isDebugEnabled()) {
                log.debug("found class " + cd.getClazz().getName() + " named " + className);
            }
            return cd;
        }
        if (this != globalBridge) {
            return globalBridge.resolveClass(className);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectInstance resolveObject(Object key) {
        ObjectInstance oi;
        Map map = this.objectMap;
        synchronized (map) {
            oi = (ObjectInstance)this.objectMap.get(key);
        }
        if (log.isDebugEnabled() && oi != null) {
            log.debug("found object " + oi.getObject().hashCode() + " of class " + oi.getClazz().getName() + " with key " + String.valueOf(key));
        }
        if (oi == null && this != globalBridge) {
            return globalBridge.resolveObject(key);
        }
        return oi;
    }

    public JSONArray getSystemMethods() {
        TreeSet m = new TreeSet();
        globalBridge.allInstanceMethods(m);
        if (globalBridge != this) {
            globalBridge.allStaticMethods(m);
            globalBridge.allInstanceMethods(m);
        }
        this.allStaticMethods(m);
        this.allInstanceMethods(m);
        this.allCallableReferences(m);
        JSONArray methods = new JSONArray();
        Iterator i = m.iterator();
        while (i.hasNext()) {
            methods.put(i.next());
        }
        return methods;
    }

    private static Object traverse(Object origin, JSONArray refs, boolean fixup) throws JSONException {
        try {
            JSONArray arr = null;
            JSONObject obj = null;
            if (origin instanceof JSONArray) {
                arr = (JSONArray)origin;
            } else {
                obj = (JSONObject)origin;
            }
            int stop = refs.length();
            if (fixup) {
                --stop;
            }
            for (int i = 0; i < stop; ++i) {
                Object next = arr == null ? JSONRPCBridge.next((Object)obj, refs.optString(i, null)) : JSONRPCBridge.next((Object)arr, refs.optInt(i, -1));
                if (next instanceof JSONObject) {
                    obj = (JSONObject)next;
                    arr = null;
                    continue;
                }
                obj = null;
                arr = (JSONArray)next;
            }
            if (arr == null) {
                return obj;
            }
            return arr;
        }
        catch (Exception e) {
            log.error("unexpected exception", (Throwable)e);
            throw new JSONException("unexpected exception");
        }
    }

    static {
        try {
            ser.registerDefaultSerializers();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class ObjectInstance
    implements Serializable {
        private static final long serialVersionUID = 2L;
        private final Object object;
        private final Class clazz;

        public ObjectInstance(Object object) {
            this.object = object;
            this.clazz = object.getClass();
        }

        public ObjectInstance(Object object, Class clazz) {
            if (!clazz.isInstance(object)) {
                throw new ClassCastException("Attempt to register jsonrpc object with invalid class.");
            }
            this.object = object;
            this.clazz = clazz;
        }

        public Class getClazz() {
            return this.clazz;
        }

        public Object getObject() {
            return this.object;
        }
    }
}

