/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.segment;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.uniffle.common.BufferSegment;
import org.apache.uniffle.common.ShuffleDataSegment;
import org.apache.uniffle.common.ShuffleIndexResult;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.segment.SegmentSplitter;
import org.apache.uniffle.shaded.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixedSizeSegmentSplitter
implements SegmentSplitter {
    private static final Logger LOGGER = LoggerFactory.getLogger(FixedSizeSegmentSplitter.class);
    private int readBufferSize;

    public FixedSizeSegmentSplitter(int readBufferSize) {
        this.readBufferSize = readBufferSize;
    }

    @Override
    public List<ShuffleDataSegment> split(ShuffleIndexResult shuffleIndexResult) {
        if (shuffleIndexResult == null || shuffleIndexResult.isEmpty()) {
            return Lists.newArrayList();
        }
        ByteBuffer indexData = shuffleIndexResult.getIndexData();
        long dataFileLen = shuffleIndexResult.getDataFileLen();
        return FixedSizeSegmentSplitter.transIndexDataToSegments(indexData, this.readBufferSize, dataFileLen);
    }

    private static List<ShuffleDataSegment> transIndexDataToSegments(ByteBuffer indexData, int readBufferSize, long dataFileLen) {
        ArrayList<BufferSegment> bufferSegments = Lists.newArrayList();
        ArrayList<ShuffleDataSegment> dataFileSegments = Lists.newArrayList();
        int bufferOffset = 0;
        long fileOffset = -1L;
        long totalLength = 0L;
        while (indexData.hasRemaining()) {
            try {
                long offset = indexData.getLong();
                int length = indexData.getInt();
                int uncompressLength = indexData.getInt();
                long crc = indexData.getLong();
                long blockId = indexData.getLong();
                long taskAttemptId = indexData.getLong();
                if (fileOffset == -1L) {
                    fileOffset = offset;
                }
                if (dataFileLen != -1L && (totalLength += (long)length) > dataFileLen) {
                    LOGGER.info("Abort inconsistent data, the data length: {}(bytes) recorded in index file is greater than the real data file length: {}(bytes). Block id: {}This may happen when the data is flushing, please ignore.", new Object[]{totalLength, dataFileLen, blockId});
                    break;
                }
                bufferSegments.add(new BufferSegment(blockId, bufferOffset, length, uncompressLength, crc, taskAttemptId));
                if ((bufferOffset += length) < readBufferSize) continue;
                ShuffleDataSegment sds = new ShuffleDataSegment(fileOffset, bufferOffset, bufferSegments);
                dataFileSegments.add(sds);
                bufferSegments = Lists.newArrayList();
                bufferOffset = 0;
                fileOffset = -1L;
            }
            catch (BufferUnderflowException ue) {
                throw new RssException("Read index data under flow", ue);
            }
        }
        if (bufferOffset > 0) {
            ShuffleDataSegment sds = new ShuffleDataSegment(fileOffset, bufferOffset, bufferSegments);
            dataFileSegments.add(sds);
        }
        return dataFileSegments;
    }
}

