/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.util.objects.checker;

import java.util.List;
import org.apache.wicket.core.util.objects.checker.IObjectChecker;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Generics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractObjectChecker
implements IObjectChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractObjectChecker.class);
    private final List<Class<?>> exclusions;

    protected AbstractObjectChecker() {
        this(Generics.newArrayList());
    }

    protected AbstractObjectChecker(List<Class<?>> exclusions) {
        this.exclusions = Args.notNull(exclusions, "exclusions");
    }

    @Override
    public IObjectChecker.Result check(Object object) {
        IObjectChecker.Result result = IObjectChecker.Result.SUCCESS;
        if (object != null && !this.getExclusions().isEmpty()) {
            Class<?> objectType = object.getClass();
            for (Class<?> excludedType : this.getExclusions()) {
                if (!excludedType.isAssignableFrom(objectType)) continue;
                LOGGER.debug("Object with type '{}' wont be checked because its type is excluded ({})", (Object)objectType, (Object)excludedType);
                return result;
            }
        }
        result = this.doCheck(object);
        return result;
    }

    protected IObjectChecker.Result doCheck(Object object) {
        return IObjectChecker.Result.SUCCESS;
    }

    @Override
    public List<Class<?>> getExclusions() {
        return this.exclusions;
    }
}

