/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.test.svg;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import org.apache.batik.test.AbstractTest;
import org.apache.batik.test.DefaultTestSuite;
import org.apache.batik.test.Test;
import org.apache.batik.test.TestReport;
import org.apache.batik.test.TestReportValidator;
import org.apache.batik.test.svg.SVGRenderingAccuracyTest;
import org.apache.batik.test.svg.SamplesRenderingTest;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.PNGTranscoder;

public class SVGRenderingAccuracyTestValidator
extends DefaultTestSuite {
    private static final String validSVG = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"450\" height=\"500\" viewBox=\"0 0 450 500\"> \n    <rect x=\"25\" y=\"25\" width=\"400\" height=\"450\" fill=\"blue\" /> \n</svg>\n";
    private static final String validSVGVariation = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"450\" height=\"500\" viewBox=\"0 0 450 500\"> \n    <rect x=\"25\" y=\"25\" width=\"400\" height=\"450\" fill=\"#0000cc\" /> \n</svg>\n";
    private static final String validSmallSVG = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"45\" height=\"50\" viewBox=\"0 0 45 50\"> \n    <rect x=\"2.5\" y=\"2.5\" width=\"40\" height=\"45\" fill=\"blue\" /> \n</svg>\n";
    private static final String validRedSVG = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"450\" height=\"500\" viewBox=\"0 0 450 500\"> \n    <rect x=\"25\" y=\"25\" width=\"400\" height=\"450\" fill=\"red\" /> \n</svg>\n";
    private static final String invalidSVG = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"450 height=\"500\" viewBox=\"0 0 450 500\"> \n    <rect x=\"25\" y=\"25\" width=\"400\" height=\"450\" fill=\"blue\" /> \n</svg>\n";

    public SVGRenderingAccuracyTestValidator() {
        this.addTest((Test)new InvalidSVGURL());
        this.addTest((Test)new InvalidSVGContent());
        this.addTest((Test)new InvalidReferenceImageURL());
        this.addTest((Test)new InexistingReferenceImage());
        this.addTest((Test)new DifferentSizes());
        this.addTest((Test)new SameSizeDifferentContent());
        this.addTest((Test)new AccurateRendering());
        this.addTest((Test)new AccurateRenderingWithVariation());
        this.addTest((Test)new DefaultConfigTest());
    }

    public static URL createSVGSourceURL(String svgContent) throws Exception {
        File tmpFile = File.createTempFile(SVGRenderingAccuracyTest.TEMP_FILE_PREFIX, null);
        FileWriter writer = new FileWriter(tmpFile);
        writer.write(svgContent);
        writer.close();
        return tmpFile.toURI().toURL();
    }

    public static URL createValidReferenceImage(String svgContent) throws Exception {
        TranscoderInput validSrc = new TranscoderInput((Reader)new StringReader(svgContent));
        File tmpFile = File.createTempFile(SVGRenderingAccuracyTest.TEMP_FILE_PREFIX, SVGRenderingAccuracyTest.TEMP_FILE_SUFFIX);
        TranscoderOutput validDst = new TranscoderOutput((OutputStream)new FileOutputStream(tmpFile));
        PNGTranscoder transcoder = new PNGTranscoder();
        transcoder.transcode(validSrc, validDst);
        tmpFile.deleteOnExit();
        return tmpFile.toURI().toURL();
    }

    static class AccurateRenderingWithVariation
    extends TestReportValidator {
        AccurateRenderingWithVariation() {
        }

        public TestReport runImpl() throws Exception {
            URL validSVGURL = SVGRenderingAccuracyTestValidator.createSVGSourceURL(SVGRenderingAccuracyTestValidator.validSVG);
            URL validRefImageURL = SVGRenderingAccuracyTestValidator.createValidReferenceImage(SVGRenderingAccuracyTestValidator.validSVGVariation);
            SVGRenderingAccuracyTest t = new SVGRenderingAccuracyTest(validSVGURL.toString(), validRefImageURL.toString());
            File tmpVariationFile = File.createTempFile(SVGRenderingAccuracyTest.TEMP_FILE_PREFIX, null);
            t.setSaveVariation(tmpVariationFile);
            this.setConfig((Test)t, false, "SVGRenderingAccuracyTest.error.svg.rendering.not.accurate");
            super.runImpl();
            t.addVariationURL(tmpVariationFile.toURI().toURL().toString());
            t.setSaveVariation(null);
            this.setConfig((Test)t, true, null);
            return super.runImpl();
        }
    }

    static class AccurateRendering
    extends TestReportValidator {
        AccurateRendering() {
        }

        public TestReport runImpl() throws Exception {
            URL validSVGURL = SVGRenderingAccuracyTestValidator.createSVGSourceURL(SVGRenderingAccuracyTestValidator.validSVG);
            URL validRefImageURL = SVGRenderingAccuracyTestValidator.createValidReferenceImage(SVGRenderingAccuracyTestValidator.validSVG);
            this.setConfig((Test)new SVGRenderingAccuracyTest(validSVGURL.toString(), validRefImageURL.toString()), true, null);
            return super.runImpl();
        }
    }

    static class SameSizeDifferentContent
    extends TestReportValidator {
        SameSizeDifferentContent() {
        }

        public TestReport runImpl() throws Exception {
            URL validSVGURL = SVGRenderingAccuracyTestValidator.createSVGSourceURL(SVGRenderingAccuracyTestValidator.validSVG);
            URL validRefImageURL = SVGRenderingAccuracyTestValidator.createValidReferenceImage(SVGRenderingAccuracyTestValidator.validRedSVG);
            SVGRenderingAccuracyTest t = new SVGRenderingAccuracyTest(validSVGURL.toString(), validRefImageURL.toString());
            this.setConfig((Test)t, false, "SVGRenderingAccuracyTest.error.svg.rendering.not.accurate");
            return super.runImpl();
        }
    }

    static class DifferentSizes
    extends TestReportValidator {
        DifferentSizes() {
        }

        public TestReport runImpl() throws Exception {
            URL validSVGURL = SVGRenderingAccuracyTestValidator.createSVGSourceURL(SVGRenderingAccuracyTestValidator.validSVG);
            URL validRefImageURL = SVGRenderingAccuracyTestValidator.createValidReferenceImage(SVGRenderingAccuracyTestValidator.validSmallSVG);
            SVGRenderingAccuracyTest t = new SVGRenderingAccuracyTest(validSVGURL.toString(), validRefImageURL.toString());
            this.setConfig((Test)t, false, "SVGRenderingAccuracyTest.error.svg.rendering.not.accurate");
            return super.runImpl();
        }
    }

    static class InexistingReferenceImage
    extends TestReportValidator {
        InexistingReferenceImage() {
        }

        public TestReport runImpl() throws Exception {
            URL validSVGURL = SVGRenderingAccuracyTestValidator.createSVGSourceURL(SVGRenderingAccuracyTestValidator.validSVG);
            File tmpFile = File.createTempFile(SVGRenderingAccuracyTest.TEMP_FILE_PREFIX, null);
            URL refImgURL = tmpFile.toURI().toURL();
            tmpFile.delete();
            SVGRenderingAccuracyTest t = new SVGRenderingAccuracyTest(validSVGURL.toString(), refImgURL.toString());
            this.setConfig((Test)t, false, "SVGRenderingAccuracyTest.error.cannot.open.reference.image");
            return super.runImpl();
        }
    }

    static class InvalidReferenceImageURL
    extends TestReportValidator {
        InvalidReferenceImageURL() {
        }

        public TestReport runImpl() throws Exception {
            URL validSVGURL = SVGRenderingAccuracyTestValidator.createSVGSourceURL(SVGRenderingAccuracyTestValidator.validSVG);
            URL invalidReferenceImageURL = null;
            invalidReferenceImageURL = new URL("http", "dummyHost", "dummyFile.png");
            SVGRenderingAccuracyTest t = new SVGRenderingAccuracyTest(validSVGURL.toString(), invalidReferenceImageURL.toString());
            this.setConfig((Test)t, false, "SVGRenderingAccuracyTest.error.cannot.open.reference.image");
            return super.runImpl();
        }
    }

    static class InvalidSVGContent
    extends TestReportValidator {
        InvalidSVGContent() {
        }

        public TestReport runImpl() throws Exception {
            URL validSVGURL = SVGRenderingAccuracyTestValidator.createSVGSourceURL(SVGRenderingAccuracyTestValidator.invalidSVG);
            URL refImgURL = SVGRenderingAccuracyTestValidator.createValidReferenceImage(SVGRenderingAccuracyTestValidator.validSVG);
            SVGRenderingAccuracyTest t = new SVGRenderingAccuracyTest(validSVGURL.toString(), refImgURL.toString());
            this.setConfig((Test)t, false, "SVGRenderingAccuracyTest.error.cannot.transcode.svg");
            return super.runImpl();
        }
    }

    static class InvalidSVGURL
    extends TestReportValidator {
        InvalidSVGURL() {
        }

        public TestReport runImpl() throws Exception {
            URL invalidSVGURL = new URL("http", "dummyHost", "dummyFile.svg");
            URL refImgURL = SVGRenderingAccuracyTestValidator.createValidReferenceImage(SVGRenderingAccuracyTestValidator.validSVG);
            SVGRenderingAccuracyTest t = new SVGRenderingAccuracyTest(invalidSVGURL.toString(), refImgURL.toString());
            this.setConfig((Test)t, false, "SVGRenderingAccuracyTest.error.cannot.transcode.svg");
            return super.runImpl();
        }
    }

    static class DefaultConfigTest
    extends AbstractTest {
        String svgURL = "samples/anne.svg";
        String expectedRefImgURL = "test-references/samples/anne.png";
        String expectedVariationURL = "test-references/samples/accepted-variation/anne.png";
        String expectedCandidateURL = "test-references/samples/candidate-variation/anne.png";
        String ERROR_EXCEPTION_WHILE_BUILDING_TEST = "error.exception.while.building.test";
        String ERROR_UNEXPECTED_REFERENCE_IMAGE_URL = "error.unexpected.reference.image.url";
        String ERROR_UNEXPECTED_VARIATION_URL = "error.unexpected.variation.url";
        String ERROR_UNEXPECTED_CANDIDATE_URL = "error.unexpected.candidate.url";
        String ENTRY_KEY_EXPECTED_VALUE = "entry.key.expected.value";
        String ENTRY_KEY_FOUND_VALUE = "entry.key.found.value";

        public DefaultConfigTest() {
            this.setId("defaultTest");
        }

        public TestReport runImpl() throws Exception {
            SamplesRenderingTest t = new SamplesRenderingTest();
            t.setId(this.svgURL);
            if (!t.refImgURL.toString().endsWith(this.expectedRefImgURL)) {
                TestReport r = this.reportError(this.ERROR_UNEXPECTED_REFERENCE_IMAGE_URL);
                r.addDescriptionEntry(this.ENTRY_KEY_EXPECTED_VALUE, (Object)this.expectedRefImgURL);
                r.addDescriptionEntry(this.ENTRY_KEY_FOUND_VALUE, (Object)("" + t.refImgURL));
                return r;
            }
            if (t.variationURLs == null || t.variationURLs.size() != 3 || !t.variationURLs.get(0).toString().endsWith(this.expectedVariationURL)) {
                TestReport r = this.reportError(this.ERROR_UNEXPECTED_VARIATION_URL);
                r.addDescriptionEntry(this.ENTRY_KEY_EXPECTED_VALUE, (Object)this.expectedVariationURL);
                String found = t.variationURLs == null ? "null" : (t.variationURLs.size() != 1 ? "<list of " + t.variationURLs.size() + " URLs>" : t.variationURLs.get(0).toString());
                r.addDescriptionEntry(this.ENTRY_KEY_FOUND_VALUE, (Object)found);
                return r;
            }
            if (!t.saveVariation.toURI().toURL().toString().endsWith(this.expectedCandidateURL)) {
                TestReport r = this.reportError(this.ERROR_UNEXPECTED_CANDIDATE_URL);
                r.addDescriptionEntry(this.ENTRY_KEY_EXPECTED_VALUE, (Object)this.expectedCandidateURL);
                r.addDescriptionEntry(this.ENTRY_KEY_FOUND_VALUE, (Object)("" + t.saveVariation.toURI().toURL().toString()));
                return r;
            }
            return this.reportSuccess();
        }
    }
}

