﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/notifications/Notifications_EXPORTS.h>
#include <aws/notifications/model/AggregationDuration.h>
#include <aws/notifications/model/NotificationConfigurationStatus.h>
#include <aws/notifications/model/NotificationConfigurationSubtype.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Notifications {
namespace Model {
class GetNotificationConfigurationResult {
 public:
  AWS_NOTIFICATIONS_API GetNotificationConfigurationResult() = default;
  AWS_NOTIFICATIONS_API GetNotificationConfigurationResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_NOTIFICATIONS_API GetNotificationConfigurationResult& operator=(
      const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The ARN of the resource.</p>
   */
  inline const Aws::String& GetArn() const { return m_arn; }
  template <typename ArnT = Aws::String>
  void SetArn(ArnT&& value) {
    m_arnHasBeenSet = true;
    m_arn = std::forward<ArnT>(value);
  }
  template <typename ArnT = Aws::String>
  GetNotificationConfigurationResult& WithArn(ArnT&& value) {
    SetArn(std::forward<ArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the <code>NotificationConfiguration</code>.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  GetNotificationConfigurationResult& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The description of the <code>NotificationConfiguration</code>.</p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  GetNotificationConfigurationResult& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status of this <code>NotificationConfiguration</code>.</p>
   */
  inline NotificationConfigurationStatus GetStatus() const { return m_status; }
  inline void SetStatus(NotificationConfigurationStatus value) {
    m_statusHasBeenSet = true;
    m_status = value;
  }
  inline GetNotificationConfigurationResult& WithStatus(NotificationConfigurationStatus value) {
    SetStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The creation time of the <code>NotificationConfiguration</code>.</p>
   */
  inline const Aws::Utils::DateTime& GetCreationTime() const { return m_creationTime; }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  void SetCreationTime(CreationTimeT&& value) {
    m_creationTimeHasBeenSet = true;
    m_creationTime = std::forward<CreationTimeT>(value);
  }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  GetNotificationConfigurationResult& WithCreationTime(CreationTimeT&& value) {
    SetCreationTime(std::forward<CreationTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The aggregation preference of the <code>NotificationConfiguration</code>.</p>
   * <ul> <li> <p>Values:</p> <ul> <li> <p> <code>LONG</code> </p> <ul> <li>
   * <p>Aggregate notifications for long periods of time (12 hours).</p> </li> </ul>
   * </li> <li> <p> <code>SHORT</code> </p> <ul> <li> <p>Aggregate notifications for
   * short periods of time (5 minutes).</p> </li> </ul> </li> <li> <p>
   * <code>NONE</code> </p> <ul> <li> <p>Don't aggregate notifications.</p> </li>
   * </ul> </li> </ul> </li> </ul>
   */
  inline AggregationDuration GetAggregationDuration() const { return m_aggregationDuration; }
  inline void SetAggregationDuration(AggregationDuration value) {
    m_aggregationDurationHasBeenSet = true;
    m_aggregationDuration = value;
  }
  inline GetNotificationConfigurationResult& WithAggregationDuration(AggregationDuration value) {
    SetAggregationDuration(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The subtype of the notification configuration returned in the response.</p>
   */
  inline NotificationConfigurationSubtype GetSubtype() const { return m_subtype; }
  inline void SetSubtype(NotificationConfigurationSubtype value) {
    m_subtypeHasBeenSet = true;
    m_subtype = value;
  }
  inline GetNotificationConfigurationResult& WithSubtype(NotificationConfigurationSubtype value) {
    SetSubtype(value);
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetNotificationConfigurationResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_arn;

  Aws::String m_name;

  Aws::String m_description;

  NotificationConfigurationStatus m_status{NotificationConfigurationStatus::NOT_SET};

  Aws::Utils::DateTime m_creationTime{};

  AggregationDuration m_aggregationDuration{AggregationDuration::NOT_SET};

  NotificationConfigurationSubtype m_subtype{NotificationConfigurationSubtype::NOT_SET};

  Aws::String m_requestId;
  bool m_arnHasBeenSet = false;
  bool m_nameHasBeenSet = false;
  bool m_descriptionHasBeenSet = false;
  bool m_statusHasBeenSet = false;
  bool m_creationTimeHasBeenSet = false;
  bool m_aggregationDurationHasBeenSet = false;
  bool m_subtypeHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Notifications
}  // namespace Aws
