/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model.data;

import java.sql.Connection;
import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDCursor;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCTransactionManager;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;

public class PostgreRefCursor
implements DBDCursor {
    private static final Log log = Log.getLog(PostgreRefCursor.class);
    private final JDBCSession session;
    private String cursorName;
    private boolean isOpen;
    private JDBCStatement cursorStatement;

    public PostgreRefCursor(JDBCSession session, @NotNull String cursorName) throws SQLException {
        this.session = session;
        this.cursorName = cursorName;
        this.isOpen = true;
    }

    public Object getRawValue() {
        return this.cursorName;
    }

    public boolean isNull() {
        return false;
    }

    public boolean isModified() {
        return false;
    }

    public void release() {
        if (this.isOpen) {
            try {
                JDBCUtils.executeStatement((Connection)this.session, (String)("CLOSE \"" + this.cursorName + "\""));
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        if (this.cursorStatement != null) {
            this.cursorStatement.close();
            this.cursorStatement = null;
        }
    }

    @NotNull
    public DBCResultSet openResultSet(@NotNull DBCSession session) throws DBCException {
        try {
            DBCTransactionManager txnManager = DBUtils.getTransactionManager((DBCExecutionContext)session.getExecutionContext());
            if (txnManager != null && txnManager.isAutoCommit()) {
                throw new DBCException("Ref cursors are not available in auto-commit mode");
            }
            if (this.cursorStatement != null) {
                this.cursorStatement.close();
            }
            JDBCUtils.executeStatement((Connection)this.session, (String)("MOVE ABSOLUTE 0 IN \"" + this.cursorName + "\""));
            this.cursorStatement = this.session.createStatement();
            return this.cursorStatement.executeQuery("FETCH ALL IN \"" + this.cursorName + "\"");
        }
        catch (SQLException e) {
            throw new DBCException((Throwable)e, session.getExecutionContext());
        }
    }

    @Nullable
    public String getCursorName() {
        return this.cursorName;
    }

    public String toString() {
        return this.cursorName;
    }
}

