/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.config.migration.wizards.datagrip;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ui.config.migration.ImportConfigMessages;
import org.jkiss.dbeaver.ui.config.migration.datagrip.api.DataGripDataSourceConfigXmlService;
import org.jkiss.dbeaver.ui.config.migration.datagrip.impl.DataGripDataSourceConfigXmlServiceImpl;
import org.jkiss.dbeaver.ui.config.migration.wizards.ConfigImportWizardPage;
import org.jkiss.dbeaver.ui.config.migration.wizards.ImportConnectionInfo;
import org.jkiss.dbeaver.ui.config.migration.wizards.ImportData;
import org.jkiss.dbeaver.ui.config.migration.wizards.datagrip.ConfigImportWizardDataGrip;

public class ConfigImportWizardPageDataGripConnections
extends ConfigImportWizardPage {
    private static final Log log = Log.getLog(ConfigImportWizardPageDataGripConnections.class);
    DataGripDataSourceConfigXmlService dataGripDataSourceConfigXmlService = DataGripDataSourceConfigXmlServiceImpl.INSTANCE;

    public ConfigImportWizardPageDataGripConnections() {
        super(ImportConfigMessages.config_import_wizard_page_caption_connections);
        this.setTitle(ImportConfigMessages.config_import_wizard_page_caption_connections);
        this.setDescription(ImportConfigMessages.config_import_wizard_header_import_configuration);
    }

    @Override
    protected void loadConnections(ImportData importData) throws DBException {
        this.setErrorMessage(null);
        try {
            this.tryLoadConnection(importData);
        }
        catch (Exception e) {
            log.warn((Object)"Exception during to import connections", (Throwable)e);
            this.setErrorMessage(e.getMessage());
        }
    }

    private void tryLoadConnection(ImportData importData) throws Exception {
        ConfigImportWizardDataGrip wizard = (ConfigImportWizardDataGrip)this.getWizard();
        Path ideaDirectory = wizard.getInputFile();
        if (!Files.exists(ideaDirectory, new LinkOption[0])) {
            return;
        }
        Map<String, Map<String, String>> uuidToDataSourceProps = this.dataGripDataSourceConfigXmlService.buildIdeaConfigProps(ideaDirectory.toString());
        for (Map<String, String> dataSourceProps : uuidToDataSourceProps.values()) {
            ImportConnectionInfo connectionInfo = this.dataGripDataSourceConfigXmlService.buildIdeaConnectionFromProps(dataSourceProps);
            importData.addDriver(connectionInfo.getDriverInfo());
            importData.addConnection(connectionInfo);
        }
    }
}

