/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.registry;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ui.IWorkbenchSite;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.impl.AbstractContextDescriptor;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorPresentation;
import org.jkiss.dbeaver.ui.editors.sql.registry.SQLPresentationPanelDescriptor;
import org.jkiss.utils.CommonUtils;

public class SQLPresentationDescriptor
extends AbstractContextDescriptor {
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.sqlPresentation";
    private final String id;
    private final String label;
    private final String description;
    private final AbstractDescriptor.ObjectType implClass;
    private final DBPImage icon;
    private final int order;
    private final List<SQLPresentationPanelDescriptor> panels = new ArrayList<SQLPresentationPanelDescriptor>();
    private final Expression enabledWhen;
    private final QueryMode queryMode;
    private final String settingKey;
    private final String prefLabel;
    private final String prefTip;

    public SQLPresentationDescriptor(IConfigurationElement config) {
        super(config);
        this.id = config.getAttribute("id");
        this.label = config.getAttribute("label");
        this.description = config.getAttribute("description");
        this.implClass = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("class"));
        this.icon = this.iconToImage(config.getAttribute("icon"));
        this.order = CommonUtils.toInt((Object)config.getAttribute("order"));
        IConfigurationElement[] iConfigurationElementArray = config.getChildren("panel");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement panelConfig = iConfigurationElementArray[n2];
            this.panels.add(new SQLPresentationPanelDescriptor(panelConfig));
            ++n2;
        }
        this.enabledWhen = SQLPresentationDescriptor.getEnablementExpression((IConfigurationElement)config);
        this.queryMode = (QueryMode)CommonUtils.valueOf(QueryMode.class, (String)config.getAttribute("queryMode"), (Enum)QueryMode.MULTIPLE);
        this.settingKey = config.getAttribute("settingKey");
        this.prefLabel = config.getAttribute("prefLabel");
        this.prefTip = config.getAttribute("prefTooltip");
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public DBPImage getIcon() {
        return this.icon;
    }

    public int getOrder() {
        return this.order;
    }

    public List<SQLPresentationPanelDescriptor> getPanels() {
        return this.panels;
    }

    @Nullable
    public Expression getEnabledWhen() {
        return this.enabledWhen;
    }

    public boolean isEnabled(@NotNull IWorkbenchSite site) {
        return SQLPresentationDescriptor.isExpressionTrue((Expression)this.enabledWhen, (Object)site);
    }

    public String getSettingKey() {
        return this.settingKey;
    }

    public String getPrefLabel() {
        return this.prefLabel;
    }

    public String getPrefTip() {
        return this.prefTip;
    }

    @NotNull
    public QueryMode getQueryMode() {
        return this.queryMode;
    }

    public SQLEditorPresentation createPresentation() throws DBException {
        return (SQLEditorPresentation)this.implClass.createInstance(SQLEditorPresentation.class);
    }

    public static enum QueryMode {
        SINGLE,
        MULTIPLE,
        NONE;

    }
}

