/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Properties;
import org.hibernate.boot.registry.selector.spi.StrategyCreator;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.service.spi.ServiceException;
import org.jboss.logging.Logger;

public class StrategyCreatorRegionFactoryImpl
implements StrategyCreator<RegionFactory> {
    private static final Logger log = Logger.getLogger(StrategyCreatorRegionFactoryImpl.class);
    private final Properties properties;

    public StrategyCreatorRegionFactoryImpl(Properties properties) {
        this.properties = properties;
    }

    @Override
    public RegionFactory create(Class<? extends RegionFactory> strategyClass) {
        assert (RegionFactory.class.isAssignableFrom(strategyClass));
        RegionFactory regionFactoryWithProperties = this.instantiateWithProperties(strategyClass, Properties.class);
        if (regionFactoryWithProperties != null) {
            return regionFactoryWithProperties;
        }
        RegionFactory regionFactoryWithMap = this.instantiateWithProperties(strategyClass, Map.class);
        if (regionFactoryWithMap != null) {
            return regionFactoryWithMap;
        }
        try {
            return strategyClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ServiceException("Unable to call constructor of RegionFactory impl [" + strategyClass.getName() + "]", e);
        }
    }

    private RegionFactory instantiateWithProperties(Class<? extends RegionFactory> strategyClass, Class<?> propertiesClass) {
        try {
            return strategyClass.getConstructor(propertiesClass).newInstance(this.properties);
        }
        catch (NoSuchMethodException e) {
            log.debugf("RegionFactory impl [%s] did not provide constructor accepting Properties", (Object)strategyClass.getName());
            return null;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new ServiceException("Unable to call constructor of RegionFactory impl [" + strategyClass.getName() + "]", e);
        }
    }
}

