/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.sdjwt;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.keycloak.common.VerificationException;
import org.keycloak.crypto.SignatureSignerContext;
import org.keycloak.crypto.SignatureVerifierContext;
import org.keycloak.jose.jws.JWSHeader;
import org.keycloak.sdjwt.DecoyClaim;
import org.keycloak.sdjwt.DisclosureSpec;
import org.keycloak.sdjwt.IssuerSignedJWT;
import org.keycloak.sdjwt.IssuerSignedJwtVerificationOpts;
import org.keycloak.sdjwt.JwsToken;
import org.keycloak.sdjwt.SdJwtClaim;
import org.keycloak.sdjwt.SdJwtUtils;
import org.keycloak.sdjwt.SdJwtVerificationContext;
import org.keycloak.sdjwt.vp.KeyBindingJWT;
import org.keycloak.util.JsonSerialization;

public class SdJwt {
    public static final int DEFAULT_NUMBER_OF_DECOYS = 5;
    private final IssuerSignedJWT issuerSignedJWT;
    private final List<SdJwtClaim> claims;
    private final List<String> disclosures;
    private SdJwtVerificationContext sdJwtVerificationContext;
    private KeyBindingJWT keyBindingJWT;
    private Optional<String> sdJwtString = Optional.empty();

    public SdJwt(IssuerSignedJWT issuerSignedJWT, KeyBindingJWT keyBindingJWT) {
        this(issuerSignedJWT, keyBindingJWT, null);
    }

    public SdJwt(IssuerSignedJWT issuerSignedJWT, KeyBindingJWT keyBindingJWT, List<SdJwt> nesteSdJwts) {
        this.issuerSignedJWT = issuerSignedJWT;
        this.claims = issuerSignedJWT.getDisclosureClaims();
        this.keyBindingJWT = keyBindingJWT;
        this.disclosures = new ArrayList<String>();
        Optional.ofNullable(nesteSdJwts).ifPresent(nestedSdJwtList -> nestedSdJwtList.forEach(nestedJwt -> this.disclosures.addAll(nestedJwt.getDisclosures())));
        this.disclosures.addAll(SdJwt.getDisclosureStrings(this.claims));
        this.sdJwtVerificationContext = new SdJwtVerificationContext(this.issuerSignedJWT, this.disclosures);
    }

    public SdJwt(ObjectNode claimSet, KeyBindingJWT keyBindingJWT) {
        this(new IssuerSignedJWT(new JWSHeader(), claimSet), keyBindingJWT, null);
    }

    public SdJwt(ObjectNode claimSet, KeyBindingJWT keyBindingJWT, List<SdJwt> nesteSdJwts) {
        this(new IssuerSignedJWT(new JWSHeader(), claimSet), keyBindingJWT, nesteSdJwts);
    }

    public SdJwt(IssuerSignedJWT issuerSignedJWT, KeyBindingJWT keyBindingJWT, List<SdJwtClaim> claims, List<String> disclosures) {
        this.issuerSignedJWT = issuerSignedJWT;
        this.keyBindingJWT = keyBindingJWT;
        this.claims = claims;
        this.disclosures = disclosures;
    }

    private List<DecoyClaim> createdDecoyClaims(DisclosureSpec disclosureSpec) {
        return disclosureSpec.getDecoyClaims().stream().map(disclosureData -> DecoyClaim.builder().withSalt(disclosureData.getSalt()).build()).collect(Collectors.toList());
    }

    public JsonNode asNestedPayload() {
        JsonNode nestedPayload = (JsonNode)JsonSerialization.mapper.convertValue((Object)this.issuerSignedJWT.getPayload(), JsonNode.class);
        ((ObjectNode)nestedPayload).remove("_sd_alg");
        return nestedPayload;
    }

    public String toSdJwtString() {
        ArrayList<String> parts = new ArrayList<String>();
        parts.add(this.issuerSignedJWT.getJws());
        parts.addAll(this.disclosures);
        parts.add(Optional.ofNullable(this.keyBindingJWT).map(JwsToken::getJws).orElse(""));
        return String.join((CharSequence)"~", parts);
    }

    private static List<String> getDisclosureStrings(List<SdJwtClaim> claims) {
        ArrayList disclosureStrings = new ArrayList();
        claims.stream().map(SdJwtClaim::getDisclosureStrings).forEach(disclosureStrings::addAll);
        return Collections.unmodifiableList(disclosureStrings);
    }

    public KeyBindingJWT getKeybindingJwt() {
        return this.keyBindingJWT;
    }

    public void setKeybindingJwt(KeyBindingJWT keybindingJwt) {
        this.keyBindingJWT = keybindingJwt;
    }

    public List<SdJwtClaim> getClaims() {
        return this.claims;
    }

    public SdJwtVerificationContext getSdJwtVerificationContext() {
        return this.sdJwtVerificationContext;
    }

    public void setSdJwtVerificationContext(SdJwtVerificationContext sdJwtVerificationContext) {
        this.sdJwtVerificationContext = sdJwtVerificationContext;
    }

    public Optional<String> getSdJwtString() {
        return this.sdJwtString;
    }

    public void setSdJwtString(Optional<String> sdJwtString) {
        this.sdJwtString = sdJwtString;
    }

    public String toString() {
        return this.sdJwtString.orElseGet(() -> {
            String sdString = this.toSdJwtString();
            this.sdJwtString = Optional.of(sdString);
            return sdString;
        });
    }

    public IssuerSignedJWT getIssuerSignedJWT() {
        return this.issuerSignedJWT;
    }

    public List<String> getDisclosures() {
        return this.disclosures;
    }

    public void verify(List<SignatureVerifierContext> issuerVerifyingKeys, IssuerSignedJwtVerificationOpts verificationOpts) throws VerificationException {
        this.sdJwtVerificationContext.verifyIssuance(issuerVerifyingKeys, verificationOpts, null);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final List<SdJwt> nestedSdJwts = new ArrayList<SdJwt>();
        private IssuerSignedJWT issuerSignedJwt;
        private KeyBindingJWT keyBindingJWT;
        private SignatureSignerContext issuerSigningContext;
        private SignatureSignerContext keyBindingSigningContext;
        private String sdHashAlgorithm;
        private boolean useDefaultDecoys = true;

        public Builder withIssuerSignedJwt(IssuerSignedJWT issuerSignedJwt) {
            this.issuerSignedJwt = issuerSignedJwt;
            return this;
        }

        public Builder withKeybindingJwt(KeyBindingJWT keybindingJwt) {
            this.keyBindingJWT = keybindingJwt;
            return this;
        }

        public Builder withNestedSdJwt(SdJwt nestedSdJwt) {
            this.nestedSdJwts.add(nestedSdJwt);
            return this;
        }

        public Builder withIssuerSigningContext(SignatureSignerContext issuerSigningContext) {
            this.issuerSigningContext = issuerSigningContext;
            return this;
        }

        public Builder withKeyBindingSigningContext(SignatureSignerContext keyBindingSigningContext) {
            this.keyBindingSigningContext = keyBindingSigningContext;
            return this;
        }

        public Builder withSdHashAlgorithm(String sdHashAlgorithm) {
            this.sdHashAlgorithm = sdHashAlgorithm;
            return this;
        }

        public Builder withUseDefaultDecoys(boolean useDefaultDecoys) {
            this.useDefaultDecoys = useDefaultDecoys;
            return this;
        }

        public SdJwt build() {
            int numberOfDecoys = Optional.ofNullable(this.issuerSignedJwt.getDecoyClaims()).map(List::size).orElse(0);
            if (this.useDefaultDecoys && numberOfDecoys == 0) {
                ArrayList<DecoyClaim> decoyClaims = new ArrayList<DecoyClaim>();
                for (int i = 0; i < 5; ++i) {
                    decoyClaims.add(DecoyClaim.builder().build());
                }
                this.issuerSignedJwt.setDisclosureClaims(this.issuerSignedJwt.getDisclosureSpec(), this.issuerSignedJwt.getDisclosureClaims(), decoyClaims);
            }
            SdJwt sdJwt = new SdJwt(this.issuerSignedJwt, this.keyBindingJWT, this.nestedSdJwts);
            AtomicInteger signCounter = new AtomicInteger(0);
            Optional.ofNullable(this.keyBindingJWT).ifPresent(keyBindJwt -> {
                String hashAlgorithm = this.getEffectiveHashAlgorithm(this.sdHashAlgorithm);
                this.issuerSignedJwt.getPayload().put("_sd_alg", hashAlgorithm);
                if (this.issuerSigningContext != null) {
                    this.issuerSignedJwt.sign(this.issuerSigningContext);
                }
                signCounter.incrementAndGet();
                ArrayList<String> parts = new ArrayList<String>();
                parts.add(sdJwt.getIssuerSignedJWT().getJws());
                parts.addAll(sdJwt.getDisclosures());
                parts.add("");
                String sdHashString = String.join((CharSequence)"~", parts);
                String sdHash = SdJwtUtils.hashAndBase64EncodeNoPad(sdHashString.getBytes(), hashAlgorithm);
                keyBindJwt.getPayload().put("sd_hash", sdHash);
                Optional.ofNullable(this.keyBindingSigningContext).ifPresent(keyBindJwt::sign);
            });
            if (this.issuerSigningContext != null && signCounter.get() == 0) {
                this.issuerSignedJwt.sign(this.issuerSigningContext);
            }
            sdJwt.setKeybindingJwt(this.keyBindingJWT);
            return sdJwt;
        }

        private String getEffectiveHashAlgorithm(String sdHashAlgorithm) {
            return Optional.ofNullable(sdHashAlgorithm).orElseGet(() -> this.issuerSignedJwt.getSdHashAlgorithm().orElse("sha-256"));
        }
    }
}

