// This file is part of libigl, a simple c++ geometry processing library.
// 
// Copyright (C) 2015 Alec Jacobson <alecjacobson@gmail.com>
// 
// This Source Code Form is subject to the terms of the Mozilla Public License 
// v. 2.0. If a copy of the MPL was not distributed with this file, You can 
// obtain one at http://mozilla.org/MPL/2.0/.
#include "look_at.h"

template <
  typename Derivedeye,
  typename Derivedcenter,
  typename Derivedup,
  typename DerivedR>
IGL_INLINE void igl::look_at(
  const Eigen::MatrixBase<Derivedeye> & eye,
  const Eigen::MatrixBase<Derivedcenter> & center,
  const Eigen::MatrixBase<Derivedup> & up,
  Eigen::PlainObjectBase<DerivedR> & R)
{
  typedef Eigen::Matrix<typename DerivedR::Scalar,3,1> Vector3S;
  Vector3S f = (center - eye).normalized();
  Vector3S s = f.cross(up).normalized();
  Vector3S u = s.cross(f);
  R = Eigen::Matrix<typename DerivedR::Scalar,4,4>::Identity();
  R(0,0) = s(0);
  R(0,1) = s(1);
  R(0,2) = s(2);
  R(1,0) = u(0);
  R(1,1) = u(1);
  R(1,2) = u(2);
  R(2,0) =-f(0);
  R(2,1) =-f(1);
  R(2,2) =-f(2);
  R(0,3) =-s.transpose() * eye;
  R(1,3) =-u.transpose() * eye;
  R(2,3) = f.transpose() * eye;
}

#ifdef IGL_STATIC_LIBRARY
// Explicit template instantiation
// generated by autoexplicit.sh
template void igl::look_at<Eigen::Matrix<float, 3, 1, 0, 3, 1>, Eigen::Matrix<float, 3, 1, 0, 3, 1>, Eigen::Matrix<float, 3, 1, 0, 3, 1>, Eigen::Matrix<float, 4, 4, 0, 4, 4> >(Eigen::MatrixBase<Eigen::Matrix<float, 3, 1, 0, 3, 1> > const&, Eigen::MatrixBase<Eigen::Matrix<float, 3, 1, 0, 3, 1> > const&, Eigen::MatrixBase<Eigen::Matrix<float, 3, 1, 0, 3, 1> > const&, Eigen::PlainObjectBase<Eigen::Matrix<float, 4, 4, 0, 4, 4> >&);
#endif
