/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.internal.asn1;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import oracle.security.pki.internal.asn1.ASN1Constructed;
import oracle.security.pki.internal.asn1.ASN1ConstructedInputStream;
import oracle.security.pki.internal.asn1.ASN1FormatException;
import oracle.security.pki.internal.asn1.ASN1Header;
import oracle.security.pki.internal.asn1.ASN1Object;
import oracle.security.pki.internal.asn1.ASN1Set;
import oracle.security.pki.internal.asn1.ASN1TaggedObject;
import oracle.security.pki.internal.asn1.ASN1Utils;
import oracle.security.pki.util.Utils;

public class ASN1GenericConstructed
implements ASN1Constructed,
ASN1TaggedObject {
    private ArrayList<ASN1Object> a = new ArrayList();
    private int b = 0;
    private ASN1Header c = null;
    private int d;
    private int e;
    private int f = 0;
    private ASN1Object[] g = null;

    public ASN1GenericConstructed(int n) {
        this(n, 128);
    }

    public ASN1GenericConstructed(int n, int n2) {
        this.d = n;
        this.e = n2;
    }

    public ASN1GenericConstructed(ASN1Object aSN1Object, int n) {
        this(aSN1Object, n, 128);
    }

    public ASN1GenericConstructed(ASN1Object aSN1Object, int n, int n2) {
        this(n, n2);
        this.a(aSN1Object);
    }

    public ASN1GenericConstructed(List<? extends ASN1Object> list, int n) {
        this(list, n, 128);
    }

    public ASN1GenericConstructed(List<? extends ASN1Object> list, int n, int n2) {
        this(n, n2);
        this.a = list == null ? null : new ArrayList<ASN1Object>(list);
        this.b = 0;
        int n3 = this.a.size();
        for (int i = 0; i < n3; ++i) {
            this.b += this.a.get(i).length();
        }
    }

    public ASN1GenericConstructed(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public ASN1GenericConstructed(byte[] byArray) throws IOException {
        this.input(new ByteArrayInputStream(byArray));
    }

    @Override
    public ASN1Header a() {
        if (this.c == null) {
            this.c = new ASN1Header(this.d, this.e, 1, this.b);
        }
        return this.c;
    }

    private ASN1Object[] i() {
        if (this.g == null) {
            this.g = ASN1Set.a(this.a, this.f);
        }
        return this.g;
    }

    public int d() {
        return this.d;
    }

    public int e() {
        return this.e;
    }

    @Override
    public ArrayList<ASN1Object> b() {
        return this.a;
    }

    @Override
    public int c() {
        return this.a.size();
    }

    @Override
    public ASN1Object a(int n) {
        return this.a.get(n);
    }

    public ASN1Object f() {
        return this.a.get(0);
    }

    public ASN1Object g() {
        return this.a.get(this.a.size() - 1);
    }

    public void a(ASN1Object aSN1Object) {
        this.a.add(aSN1Object);
        this.b += aSN1Object.length();
        this.c = null;
        this.g = null;
    }

    public void b(int n) {
        this.f = n;
    }

    public int h() {
        return this.f;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("GENERIC CONSTRUCTED [");
        switch (this.e) {
            case 0: {
                stringBuffer.append("UNIVERSAL");
                break;
            }
            case 64: {
                stringBuffer.append("APPLICATION");
                break;
            }
            case 128: {
                stringBuffer.append("CONTEXT SPECIFIC");
                break;
            }
            case 192: {
                stringBuffer.append("PRIVATE");
                break;
            }
            default: {
                stringBuffer.append(this.e);
            }
        }
        stringBuffer.append(' ');
        stringBuffer.append(this.d);
        stringBuffer.append("] ");
        stringBuffer.append(Utils.toString(this.a));
        return stringBuffer.toString();
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        ASN1Header aSN1Header = new ASN1Header(inputStream);
        if (aSN1Header.c() == 0) {
            throw new ASN1FormatException("Constructed encoding expected.");
        }
        ASN1ConstructedInputStream aSN1ConstructedInputStream = new ASN1ConstructedInputStream(inputStream, aSN1Header);
        this.d = aSN1Header.a();
        this.e = aSN1Header.b();
        this.a = new ArrayList();
        this.b = 0;
        while (aSN1ConstructedInputStream.a()) {
            ASN1Object aSN1Object = ASN1Utils.a(aSN1ConstructedInputStream);
            this.a.add(aSN1Object);
            this.b += aSN1Object.length();
        }
        aSN1ConstructedInputStream.b();
        this.c = null;
        this.g = null;
    }

    @Override
    public int length() {
        return this.a().g();
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.a().output(outputStream);
        if (this.f == 0) {
            int n = this.a.size();
            for (int i = 0; i < n; ++i) {
                this.a.get(i).output(outputStream);
            }
        } else {
            ASN1Object[] aSN1ObjectArray = this.i();
            int n = aSN1ObjectArray.length;
            for (int i = 0; i < n; ++i) {
                aSN1ObjectArray[i].output(outputStream);
            }
        }
    }

    public static void a(OutputStream outputStream, List<? extends ASN1Object> list, int n) throws IOException {
        ASN1GenericConstructed.a(outputStream, list, n, 128);
    }

    public static void a(OutputStream outputStream, List<? extends ASN1Object> list, int n, int n2) throws IOException {
        int n3;
        int n4 = 0;
        int n5 = list.size();
        for (n3 = 0; n3 < n5; ++n3) {
            n4 += list.get(n3).length();
        }
        outputStream.write(32 + n2 + n);
        ASN1Utils.a(outputStream, n4);
        n5 = list.size();
        for (n3 = 0; n3 < n5; ++n3) {
            list.get(n3).output(outputStream);
        }
    }
}

