/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.typing;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotRichCompare;
import com.oracle.graal.python.builtins.objects.typing.PParamSpecKwargs;
import com.oracle.graal.python.builtins.objects.typing.ParamSpecArgsBuiltins;
import com.oracle.graal.python.builtins.objects.typing.ParamSpecKwargsBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.typing.ParamSpecKwargsBuiltinsSlotsGen;
import com.oracle.graal.python.lib.PyObjectRichCompareBool;
import com.oracle.graal.python.lib.RichCmpOp;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PParamSpecKwargs})
public final class ParamSpecKwargsBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = ParamSpecKwargsBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return ParamSpecKwargsBuiltinsFactory.getFactories();
    }

    @Slot(value=Slot.SlotKind.tp_richcompare, isComplex=true)
    @GenerateNodeFactory
    public static abstract class EqNode
    extends TpSlotRichCompare.RichCmpBuiltinNode {
        @Specialization
        static Object doIt(VirtualFrame frame, PParamSpecKwargs self, PParamSpecKwargs other, RichCmpOp op, @Bind Node inliningTarget, @Cached PyObjectRichCompareBool eqNode) {
            return eqNode.execute((Frame)frame, inliningTarget, self.origin, other.origin, op);
        }

        @Fallback
        static PNotImplemented wrongTypes(Object self, Object other, RichCmpOp op) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtin(name="__mro_entries__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class MroEntriesNode
    extends PythonBinaryBuiltinNode {
        MroEntriesNode() {
        }

        @Specialization
        static Object mro(PParamSpecKwargs self, Object bases, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.CANNOT_SUBCLASS_AN_INSTANCE_OF_PARAMSPEC_KWARGS);
        }
    }

    @Slot(value=Slot.SlotKind.tp_repr, isComplex=true)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        private static final TruffleString T_KWARGS = PythonUtils.tsLiteral(".kwargs");

        ReprNode() {
        }

        @Specialization
        static TruffleString reprParamSpec(VirtualFrame frame, PParamSpecKwargs self, @Bind Node inliningTarget, @Cached ParamSpecArgsBuiltins.GetOriginNameHelperNode helper, @Cached TruffleString.ConcatNode concatNode) {
            return concatNode.execute((AbstractTruffleString)helper.execute(frame, inliningTarget, self.origin), (AbstractTruffleString)T_KWARGS, PythonUtils.TS_ENCODING, true);
        }
    }

    @Builtin(name="__origin__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetNameNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object doOrigin(PParamSpecKwargs self) {
            return self.origin;
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(name="ParamSpecKwargs", minNumOfPositionalArgs=2, parameterNames={"$cls", "origin"})
    @GenerateNodeFactory
    static abstract class ParamSpecKwargsNode
    extends PythonBinaryBuiltinNode {
        ParamSpecKwargsNode() {
        }

        @Specialization
        static PParamSpecKwargs newParamSpecKwargs(Object cls, Object origin, @Bind PythonLanguage language, @Cached TypeNodes.GetInstanceShape getInstanceShape) {
            return PFactory.createParamSpecKwargs(language, cls, getInstanceShape.execute(cls), origin);
        }
    }
}

