/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2;

import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaRuntime;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaThread;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Prototype;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.internal.JSystem;
import org.luaj.vm2.internal.ToolsKt;
import org.luaj.vm2.io.LuaBinInput;
import org.luaj.vm2.io.LuaReader;
import org.luaj.vm2.io.LuaWriter;
import org.luaj.vm2.io.StrLuaReader;
import org.luaj.vm2.lib.BaseLib;
import org.luaj.vm2.lib.DebugLib;
import org.luaj.vm2.lib.PackageLib;
import org.luaj.vm2.lib.ResourceFinder;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u0001:\u0006012345B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001c\u001a\u00020\u0000H\u0016J\u0016\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020!J\u0016\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#2\u0006\u0010 \u001a\u00020!J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020!H\u0016J\u0018\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020!2\u0006\u0010 \u001a\u00020!H\u0016J\u001e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020!2\u0006\u0010 \u001a\u00020!2\u0006\u0010'\u001a\u00020\u0001J&\u0010$\u001a\u00020%2\u0006\u0010(\u001a\u00020\b2\u0006\u0010 \u001a\u00020!2\u0006\u0010)\u001a\u00020!2\u0006\u0010'\u001a\u00020%J\u0016\u0010$\u001a\u00020%2\u0006\u0010\"\u001a\u00020#2\u0006\u0010 \u001a\u00020!J\u001e\u0010$\u001a\u00020%2\u0006\u0010\"\u001a\u00020#2\u0006\u0010 \u001a\u00020!2\u0006\u0010'\u001a\u00020\u0001J\u001e\u0010*\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020\b2\u0006\u0010 \u001a\u00020!2\u0006\u0010)\u001a\u00020!J\u000e\u0010+\u001a\u00020%2\u0006\u0010,\u001a\u00020!J\u000e\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.R\u0012\u0010\u0005\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u0004\u0018\u00010\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u0004\u0018\u00010\r8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u0004\u0018\u00010\u000f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u0004\u0018\u00010\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u00138\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u0004\u0018\u00010\u00158\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0016\u001a\u00020\u00178\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u0004\u0018\u00010\u001b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lorg/luaj/vm2/Globals;", "Lorg/luaj/vm2/LuaTable;", "runtime", "Lorg/luaj/vm2/LuaRuntime;", "(Lorg/luaj/vm2/LuaRuntime;)V", "STDERR", "Lorg/luaj/vm2/io/LuaWriter;", "STDIN", "Lorg/luaj/vm2/io/LuaBinInput;", "STDOUT", "baselib", "Lorg/luaj/vm2/lib/BaseLib;", "compiler", "Lorg/luaj/vm2/Globals$Compiler;", "debuglib", "Lorg/luaj/vm2/lib/DebugLib;", "finder", "Lorg/luaj/vm2/lib/ResourceFinder;", "loader", "Lorg/luaj/vm2/Globals$Loader;", "package_", "Lorg/luaj/vm2/lib/PackageLib;", "running", "Lorg/luaj/vm2/LuaThread;", "getRuntime", "()Lorg/luaj/vm2/LuaRuntime;", "undumper", "Lorg/luaj/vm2/Globals$Undumper;", "checkglobals", "compilePrototype", "Lorg/luaj/vm2/Prototype;", "stream", "chunkname", "", "reader", "Lorg/luaj/vm2/io/LuaReader;", "load", "Lorg/luaj/vm2/LuaValue;", "script", "environment", "is", "mode", "loadPrototype", "loadfile", "filename", "yield", "Lorg/luaj/vm2/Varargs;", "args", "AbstractBufferedStream", "BufferedStream", "Compiler", "Loader", "UTF8Stream", "Undumper", "luak"})
public class Globals
extends LuaTable {
    @NotNull
    private final LuaRuntime runtime;
    @JvmField
    @NotNull
    public LuaBinInput STDIN;
    @JvmField
    @NotNull
    public LuaWriter STDOUT;
    @JvmField
    @NotNull
    public LuaWriter STDERR;
    @JvmField
    @Nullable
    public ResourceFinder finder;
    @JvmField
    @NotNull
    public LuaThread running;
    @JvmField
    @Nullable
    public BaseLib baselib;
    @JvmField
    @Nullable
    public PackageLib package_;
    @JvmField
    @Nullable
    public DebugLib debuglib;
    @JvmField
    @Nullable
    public Loader loader;
    @JvmField
    @Nullable
    public Compiler compiler;
    @JvmField
    @Nullable
    public Undumper undumper;

    public Globals(@NotNull LuaRuntime runtime) {
        this.runtime = runtime;
        this.STDIN = JSystem.INSTANCE.getIn();
        this.STDOUT = JSystem.INSTANCE.getOut();
        this.STDERR = JSystem.INSTANCE.getErr();
        this.running = new LuaThread(this);
    }

    public /* synthetic */ Globals(LuaRuntime luaRuntime, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            luaRuntime = new LuaRuntime();
        }
        this(luaRuntime);
    }

    @NotNull
    public final LuaRuntime getRuntime() {
        return this.runtime;
    }

    @Override
    @NotNull
    public Globals checkglobals() {
        return this;
    }

    @NotNull
    public final LuaValue loadfile(@NotNull String filename) {
        LuaValue luaValue;
        try {
            ResourceFinder resourceFinder = this.finder;
            Intrinsics.checkNotNull(resourceFinder);
            LuaBinInput luaBinInput = resourceFinder.findResource(filename);
            Intrinsics.checkNotNull(luaBinInput);
            luaValue = this.load(luaBinInput, '@' + filename, "bt", this);
        }
        catch (Exception e) {
            luaValue = LuaValue.Companion.error("load " + filename + ": " + e);
        }
        return luaValue;
    }

    @NotNull
    public LuaValue load(@NotNull String script, @NotNull String chunkname) {
        return this.load(new StrLuaReader(script), chunkname);
    }

    @NotNull
    public LuaValue load(@NotNull String script) {
        return this.load(new StrLuaReader(script), script);
    }

    @NotNull
    public final LuaValue load(@NotNull String script, @NotNull String chunkname, @NotNull LuaTable environment) {
        return this.load(new StrLuaReader(script), chunkname, environment);
    }

    @NotNull
    public final LuaValue load(@NotNull LuaReader reader, @NotNull String chunkname) {
        return this.load(new UTF8Stream(reader), chunkname, "t", this);
    }

    @NotNull
    public final LuaValue load(@NotNull LuaReader reader, @NotNull String chunkname, @NotNull LuaTable environment) {
        return this.load(new UTF8Stream(reader), chunkname, "t", environment);
    }

    @NotNull
    public final LuaValue load(@NotNull LuaBinInput is, @NotNull String chunkname, @NotNull String mode, @NotNull LuaValue environment) {
        try {
            Loader loader = this.loader;
            Intrinsics.checkNotNull(loader);
            return loader.load(this.loadPrototype(is, chunkname, mode), chunkname, environment);
        }
        catch (LuaError l) {
            throw l;
        }
        catch (Exception e) {
            e.printStackTrace();
            return LuaValue.Companion.error("load " + chunkname + ": " + e);
        }
    }

    @NotNull
    public final Prototype loadPrototype(@NotNull LuaBinInput is, @NotNull String chunkname, @NotNull String mode) {
        LuaBinInput is2 = is;
        if (StringsKt.indexOf$default((CharSequence)mode, 'b', 0, false, 6, null) >= 0) {
            Prototype p;
            if (this.undumper == null) {
                LuaValue.Companion.error("No undumper.");
            }
            if (!is2.markSupported()) {
                is2 = new BufferedStream(is2);
            }
            is2.mark(4);
            Undumper undumper = this.undumper;
            Intrinsics.checkNotNull(undumper);
            Prototype prototype = p = undumper.undump(is2, chunkname);
            if (prototype != null) {
                return prototype;
            }
            is2.reset();
        }
        if (StringsKt.indexOf$default((CharSequence)mode, 't', 0, false, 6, null) >= 0) {
            return this.compilePrototype(is2, chunkname);
        }
        LuaValue.Companion.error("Failed to load prototype " + chunkname + " using mode '" + mode + '\'');
        throw new IllegalStateException(("Failed to load prototype " + chunkname + " using mode '" + mode + '\'').toString());
    }

    @NotNull
    public final Prototype compilePrototype(@NotNull LuaReader reader, @NotNull String chunkname) {
        return this.compilePrototype(new UTF8Stream(reader), chunkname);
    }

    @NotNull
    public final Prototype compilePrototype(@NotNull LuaBinInput stream, @NotNull String chunkname) {
        if (this.compiler == null) {
            LuaValue.Companion.error("No compiler.");
        }
        Compiler compiler = this.compiler;
        Intrinsics.checkNotNull(compiler);
        return compiler.compile(stream, chunkname);
    }

    @NotNull
    public final Varargs yield(@NotNull Varargs args2) {
        if (this.running.isMainThread()) {
            throw new LuaError("cannot yield main thread");
        }
        LuaThread.State s = this.running.state;
        return s.lua_yield(args2);
    }

    public Globals() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&\u00a8\u0006\n"}, d2={"Lorg/luaj/vm2/Globals$Loader;", "", "load", "Lorg/luaj/vm2/LuaFunction;", "prototype", "Lorg/luaj/vm2/Prototype;", "chunkname", "", "env", "Lorg/luaj/vm2/LuaValue;", "luak"})
    public static interface Loader {
        @NotNull
        public LuaFunction load(@NotNull Prototype var1, @NotNull String var2, @NotNull LuaValue var3);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\b"}, d2={"Lorg/luaj/vm2/Globals$Compiler;", "", "compile", "Lorg/luaj/vm2/Prototype;", "stream", "Lorg/luaj/vm2/io/LuaBinInput;", "chunkname", "", "luak"})
    public static interface Compiler {
        @NotNull
        public Prototype compile(@NotNull LuaBinInput var1, @NotNull String var2);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u001a\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\b"}, d2={"Lorg/luaj/vm2/Globals$Undumper;", "", "undump", "Lorg/luaj/vm2/Prototype;", "stream", "Lorg/luaj/vm2/io/LuaBinInput;", "chunkname", "", "luak"})
    public static interface Undumper {
        @Nullable
        public Prototype undump(@NotNull LuaBinInput var1, @NotNull String var2);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0011\n\u0002\u0010\t\n\u0002\b\u0002\b \u0018\u00002\u00020\u0001B\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0012\u001a\u00020\u0003H$J\b\u0010\u0013\u001a\u00020\u0003H\u0016J\b\u0010\u0014\u001a\u00020\u0003H\u0016J \u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0003X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u0004R\u001a\u0010\u000f\u001a\u00020\u0003X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\r\"\u0004\b\u0011\u0010\u0004\u00a8\u0006\u001a"}, d2={"Lorg/luaj/vm2/Globals$AbstractBufferedStream;", "Lorg/luaj/vm2/io/LuaBinInput;", "buflen", "", "(I)V", "b", "", "getB", "()[B", "setB", "([B)V", "i", "getI", "()I", "setI", "j", "getJ", "setJ", "avail", "available", "read", "off", "len", "skip", "", "n", "luak"})
    public static abstract class AbstractBufferedStream
    extends LuaBinInput {
        @NotNull
        private byte[] b;
        private int i;
        private int j;

        protected AbstractBufferedStream(int buflen) {
            this.b = new byte[buflen];
        }

        @NotNull
        protected final byte[] getB() {
            return this.b;
        }

        protected final void setB(@NotNull byte[] byArray) {
            this.b = byArray;
        }

        protected final int getI() {
            return this.i;
        }

        protected final void setI(int n) {
            this.i = n;
        }

        protected final int getJ() {
            return this.j;
        }

        protected final void setJ(int n) {
            this.j = n;
        }

        protected abstract int avail();

        @Override
        public int read() {
            int n;
            int a = this.avail();
            boolean bl = false;
            if (a <= 0) {
                n = -1;
            } else {
                int n2 = this.i;
                this.i = n2 + 1;
                n = 0xFF & this.b[n2] & 0xFF;
            }
            return n;
        }

        @Override
        public int read(@NotNull byte[] b, int off, int len) {
            int a = this.avail();
            if (a <= 0) {
                return -1;
            }
            int n_read = Math.min(a, len);
            ToolsKt.arraycopy(this.b, this.i, b, off, n_read);
            this.i += n_read;
            return n_read;
        }

        @Override
        public long skip(long n) {
            long l;
            long it = l = Math.min(n, (long)(this.j - this.i));
            boolean bl = false;
            this.i += (int)it;
            return l;
        }

        @Override
        public int available() {
            return this.j - this.i;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/luaj/vm2/Globals$UTF8Stream;", "Lorg/luaj/vm2/Globals$AbstractBufferedStream;", "r", "Lorg/luaj/vm2/io/LuaReader;", "(Lorg/luaj/vm2/io/LuaReader;)V", "c", "", "avail", "", "close", "", "luak"})
    public static final class UTF8Stream
    extends AbstractBufferedStream {
        @NotNull
        private final LuaReader r;
        @NotNull
        private final char[] c;

        public UTF8Stream(@NotNull LuaReader r) {
            super(96);
            this.r = r;
            this.c = new char[32];
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected int avail() {
            void $this$avail_u24lambda_u240;
            if (this.getI() < this.getJ()) {
                return this.getJ() - this.getI();
            }
            int n = this.r.read(this.c);
            if (n < 0) {
                return -1;
            }
            if (n == 0) {
                int u = this.r.read();
                if (u < 0) {
                    return -1;
                }
                this.c[0] = (char)u;
                n = 1;
            }
            UTF8Stream uTF8Stream = this;
            byte[] byArray = this.getB();
            int n2 = n;
            char[] cArray = this.c;
            LuaString.Companion companion = LuaString.Companion;
            UTF8Stream uTF8Stream2 = this;
            boolean bl = false;
            $this$avail_u24lambda_u240.setI(0);
            int n3 = $this$avail_u24lambda_u240.getI();
            uTF8Stream2.setJ(companion.encodeToUtf8(cArray, n2, byArray, n3));
            return this.getJ();
        }

        @Override
        public void close() {
            this.r.close();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\u0006H\u0014J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0006H\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/luaj/vm2/Globals$BufferedStream;", "Lorg/luaj/vm2/Globals$AbstractBufferedStream;", "s", "Lorg/luaj/vm2/io/LuaBinInput;", "(Lorg/luaj/vm2/io/LuaBinInput;)V", "buflen", "", "(ILorg/luaj/vm2/io/LuaBinInput;)V", "avail", "close", "", "mark", "n", "markSupported", "", "reset", "luak"})
    public static final class BufferedStream
    extends AbstractBufferedStream {
        @NotNull
        private final LuaBinInput s;

        public BufferedStream(int buflen, @NotNull LuaBinInput s) {
            super(buflen);
            this.s = s;
        }

        public BufferedStream(@NotNull LuaBinInput s) {
            this(128, s);
        }

        @Override
        protected int avail() {
            int n;
            if (this.getI() < this.getJ()) {
                return this.getJ() - this.getI();
            }
            if (this.getJ() >= this.getB().length) {
                this.setJ(0);
                this.setI(this.getJ());
            }
            if ((n = this.s.read(this.getB(), this.getJ(), this.getB().length - this.getJ())) < 0) {
                return -1;
            }
            if (n == 0) {
                int u = this.s.read();
                if (u < 0) {
                    return -1;
                }
                this.getB()[this.getJ()] = (byte)u;
                n = 1;
            }
            this.setJ(this.getJ() + n);
            return n;
        }

        @Override
        public void close() {
            this.s.close();
        }

        @Override
        public synchronized void mark(int n) {
            if (this.getI() > 0 || n > this.getB().length) {
                byte[] dest = n > this.getB().length ? new byte[n] : this.getB();
                ToolsKt.arraycopy(this.getB(), this.getI(), dest, 0, this.getJ() - this.getI());
                this.setJ(this.getJ() - this.getI());
                this.setI(0);
                this.setB(dest);
            }
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public synchronized void reset() {
            this.setI(0);
        }
    }
}

