/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.exec.listener;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.ProcessResult;
import org.zeroturnaround.exec.listener.ProcessListener;

public class CompositeProcessListener
extends ProcessListener
implements Cloneable {
    private final List<ProcessListener> children = new CopyOnWriteArrayList<ProcessListener>();

    public CompositeProcessListener() {
    }

    public CompositeProcessListener(List<ProcessListener> children2) {
        this.children.addAll(children2);
    }

    public void add(ProcessListener listener) {
        this.children.add(listener);
    }

    public void remove(ProcessListener listener) {
        this.children.remove(listener);
    }

    public void removeAll(Class<? extends ProcessListener> type2) {
        Iterator<ProcessListener> it = this.children.iterator();
        while (it.hasNext()) {
            if (!type2.isInstance(it.next())) continue;
            it.remove();
        }
    }

    public void clear() {
        this.children.clear();
    }

    public CompositeProcessListener clone() {
        return new CompositeProcessListener(this.children);
    }

    @Override
    public void beforeStart(ProcessExecutor executor) {
        for (ProcessListener child : this.children) {
            child.beforeStart(executor);
        }
    }

    @Override
    public void afterStart(Process process2, ProcessExecutor executor) {
        for (ProcessListener child : this.children) {
            child.afterStart(process2, executor);
        }
    }

    @Override
    public void afterFinish(Process process2, ProcessResult result2) {
        for (ProcessListener child : this.children) {
            child.afterFinish(process2, result2);
        }
    }

    @Override
    public void afterStop(Process process2) {
        for (ProcessListener child : this.children) {
            child.afterStop(process2);
        }
    }
}

