﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/mturk-requester/MTurkRequest.h>
#include <aws/mturk-requester/MTurk_EXPORTS.h>

#include <utility>

namespace Aws {
namespace MTurk {
namespace Model {

/**
 */
class ListHITsForQualificationTypeRequest : public MTurkRequest {
 public:
  AWS_MTURK_API ListHITsForQualificationTypeRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "ListHITsForQualificationType"; }

  AWS_MTURK_API Aws::String SerializePayload() const override;

  AWS_MTURK_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p> The ID of the Qualification type to use when querying HITs. </p>
   */
  inline const Aws::String& GetQualificationTypeId() const { return m_qualificationTypeId; }
  inline bool QualificationTypeIdHasBeenSet() const { return m_qualificationTypeIdHasBeenSet; }
  template <typename QualificationTypeIdT = Aws::String>
  void SetQualificationTypeId(QualificationTypeIdT&& value) {
    m_qualificationTypeIdHasBeenSet = true;
    m_qualificationTypeId = std::forward<QualificationTypeIdT>(value);
  }
  template <typename QualificationTypeIdT = Aws::String>
  ListHITsForQualificationTypeRequest& WithQualificationTypeId(QualificationTypeIdT&& value) {
    SetQualificationTypeId(std::forward<QualificationTypeIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Pagination Token</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  inline bool NextTokenHasBeenSet() const { return m_nextTokenHasBeenSet; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListHITsForQualificationTypeRequest& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> Limit the number of results returned. </p>
   */
  inline int GetMaxResults() const { return m_maxResults; }
  inline bool MaxResultsHasBeenSet() const { return m_maxResultsHasBeenSet; }
  inline void SetMaxResults(int value) {
    m_maxResultsHasBeenSet = true;
    m_maxResults = value;
  }
  inline ListHITsForQualificationTypeRequest& WithMaxResults(int value) {
    SetMaxResults(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_qualificationTypeId;
  bool m_qualificationTypeIdHasBeenSet = false;

  Aws::String m_nextToken;
  bool m_nextTokenHasBeenSet = false;

  int m_maxResults{0};
  bool m_maxResultsHasBeenSet = false;
};

}  // namespace Model
}  // namespace MTurk
}  // namespace Aws
