﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/cloudformation/CloudFormation_EXPORTS.h>
#include <aws/cloudformation/model/ResponseMetadata.h>
#include <aws/cloudformation/model/StackInstanceResourceDriftsSummary.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Xml {
class XmlDocument;
}  // namespace Xml
}  // namespace Utils
namespace CloudFormation {
namespace Model {
class ListStackInstanceResourceDriftsResult {
 public:
  AWS_CLOUDFORMATION_API ListStackInstanceResourceDriftsResult() = default;
  AWS_CLOUDFORMATION_API ListStackInstanceResourceDriftsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);
  AWS_CLOUDFORMATION_API ListStackInstanceResourceDriftsResult& operator=(
      const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);

  ///@{
  /**
   * <p>A list of <code>StackInstanceResourceDriftsSummary</code> structures that
   * contain information about the specified stack instances.</p>
   */
  inline const Aws::Vector<StackInstanceResourceDriftsSummary>& GetSummaries() const { return m_summaries; }
  template <typename SummariesT = Aws::Vector<StackInstanceResourceDriftsSummary>>
  void SetSummaries(SummariesT&& value) {
    m_summariesHasBeenSet = true;
    m_summaries = std::forward<SummariesT>(value);
  }
  template <typename SummariesT = Aws::Vector<StackInstanceResourceDriftsSummary>>
  ListStackInstanceResourceDriftsResult& WithSummaries(SummariesT&& value) {
    SetSummaries(std::forward<SummariesT>(value));
    return *this;
  }
  template <typename SummariesT = StackInstanceResourceDriftsSummary>
  ListStackInstanceResourceDriftsResult& AddSummaries(SummariesT&& value) {
    m_summariesHasBeenSet = true;
    m_summaries.emplace_back(std::forward<SummariesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>If the previous paginated request didn't return all of the remaining results,
   * the response object's <code>NextToken</code> parameter value is set to a token.
   * To retrieve the next set of results, call this action again and assign that
   * token to the request object's <code>NextToken</code> parameter. If there are no
   * remaining results, the previous response object's <code>NextToken</code>
   * parameter is set to <code>null</code>.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListStackInstanceResourceDriftsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const ResponseMetadata& GetResponseMetadata() const { return m_responseMetadata; }
  template <typename ResponseMetadataT = ResponseMetadata>
  void SetResponseMetadata(ResponseMetadataT&& value) {
    m_responseMetadataHasBeenSet = true;
    m_responseMetadata = std::forward<ResponseMetadataT>(value);
  }
  template <typename ResponseMetadataT = ResponseMetadata>
  ListStackInstanceResourceDriftsResult& WithResponseMetadata(ResponseMetadataT&& value) {
    SetResponseMetadata(std::forward<ResponseMetadataT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<StackInstanceResourceDriftsSummary> m_summaries;

  Aws::String m_nextToken;

  ResponseMetadata m_responseMetadata;
  bool m_summariesHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_responseMetadataHasBeenSet = false;
};

}  // namespace Model
}  // namespace CloudFormation
}  // namespace Aws
