/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.deparser;

import java.util.Iterator;
import java.util.stream.Collectors;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.ExpressionVisitorAdapter;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.WithItem;
import net.sf.jsqlparser.util.deparser.AbstractDeParser;
import net.sf.jsqlparser.util.deparser.LimitDeparser;
import net.sf.jsqlparser.util.deparser.OrderByDeParser;

public class DeleteDeParser
extends AbstractDeParser<Delete> {
    private ExpressionVisitor<StringBuilder> expressionVisitor = new ExpressionVisitorAdapter<StringBuilder>();

    public DeleteDeParser() {
        super(new StringBuilder());
    }

    public DeleteDeParser(ExpressionVisitor<StringBuilder> expressionVisitor, StringBuilder buffer) {
        super(buffer);
        this.expressionVisitor = expressionVisitor;
    }

    @Override
    public void deParse(Delete delete) {
        if (delete.getWithItemsList() != null && !delete.getWithItemsList().isEmpty()) {
            this.builder.append("WITH ");
            Iterator<WithItem<?>> iter = delete.getWithItemsList().iterator();
            while (iter.hasNext()) {
                WithItem<?> withItem = iter.next();
                this.builder.append(withItem);
                if (iter.hasNext()) {
                    this.builder.append(",");
                }
                this.builder.append(" ");
            }
        }
        this.builder.append("DELETE");
        if (delete.getOracleHint() != null) {
            this.builder.append(delete.getOracleHint()).append(" ");
        }
        if (delete.getModifierPriority() != null) {
            this.builder.append(" ").append((Object)delete.getModifierPriority());
        }
        if (delete.isModifierQuick()) {
            this.builder.append(" QUICK");
        }
        if (delete.isModifierIgnore()) {
            this.builder.append(" IGNORE");
        }
        if (delete.getTables() != null && !delete.getTables().isEmpty()) {
            this.builder.append(delete.getTables().stream().map(Table::getFullyQualifiedName).collect(Collectors.joining(", ", " ", "")));
        }
        if (delete.getOutputClause() != null) {
            delete.getOutputClause().appendTo(this.builder);
        }
        if (delete.isHasFrom()) {
            this.builder.append(" FROM");
        }
        this.builder.append(" ").append(delete.getTable().toString());
        if (delete.getUsingList() != null && !delete.getUsingList().isEmpty()) {
            this.builder.append(" USING").append(delete.getUsingList().stream().map(Table::toString).collect(Collectors.joining(", ", " ", "")));
        }
        if (delete.getJoins() != null) {
            for (Join join : delete.getJoins()) {
                if (join.isSimple()) {
                    this.builder.append(", ").append(join);
                    continue;
                }
                this.builder.append(" ").append(join);
            }
        }
        this.deparseWhereClause(delete);
        if (delete.getPreferringClause() != null) {
            this.builder.append(" ").append(delete.getPreferringClause());
        }
        if (delete.getOrderByElements() != null) {
            new OrderByDeParser(this.expressionVisitor, this.builder).deParse(delete.getOrderByElements());
        }
        if (delete.getLimit() != null) {
            new LimitDeparser(this.expressionVisitor, this.builder).deParse(delete.getLimit());
        }
        if (delete.getReturningClause() != null) {
            delete.getReturningClause().appendTo(this.builder);
        }
    }

    protected void deparseWhereClause(Delete delete) {
        if (delete.getWhere() != null) {
            this.builder.append(" WHERE ");
            delete.getWhere().accept(this.expressionVisitor, null);
        }
    }

    public ExpressionVisitor<StringBuilder> getExpressionVisitor() {
        return this.expressionVisitor;
    }

    public void setExpressionVisitor(ExpressionVisitor<StringBuilder> visitor) {
        this.expressionVisitor = visitor;
    }
}

