/**
 * @license
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import { getClientMetadata } from './client_metadata.js';
let experimentsPromise;
/**
 * Gets the experiments from the server.
 *
 * The experiments are cached so that they are only fetched once.
 */
export async function getExperiments(server) {
    if (experimentsPromise) {
        return await experimentsPromise;
    }
    experimentsPromise = (async () => {
        const metadata = await getClientMetadata();
        const response = await server.listExperiments(metadata);
        return parseExperiments(response);
    })();
    return await experimentsPromise;
}
function parseExperiments(response) {
    const flags = {};
    for (const flag of response.flags ?? []) {
        if (flag.flagId) {
            flags[flag.flagId] = flag;
        }
    }
    return {
        flags,
        experimentIds: response.experimentIds ?? [],
    };
}
//# sourceMappingURL=experiments.js.map