/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.stream.Collector;
import java.util.stream.Stream;
import javax.annotation.CheckReturnValue;

class AppendOnceList<E>
implements Iterable<E> {
    private final ArrayList<E> buffer;
    private final int size;

    private AppendOnceList() {
        this.buffer = new ArrayList();
        this.size = 0;
    }

    private AppendOnceList(ArrayList<E> items) {
        this.buffer = items;
        this.size = items.size();
    }

    private AppendOnceList(AppendOnceList<E> parent, E element) {
        Preconditions.checkState((parent.buffer.size() == parent.size ? 1 : 0) != 0, (Object)"Can only append an element to the list once");
        this.buffer = parent.buffer;
        this.buffer.add(element);
        this.size = parent.size + 1;
    }

    public static <E> AppendOnceList<E> of() {
        return new AppendOnceList<E>();
    }

    public static <E> AppendOnceList<E> of(E value) {
        return new AppendOnceList<E>().plus(value);
    }

    @CheckReturnValue
    public AppendOnceList<E> plus(E element) {
        return new AppendOnceList<E>(this, element);
    }

    private List<E> getItems() {
        return this.buffer.subList(0, this.size);
    }

    @Override
    public Iterator<E> iterator() {
        return Iterators.unmodifiableIterator(this.getItems().iterator());
    }

    @Override
    public Spliterator<E> spliterator() {
        return this.getItems().spliterator();
    }

    public Stream<E> stream() {
        return this.getItems().stream();
    }

    public int size() {
        return this.size;
    }

    public static <E> Collector<E, ?, AppendOnceList<E>> toAppendOnceList() {
        return Collector.of(ArrayList::new, ArrayList::add, (l, r) -> {
            l.addAll(r);
            return l;
        }, AppendOnceList::new, new Collector.Characteristics[0]);
    }
}

