/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.DataGridBundle;
import com.intellij.database.csv.CsvFormatsSettings;
import com.intellij.database.datagrid.DataGridNotifications;
import com.intellij.database.extractors.DataExtractorFactory;
import com.intellij.database.run.actions.DumpSource;
import com.intellij.database.settings.CsvSettings;
import com.intellij.database.view.ui.DumpDataForm;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentValidator;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.ObjectUtils;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.function.Supplier;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DumpDataDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(DumpDataDialog.class);
    protected final DumpDataForm myForm;
    protected final Project myProject;
    protected final DumpSource<?> mySource;
    private CopyToClipboardAction myCopyToClipboardAction;
    private ComponentValidator myDirectoryPathValidator;

    public DumpDataDialog(@NotNull Project project, @NotNull DumpSource<?> source, @Nullable Component parentComponent) {
        if (project == null) {
            DumpDataDialog.$$$reportNull$$$0(0);
        }
        if (source == null) {
            DumpDataDialog.$$$reportNull$$$0(1);
        }
        super(project, parentComponent, true, DialogWrapper.IdeModalityType.IDE);
        this.myProject = project;
        this.mySource = source;
        this.myForm = this.createForm(source, this.myProject);
        this.setTitle(DataGridBundle.message((String)"settings.database.DumpDialog.title", (Object[])new Object[0]));
        this.setOKButtonText(DataGridBundle.message((String)"settings.database.DumpDialog.DumpToFile", (Object[])new Object[]{DumpSource.getSize(this.mySource)}));
        this.myForm.getExtractorComboBox().addItemListener(e -> this.updateActions());
        this.init();
        this.updateCopyToClipboardButton();
        this.invokeLaterAfterDialogShown(() -> this.myForm.updatePreview());
        this.installValidators();
    }

    @NotNull
    protected DumpDataForm createForm(@NotNull DumpSource<?> source, @NotNull Project project) {
        if (source == null) {
            DumpDataDialog.$$$reportNull$$$0(2);
        }
        if (project == null) {
            DumpDataDialog.$$$reportNull$$$0(3);
        }
        return new DumpDataForm(project, source, () -> this.getWindow(), (CsvFormatsSettings)CsvSettings.getSettings(), this.getDisposable(), false);
    }

    private void installValidators() {
        final JTextField outputDirectoryField = this.myForm.getOutputFileOrDirectoryField();
        Supplier<ValidationInfo> validator = () -> {
            String path = this.getDirPath();
            if (StringUtil.isEmptyOrSpaces((String)path)) {
                return new ValidationInfo(DataGridBundle.message((String)"settings.database.DumpDialog.Errors.DirPathEmpty", (Object[])new Object[0]), (JComponent)outputDirectoryField);
            }
            String message = this.myForm.getOutputPathManager().validatePath(path);
            return message == null ? null : new ValidationInfo(message, (JComponent)outputDirectoryField);
        };
        this.myDirectoryPathValidator = new ComponentValidator(this.getDisposable()).withValidator(validator).installOn((JComponent)outputDirectoryField);
        outputDirectoryField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                ComponentValidator.getInstance((JComponent)outputDirectoryField).ifPresent(ComponentValidator::revalidate);
                DumpDataDialog.this.updateActions();
            }
        });
        this.addDocumentListener(outputDirectoryField);
    }

    private String getDirPath() {
        return OSAgnosticPathUtil.expandUserHome((String)this.myForm.getOutputFileOrDirectoryField().getText().trim());
    }

    private void addDocumentListener(final JTextComponent component) {
        component.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                ComponentValidator.getInstance((JComponent)component).ifPresent(ComponentValidator::revalidate);
                DumpDataDialog.this.updateActions();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/view/ui/DumpDataDialog$2", "textChanged"));
            }
        });
    }

    @Nullable
    protected ValidationInfo doValidate() {
        this.myDirectoryPathValidator.revalidate();
        return this.myDirectoryPathValidator.getValidationInfo();
    }

    private void invokeLaterAfterDialogShown(final @NotNull Runnable action) {
        if (action == null) {
            DumpDataDialog.$$$reportNull$$$0(4);
        }
        final Application application = ApplicationManager.getApplication();
        this.getWindow().addWindowListener(new WindowAdapter(this){

            @Override
            public void windowOpened(WindowEvent e) {
                Window window = e.getWindow();
                application.invokeLater(action, ModalityState.stateForComponent((Component)window));
                window.removeWindowListener(this);
            }
        });
    }

    protected Action @NotNull [] createActions() {
        Action[] actionArray;
        if (DumpSource.getSize(this.mySource) > 1) {
            Action[] actionArray2 = new Action[3];
            actionArray2[0] = this.getOKAction();
            actionArray2[1] = this.getCancelAction();
            actionArray = actionArray2;
            actionArray2[2] = this.getHelpAction();
        } else {
            Action[] actionArray3 = new Action[4];
            actionArray3[0] = this.getOKAction();
            actionArray3[1] = this.getCancelAction();
            actionArray3[2] = this.myCopyToClipboardAction;
            actionArray = actionArray3;
            actionArray3[3] = this.getHelpAction();
        }
        if (actionArray == null) {
            DumpDataDialog.$$$reportNull$$$0(5);
        }
        return actionArray;
    }

    protected void createDefaultActions() {
        super.createDefaultActions();
        this.myCopyToClipboardAction = new CopyToClipboardAction();
    }

    @NotNull
    protected String getHelpId() {
        return "Export_data";
    }

    protected void doOKAction() {
        this.updateActions();
        if (!this.isOKActionEnabled()) {
            return;
        }
        if (!this.checkOverrideFile()) {
            return;
        }
        DataExtractorFactory factory = this.myForm.getFactory();
        if (factory == null) {
            return;
        }
        File file = this.getOutputFileOrDir();
        if (file.exists() && !this.checkFileWritable(file)) {
            super.doOKAction();
            return;
        }
        this.myForm.saveState();
        boolean exists = file.exists();
        if (DumpSource.getSize(this.mySource) == 1 && !file.exists()) {
            try {
                exists = file.createNewFile();
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
                this.showError(file);
            }
        }
        if (exists) {
            ApplicationManager.getApplication().invokeLater(() -> this.exportToFile(factory, file));
        }
        super.doOKAction();
    }

    protected abstract void exportToFile(@NotNull DataExtractorFactory var1, @NotNull File var2);

    private boolean checkFileWritable(@NotNull File file) {
        if (file == null) {
            DumpDataDialog.$$$reportNull$$$0(6);
        }
        if (file.isDirectory()) {
            return true;
        }
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByIoFile(file);
        if (virtualFile == null || !ReadonlyStatusHandler.ensureFilesWritable((Project)this.myProject, (VirtualFile[])new VirtualFile[]{virtualFile})) {
            this.showError(file);
            return false;
        }
        return true;
    }

    private void showError(@NotNull File file) {
        if (file == null) {
            DumpDataDialog.$$$reportNull$$$0(7);
        }
        String message = DataGridBundle.message((String)"settings.database.DumpDialog.CannotWriteFile", (Object[])new Object[]{file.getPath()});
        DataGridNotifications.EXTRACTORS_GROUP.createNotification(message, MessageType.WARNING).setDisplayId("DumpDataDialog.write.failed").notify(this.myProject);
    }

    @NotNull
    private File getOutputFileOrDir() {
        File file = Paths.get(this.getDirPath(), new String[0]).toFile();
        if (file == null) {
            DumpDataDialog.$$$reportNull$$$0(8);
        }
        return file;
    }

    private boolean checkOverrideFile() {
        if (DumpSource.getSize(this.mySource) > 1) {
            return true;
        }
        File file = this.getOutputFileOrDir();
        return !file.exists() || this.askToOverrideFiles(file.getName());
    }

    private boolean askToOverrideFiles(@NotNull String fileName) {
        int res;
        if (fileName == null) {
            DumpDataDialog.$$$reportNull$$$0(9);
        }
        return (res = Messages.showYesNoDialog((Component)this.getRootPane(), (String)DataGridBundle.message((String)"settings.database.DumpDialog.ConfirmReplace.message", (Object[])new Object[]{fileName}), (String)DataGridBundle.message((String)"settings.database.DumpDialog.ConfirmReplace.title", (Object[])new Object[0]), (Icon)Messages.getWarningIcon())) == 0;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        ComboBox<DataExtractorFactory> comboBox = this.myForm.getExtractorComboBox();
        if (comboBox == null) {
            DumpDataDialog.$$$reportNull$$$0(10);
        }
        return comboBox;
    }

    public void doCancelAction() {
        this.myForm.saveState();
        super.doCancelAction();
    }

    private void updateActions() {
        this.updateCopyToClipboardButton();
        this.getOKAction().setEnabled(this.myDirectoryPathValidator.getValidationInfo() == null);
    }

    private void updateCopyToClipboardButton() {
        DataExtractorFactory extractorFactory = (DataExtractorFactory)ObjectUtils.tryCast((Object)this.myForm.getExtractorComboBox().getSelectedItem(), DataExtractorFactory.class);
        this.myCopyToClipboardAction.setEnabled(extractorFactory != null && extractorFactory.supportsText());
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JPanel jPanel = this.myForm.myPanel;
        if (jPanel == null) {
            DumpDataDialog.$$$reportNull$$$0(11);
        }
        return jPanel;
    }

    protected abstract void exportToClipboard(@NotNull DataExtractorFactory var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 8, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/ui/DumpDataDialog";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/ui/DumpDataDialog";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputFileOrDir";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createCenterPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createForm";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invokeLaterAfterDialogShown";
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 11: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkFileWritable";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "showError";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "askToOverrideFiles";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 8, 10, 11 -> new IllegalStateException(string);
        };
    }

    private class CopyToClipboardAction
    extends DialogWrapper.DialogWrapperAction {
        CopyToClipboardAction() {
            super((DialogWrapper)DumpDataDialog.this, DataGridBundle.message((String)"settings.database.DumpDialog.CopyToClipboard", (Object[])new Object[0]));
        }

        protected void doAction(ActionEvent e) {
            DumpDataDialog.this.myForm.saveState();
            DumpDataDialog.this.close(0);
            DataExtractorFactory factory = DumpDataDialog.this.myForm.getFactory();
            if (factory != null) {
                ApplicationManager.getApplication().invokeLater(() -> DumpDataDialog.this.exportToClipboard(factory));
            }
        }
    }
}

