/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.codeInspection;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.codeInspection.GradleInspectionBundle;
import org.jetbrains.plugins.gradle.codeInspection.MultipleRepositoryUrlsInspection;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class MultipleRepositoryUrlsFix
extends GroovyFix {
    private final String myRepoType;

    public MultipleRepositoryUrlsFix(@NotNull String repoType) {
        if (repoType == null) {
            MultipleRepositoryUrlsFix.$$$reportNull$$$0(0);
        }
        this.myRepoType = repoType;
    }

    protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) throws IncorrectOperationException {
        GrClosableBlock closure;
        if (project == null) {
            MultipleRepositoryUrlsFix.$$$reportNull$$$0(1);
        }
        if (descriptor == null) {
            MultipleRepositoryUrlsFix.$$$reportNull$$$0(2);
        }
        if ((closure = (GrClosableBlock)descriptor.getPsiElement()) == null) {
            return;
        }
        List<GrCallExpression> statements = MultipleRepositoryUrlsInspection.findUrlCallExpressions(closure);
        if (statements.size() <= 1) {
            return;
        }
        statements.remove(0);
        ArrayList<GrCallExpression> elements = new ArrayList<GrCallExpression>(statements);
        for (GrCallExpression statement : statements) {
            PsiElement newLineCandidate = statement.getNextSibling();
            if (!PsiUtil.isNewLine((PsiElement)newLineCandidate)) continue;
            elements.add((GrCallExpression)newLineCandidate);
        }
        closure.removeElements(elements.toArray(PsiElement.EMPTY_ARRAY));
        GrClosableBlock closableBlock = (GrClosableBlock)PsiTreeUtil.getParentOfType((PsiElement)closure, GrClosableBlock.class);
        if (closableBlock == null) {
            return;
        }
        GroovyPsiElementFactory elementFactory = GroovyPsiElementFactory.getInstance((Project)project);
        for (GrCallExpression statement : statements) {
            closableBlock.addStatementBefore(elementFactory.createStatementFromText((CharSequence)(this.myRepoType + "{" + statement.getText() + "}")), null);
        }
    }

    @NotNull
    public String getFamilyName() {
        String string = GradleInspectionBundle.message("multiple.repository.urls.fix.name", new Object[0]);
        if (string == null) {
            MultipleRepositoryUrlsFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repoType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/codeInspection/MultipleRepositoryUrlsFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/codeInspection/MultipleRepositoryUrlsFix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doFix";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

