/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.resolve.dsl;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.OriginInfoAwareElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.service.resolve.GradleResolverUtil;
import org.jetbrains.plugins.groovy.highlighter.GroovySyntaxHighlighter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public final class GradleDslAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            GradleDslAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            GradleDslAnnotator.$$$reportNull$$$0(1);
        }
        if (element instanceof GrReferenceExpression) {
            GrExpression qualifier;
            GrReferenceExpression referenceExpression = (GrReferenceExpression)element;
            PsiElement resolved = referenceExpression.resolve();
            if (resolved instanceof OriginInfoAwareElement && "by NamedDomainCollection".equals(((OriginInfoAwareElement)resolved).getOriginInfo())) {
                GradleDslAnnotator.highlightElement(holder, referenceExpression.getReferenceNameElement());
            }
            if ((qualifier = ResolveUtil.getSelfOrWithQualifier((GrReferenceExpression)referenceExpression)) == null) {
                return;
            }
            if (qualifier instanceof GrReferenceExpression && ((GrReferenceExpression)qualifier).resolve() instanceof PsiClass) {
                return;
            }
            PsiType psiType = GradleResolverUtil.getTypeOf(qualifier);
            if (psiType == null) {
                return;
            }
            if (InheritanceUtil.isInheritor((PsiType)psiType, (String)"org.gradle.api.NamedDomainObjectCollection")) {
                PsiClass containerClass;
                JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)element.getProject());
                PsiClass defaultGroovyMethodsClass = javaPsiFacade.findClass("org.codehaus.groovy.runtime.DefaultGroovyMethods", element.getResolveScope());
                if (GradleResolverUtil.canBeMethodOf(referenceExpression.getReferenceName(), defaultGroovyMethodsClass)) {
                    return;
                }
                String qualifiedName = TypesUtil.getQualifiedName((PsiType)psiType);
                PsiClass psiClass = containerClass = qualifiedName != null ? javaPsiFacade.findClass(qualifiedName, element.getResolveScope()) : null;
                if (GradleResolverUtil.canBeMethodOf(referenceExpression.getReferenceName(), containerClass)) {
                    return;
                }
                PsiElement nameElement = referenceExpression.getReferenceNameElement();
                GradleDslAnnotator.highlightElement(holder, nameElement);
            }
        }
    }

    private static void highlightElement(@NotNull AnnotationHolder holder, PsiElement nameElement) {
        if (holder == null) {
            GradleDslAnnotator.$$$reportNull$$$0(2);
        }
        if (nameElement != null) {
            holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(nameElement).textAttributes(GroovySyntaxHighlighter.MAP_KEY).create();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/gradle/service/resolve/dsl/GradleDslAnnotator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "annotate";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

