/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.jpa.entities;

import jakarta.persistence.Access;
import jakarta.persistence.AccessType;
import jakarta.persistence.CascadeType;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import jakarta.persistence.UniqueConstraint;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.bytecode.enhance.internal.bytebuddy.InlineDirtyCheckerEqualsHelper;
import org.hibernate.bytecode.enhance.internal.tracker.DirtyTracker;
import org.hibernate.bytecode.enhance.internal.tracker.SimpleCollectionTracker;
import org.hibernate.bytecode.enhance.internal.tracker.SimpleFieldTracker;
import org.hibernate.bytecode.enhance.spi.CollectionTracker;
import org.hibernate.bytecode.enhance.spi.EnhancementInfo;
import org.hibernate.bytecode.enhance.spi.interceptor.LazyAttributeLoadingInterceptor;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ExtendedSelfDirtinessTracker;
import org.hibernate.engine.spi.ManagedEntity;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.keycloak.authorization.jpa.entities.ResourceAttributeEntity;
import org.keycloak.authorization.jpa.entities.ScopeEntity;

@Entity
@Table(name="RESOURCE_SERVER_RESOURCE", uniqueConstraints={@UniqueConstraint(columnNames={"NAME", "RESOURCE_SERVER_ID", "OWNER"})})
@NamedQueries(value={@NamedQuery(name="findResourceIdByOwner", query="select r from ResourceEntity r  where r.resourceServer = :serverId and r.owner = :owner"), @NamedQuery(name="findResourceIdByOwnerOrdered", query="select r from ResourceEntity r where r.resourceServer = :serverId and r.owner = :owner order by r.id"), @NamedQuery(name="findAnyResourceIdByOwner", query="select r from ResourceEntity r where r.owner = :owner"), @NamedQuery(name="findAnyResourceIdByOwnerOrdered", query="select r.id from ResourceEntity r where r.owner = :owner order by r.id"), @NamedQuery(name="findResourceIdByUri", query="select r.id from ResourceEntity r where  r.resourceServer = :serverId  and :uri in elements(r.uris)"), @NamedQuery(name="findResourceIdByName", query="select r from ResourceEntity r left join fetch r.scopes s where  r.resourceServer = :serverId  and r.owner = :ownerId and r.name = :name"), @NamedQuery(name="findResourceIdByType", query="select r from ResourceEntity r left join fetch r.scopes s where  r.resourceServer = :serverId  and r.owner = :ownerId and r.type = :type"), @NamedQuery(name="findResourceIdByTypeNoOwner", query="select r from ResourceEntity r left join fetch r.scopes s where  r.resourceServer = :serverId  and r.type = :type"), @NamedQuery(name="findResourceIdByTypeInstance", query="select r from ResourceEntity r left join fetch r.scopes s where  r.resourceServer = :serverId and r.type = :type and r.owner <> :serverId"), @NamedQuery(name="findResourceIdByServerId", query="select r.id from ResourceEntity r where  r.resourceServer = :serverId "), @NamedQuery(name="findResourceIdByScope", query="select r from ResourceEntity r inner join r.scopes s where r.resourceServer = :serverId and (s.resourceServer.id = :serverId and s.id in (:scopeIds))"), @NamedQuery(name="deleteResourceByResourceServer", query="delete from ResourceEntity r where r.resourceServer = :serverId")})
@EnhancementInfo(includesDirtyChecking=true, includesAssociationManagement=false, version="7.1.4.Final")
public class ResourceEntity
implements ManagedEntity,
PersistentAttributeInterceptable,
ExtendedSelfDirtinessTracker {
    @Id
    @Column(name="ID", length=36)
    @Access(value=AccessType.PROPERTY)
    String id;
    @Column(name="NAME")
    String name;
    @Column(name="DISPLAY_NAME")
    String displayName;
    @ElementCollection(fetch=FetchType.LAZY)
    @Column(name="VALUE")
    @CollectionTable(name="RESOURCE_URIS", joinColumns={@JoinColumn(name="RESOURCE_ID")})
    Set<String> uris;
    @Column(name="TYPE")
    String type;
    @Column(name="ICON_URI")
    String iconUri;
    @Column(name="OWNER")
    String owner;
    @Column(name="OWNER_MANAGED_ACCESS")
    boolean ownerManagedAccess;
    @Column(name="RESOURCE_SERVER_ID")
    String resourceServer;
    @OneToMany(fetch=FetchType.LAZY, cascade={})
    @JoinTable(name="RESOURCE_SCOPE", joinColumns={@JoinColumn(name="RESOURCE_ID")}, inverseJoinColumns={@JoinColumn(name="SCOPE_ID")})
    @Fetch(value=FetchMode.SELECT)
    @BatchSize(size=20)
    List<ScopeEntity> scopes;
    @OneToMany(cascade={CascadeType.REMOVE}, orphanRemoval=false, mappedBy="resource", fetch=FetchType.LAZY)
    @Fetch(value=FetchMode.SELECT)
    @BatchSize(size=20)
    Collection<ResourceAttributeEntity> attributes;
    @Transient
    private transient EntityEntry $$_hibernate_entityEntryHolder;
    @Transient
    private transient ManagedEntity $$_hibernate_previousManagedEntity;
    @Transient
    private transient ManagedEntity $$_hibernate_nextManagedEntity;
    @Transient
    private transient boolean $$_hibernate_useTracker;
    @Transient
    private transient int $$_hibernate_instanceId;
    @Transient
    private transient PersistentAttributeInterceptor $$_hibernate_attributeInterceptor;
    @Transient
    private transient DirtyTracker $$_hibernate_tracker;
    @Transient
    private transient CollectionTracker $$_hibernate_collectionTracker;

    public ResourceEntity() {
        this.$$_hibernate_write_attributes(new LinkedList());
    }

    public String getId() {
        return this.$$_hibernate_read_id();
    }

    public void setId(String id) {
        this.$$_hibernate_write_id(id);
    }

    public String getName() {
        return this.$$_hibernate_read_name();
    }

    public void setName(String name) {
        this.$$_hibernate_write_name(name);
    }

    public String getDisplayName() {
        return this.$$_hibernate_read_displayName();
    }

    public void setDisplayName(String displayName) {
        this.$$_hibernate_write_displayName(displayName);
    }

    public Set<String> getUris() {
        if (this.$$_hibernate_read_uris() == null) {
            this.$$_hibernate_write_uris(new HashSet());
        }
        return this.$$_hibernate_read_uris();
    }

    public void setUris(Set<String> uris) {
        this.$$_hibernate_write_uris(uris);
    }

    public String getType() {
        return this.$$_hibernate_read_type();
    }

    public void setType(String type) {
        this.$$_hibernate_write_type(type);
    }

    public List<ScopeEntity> getScopes() {
        if (this.$$_hibernate_read_scopes() == null) {
            this.$$_hibernate_write_scopes(new LinkedList());
        }
        return this.$$_hibernate_read_scopes();
    }

    public String getIconUri() {
        return this.$$_hibernate_read_iconUri();
    }

    public void setIconUri(String iconUri) {
        this.$$_hibernate_write_iconUri(iconUri);
    }

    public String getResourceServer() {
        return this.$$_hibernate_read_resourceServer();
    }

    public void setResourceServer(String resourceServer) {
        this.$$_hibernate_write_resourceServer(resourceServer);
    }

    public String getOwner() {
        return this.$$_hibernate_read_owner();
    }

    public void setOwner(String owner) {
        this.$$_hibernate_write_owner(owner);
    }

    public void setOwnerManagedAccess(boolean ownerManagedAccess) {
        this.$$_hibernate_write_ownerManagedAccess(ownerManagedAccess);
    }

    public boolean isOwnerManagedAccess() {
        return this.$$_hibernate_read_ownerManagedAccess();
    }

    public Collection<ResourceAttributeEntity> getAttributes() {
        if (this.$$_hibernate_read_attributes() == null) {
            this.$$_hibernate_write_attributes(new LinkedList());
        }
        return this.$$_hibernate_read_attributes();
    }

    public void setAttributes(Collection<ResourceAttributeEntity> attributes) {
        this.$$_hibernate_write_attributes(attributes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceEntity that = (ResourceEntity)o;
        return this.getId().equals(that.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public Object $$_hibernate_getEntityInstance() {
        return this;
    }

    public EntityEntry $$_hibernate_getEntityEntry() {
        return this.$$_hibernate_entityEntryHolder;
    }

    public void $$_hibernate_setEntityEntry(EntityEntry entityEntry) {
        this.$$_hibernate_entityEntryHolder = entityEntry;
    }

    public ManagedEntity $$_hibernate_getPreviousManagedEntity() {
        return this.$$_hibernate_previousManagedEntity;
    }

    public void $$_hibernate_setPreviousManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_previousManagedEntity = managedEntity;
    }

    public ManagedEntity $$_hibernate_getNextManagedEntity() {
        return this.$$_hibernate_nextManagedEntity;
    }

    public void $$_hibernate_setNextManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_nextManagedEntity = managedEntity;
    }

    public boolean $$_hibernate_useTracker() {
        return this.$$_hibernate_useTracker;
    }

    public void $$_hibernate_setUseTracker(boolean bl) {
        this.$$_hibernate_useTracker = bl;
    }

    public int $$_hibernate_getInstanceId() {
        return this.$$_hibernate_instanceId;
    }

    public void $$_hibernate_setInstanceId(int n) {
        this.$$_hibernate_instanceId = n;
    }

    public EntityEntry $$_hibernate_setPersistenceInfo(EntityEntry entityEntry, ManagedEntity managedEntity, ManagedEntity managedEntity2, int n) {
        ResourceEntity resourceEntity = this;
        EntityEntry entityEntry2 = entityEntry;
        ManagedEntity managedEntity3 = managedEntity;
        ManagedEntity managedEntity4 = managedEntity2;
        int n2 = n;
        resourceEntity = null;
        resourceEntity = this.$$_hibernate_entityEntryHolder;
        this.$$_hibernate_entityEntryHolder = entityEntry;
        this.$$_hibernate_previousManagedEntity = managedEntity;
        this.$$_hibernate_nextManagedEntity = managedEntity2;
        this.$$_hibernate_instanceId = n;
        return resourceEntity;
    }

    public PersistentAttributeInterceptor $$_hibernate_getInterceptor() {
        return this.$$_hibernate_attributeInterceptor;
    }

    public void $$_hibernate_setInterceptor(PersistentAttributeInterceptor persistentAttributeInterceptor) {
        this.$$_hibernate_attributeInterceptor = persistentAttributeInterceptor;
    }

    public void $$_hibernate_trackChange(String string) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.add(string);
    }

    public String[] $$_hibernate_getDirtyAttributes() {
        String[] stringArray = this;
        stringArray = null;
        if (this.$$_hibernate_collectionTracker == null) {
            stringArray = this.$$_hibernate_tracker == null ? ArrayHelper.EMPTY_STRING_ARRAY : this.$$_hibernate_tracker.get();
        } else {
            if (this.$$_hibernate_tracker == null) {
                this.$$_hibernate_tracker = new SimpleFieldTracker();
            }
            this.$$_hibernate_getCollectionFieldDirtyNames(this.$$_hibernate_tracker);
            stringArray = this.$$_hibernate_tracker.get();
        }
        return stringArray;
    }

    public boolean $$_hibernate_hasDirtyAttributes() {
        ResourceEntity resourceEntity = this;
        boolean bl = false;
        bl = this.$$_hibernate_tracker != null && !this.$$_hibernate_tracker.isEmpty() || this.$$_hibernate_areCollectionFieldsDirty();
        return bl;
    }

    public void $$_hibernate_clearDirtyAttributes() {
        if (this.$$_hibernate_tracker != null) {
            this.$$_hibernate_tracker.clear();
        }
        this.$$_hibernate_clearDirtyCollectionNames();
    }

    public void $$_hibernate_suspendDirtyTracking(boolean bl) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.suspend(bl);
    }

    public CollectionTracker $$_hibernate_getCollectionTracker() {
        return this.$$_hibernate_collectionTracker;
    }

    public boolean $$_hibernate_areCollectionFieldsDirty() {
        int n;
        block8: {
            int n2;
            block9: {
                ResourceEntity resourceEntity = this;
                ResourceEntity resourceEntity2 = resourceEntity;
                ResourceEntity resourceEntity3 = resourceEntity2;
                int n3 = 0;
                if (n3 == 0 && resourceEntity2.$$_hibernate_collectionTracker != null) {
                    int n4 = resourceEntity2.$$_hibernate_collectionTracker.getSize("uris");
                    if (resourceEntity2.uris == null && n4 != -1) {
                        n3 = 1;
                    } else if (resourceEntity2.uris != null && (!(resourceEntity2.uris instanceof PersistentCollection) || ((PersistentCollection)resourceEntity2.uris).wasInitialized()) && n4 != resourceEntity2.uris.size()) {
                        n3 = 1;
                    }
                }
                if ((n2 = n3) == 0 && resourceEntity.$$_hibernate_collectionTracker != null) {
                    n3 = resourceEntity.$$_hibernate_collectionTracker.getSize("scopes");
                    if (resourceEntity.scopes == null && n3 != -1) {
                        n2 = 1;
                    } else if (resourceEntity.scopes != null && (!(resourceEntity.scopes instanceof PersistentCollection) || ((PersistentCollection)resourceEntity.scopes).wasInitialized()) && n3 != resourceEntity.scopes.size()) {
                        n2 = 1;
                    }
                }
                if ((n = n2) != 0 || this.$$_hibernate_collectionTracker == null) break block8;
                n2 = this.$$_hibernate_collectionTracker.getSize("attributes");
                if (this.attributes != null || n2 == -1) break block9;
                n = 1;
                break block8;
            }
            if (this.attributes == null || this.attributes instanceof PersistentCollection && !((PersistentCollection)this.attributes).wasInitialized() || n2 == this.attributes.size()) break block8;
            n = 1;
        }
        return n != 0;
    }

    public void $$_hibernate_getCollectionFieldDirtyNames(DirtyTracker dirtyTracker) {
        block8: {
            int n;
            block9: {
                ResourceEntity resourceEntity = this;
                DirtyTracker dirtyTracker2 = dirtyTracker;
                ResourceEntity resourceEntity2 = resourceEntity;
                DirtyTracker dirtyTracker3 = dirtyTracker2;
                ResourceEntity resourceEntity3 = resourceEntity2;
                DirtyTracker dirtyTracker4 = dirtyTracker3;
                if (resourceEntity2.$$_hibernate_collectionTracker != null) {
                    int n2 = resourceEntity2.$$_hibernate_collectionTracker.getSize("uris");
                    if (resourceEntity2.uris == null && n2 != -1) {
                        dirtyTracker3.add("uris");
                    } else if (resourceEntity2.uris != null && (!(resourceEntity2.uris instanceof PersistentCollection) || ((PersistentCollection)resourceEntity2.uris).wasInitialized()) && n2 != resourceEntity2.uris.size()) {
                        dirtyTracker3.add("uris");
                    }
                }
                if (resourceEntity.$$_hibernate_collectionTracker != null) {
                    int n3 = resourceEntity.$$_hibernate_collectionTracker.getSize("scopes");
                    if (resourceEntity.scopes == null && n3 != -1) {
                        dirtyTracker2.add("scopes");
                    } else if (resourceEntity.scopes != null && (!(resourceEntity.scopes instanceof PersistentCollection) || ((PersistentCollection)resourceEntity.scopes).wasInitialized()) && n3 != resourceEntity.scopes.size()) {
                        dirtyTracker2.add("scopes");
                    }
                }
                if (this.$$_hibernate_collectionTracker == null) break block8;
                n = this.$$_hibernate_collectionTracker.getSize("attributes");
                if (this.attributes != null || n == -1) break block9;
                dirtyTracker.add("attributes");
                break block8;
            }
            if (this.attributes == null || this.attributes instanceof PersistentCollection && !((PersistentCollection)this.attributes).wasInitialized() || n == this.attributes.size()) break block8;
            dirtyTracker.add("attributes");
        }
    }

    public void $$_hibernate_clearDirtyCollectionNames() {
        if (this.$$_hibernate_collectionTracker == null) {
            this.$$_hibernate_collectionTracker = new SimpleCollectionTracker();
        }
        this.$$_hibernate_removeDirtyFields(null);
    }

    public void $$_hibernate_removeDirtyFields(LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor) {
        block9: {
            if (this.$$_hibernate_attributeInterceptor instanceof LazyAttributeLoadingInterceptor) {
                lazyAttributeLoadingInterceptor = (LazyAttributeLoadingInterceptor)this.$$_hibernate_attributeInterceptor;
            }
            ResourceEntity resourceEntity = this;
            LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor2 = lazyAttributeLoadingInterceptor;
            ResourceEntity resourceEntity2 = resourceEntity;
            LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor3 = lazyAttributeLoadingInterceptor2;
            ResourceEntity resourceEntity3 = resourceEntity2;
            LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor4 = lazyAttributeLoadingInterceptor3;
            if (lazyAttributeLoadingInterceptor3 == null || lazyAttributeLoadingInterceptor3.isAttributeLoaded("uris")) {
                if (resourceEntity2.uris == null || resourceEntity2.uris instanceof PersistentCollection && !((PersistentCollection)resourceEntity2.uris).wasInitialized()) {
                    resourceEntity2.$$_hibernate_collectionTracker.add("uris", -1);
                } else {
                    resourceEntity2.$$_hibernate_collectionTracker.add("uris", resourceEntity2.uris.size());
                }
            }
            if (lazyAttributeLoadingInterceptor2 == null || lazyAttributeLoadingInterceptor2.isAttributeLoaded("scopes")) {
                if (resourceEntity.scopes == null || resourceEntity.scopes instanceof PersistentCollection && !((PersistentCollection)resourceEntity.scopes).wasInitialized()) {
                    resourceEntity.$$_hibernate_collectionTracker.add("scopes", -1);
                } else {
                    resourceEntity.$$_hibernate_collectionTracker.add("scopes", resourceEntity.scopes.size());
                }
            }
            if (lazyAttributeLoadingInterceptor != null && !lazyAttributeLoadingInterceptor.isAttributeLoaded("attributes")) break block9;
            if (this.attributes == null || this.attributes instanceof PersistentCollection && !((PersistentCollection)this.attributes).wasInitialized()) {
                this.$$_hibernate_collectionTracker.add("attributes", -1);
            } else {
                this.$$_hibernate_collectionTracker.add("attributes", this.attributes.size());
            }
        }
    }

    public String $$_hibernate_read_id() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "id", (Object)this.id);
        }
        return this.id;
    }

    public void $$_hibernate_write_id(String string) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "id", (Object)this.id, (Object)string);
            return;
        }
        this.id = string;
    }

    public String $$_hibernate_read_name() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.name = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "name", (Object)this.name);
        }
        return this.name;
    }

    public void $$_hibernate_write_name(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"name", (Object)string, (Object)this.name)) {
            this.$$_hibernate_trackChange("name");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.name = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "name", (Object)this.name, (Object)string);
            return;
        }
        this.name = string;
    }

    public String $$_hibernate_read_displayName() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.displayName = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "displayName", (Object)this.displayName);
        }
        return this.displayName;
    }

    public void $$_hibernate_write_displayName(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"displayName", (Object)string, (Object)this.displayName)) {
            this.$$_hibernate_trackChange("displayName");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.displayName = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "displayName", (Object)this.displayName, (Object)string);
            return;
        }
        this.displayName = string;
    }

    public Set $$_hibernate_read_uris() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.uris = (Set)this.$$_hibernate_getInterceptor().readObject((Object)this, "uris", this.uris);
        }
        return this.uris;
    }

    public void $$_hibernate_write_uris(Set set) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.uris = (Set)this.$$_hibernate_getInterceptor().writeObject((Object)this, "uris", this.uris, (Object)set);
            return;
        }
        this.uris = set;
    }

    public String $$_hibernate_read_type() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.type = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "type", (Object)this.type);
        }
        return this.type;
    }

    public void $$_hibernate_write_type(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"type", (Object)string, (Object)this.type)) {
            this.$$_hibernate_trackChange("type");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.type = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "type", (Object)this.type, (Object)string);
            return;
        }
        this.type = string;
    }

    public String $$_hibernate_read_iconUri() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.iconUri = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "iconUri", (Object)this.iconUri);
        }
        return this.iconUri;
    }

    public void $$_hibernate_write_iconUri(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"iconUri", (Object)string, (Object)this.iconUri)) {
            this.$$_hibernate_trackChange("iconUri");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.iconUri = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "iconUri", (Object)this.iconUri, (Object)string);
            return;
        }
        this.iconUri = string;
    }

    public String $$_hibernate_read_owner() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.owner = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "owner", (Object)this.owner);
        }
        return this.owner;
    }

    public void $$_hibernate_write_owner(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"owner", (Object)string, (Object)this.owner)) {
            this.$$_hibernate_trackChange("owner");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.owner = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "owner", (Object)this.owner, (Object)string);
            return;
        }
        this.owner = string;
    }

    public boolean $$_hibernate_read_ownerManagedAccess() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.ownerManagedAccess = this.$$_hibernate_getInterceptor().readBoolean((Object)this, "ownerManagedAccess", this.ownerManagedAccess);
        }
        return this.ownerManagedAccess;
    }

    public void $$_hibernate_write_ownerManagedAccess(boolean bl) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"ownerManagedAccess", (boolean)bl, (boolean)this.ownerManagedAccess)) {
            this.$$_hibernate_trackChange("ownerManagedAccess");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.ownerManagedAccess = this.$$_hibernate_getInterceptor().writeBoolean((Object)this, "ownerManagedAccess", this.ownerManagedAccess, bl);
            return;
        }
        this.ownerManagedAccess = bl;
    }

    public String $$_hibernate_read_resourceServer() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.resourceServer = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "resourceServer", (Object)this.resourceServer);
        }
        return this.resourceServer;
    }

    public void $$_hibernate_write_resourceServer(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"resourceServer", (Object)string, (Object)this.resourceServer)) {
            this.$$_hibernate_trackChange("resourceServer");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.resourceServer = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "resourceServer", (Object)this.resourceServer, (Object)string);
            return;
        }
        this.resourceServer = string;
    }

    public List $$_hibernate_read_scopes() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.scopes = (List)this.$$_hibernate_getInterceptor().readObject((Object)this, "scopes", this.scopes);
        }
        return this.scopes;
    }

    public void $$_hibernate_write_scopes(List list) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.scopes = (List)this.$$_hibernate_getInterceptor().writeObject((Object)this, "scopes", this.scopes, (Object)list);
            return;
        }
        this.scopes = list;
    }

    public Collection $$_hibernate_read_attributes() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.attributes = (Collection)this.$$_hibernate_getInterceptor().readObject((Object)this, "attributes", this.attributes);
        }
        return this.attributes;
    }

    public void $$_hibernate_write_attributes(Collection collection) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.attributes = (Collection)this.$$_hibernate_getInterceptor().writeObject((Object)this, "attributes", this.attributes, (Object)collection);
            return;
        }
        this.attributes = collection;
    }
}

