/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.spiffe;

import java.util.Map;
import org.keycloak.authentication.ClientAuthenticationFlowContext;
import org.keycloak.authentication.authenticators.client.ClientAssertionState;
import org.keycloak.broker.provider.ClientAssertionIdentityProviderFactory;
import org.keycloak.cache.AlternativeLookupProvider;
import org.keycloak.models.ClientModel;
import org.keycloak.models.IdentityProviderModel;

public class SpiffeClientAssertionStrategy
implements ClientAssertionIdentityProviderFactory.ClientAssertionStrategy {
    public boolean isSupportedAssertionType(String assertionType) {
        return "urn:ietf:params:oauth:client-assertion-type:jwt-spiffe".equals(assertionType);
    }

    public ClientAssertionIdentityProviderFactory.LookupResult lookup(ClientAuthenticationFlowContext context) throws Exception {
        ClientAssertionState clientAssertionState = (ClientAssertionState)context.getState(ClientAssertionState.class, ClientAssertionState.supplier());
        AlternativeLookupProvider lookupProvider = (AlternativeLookupProvider)context.getSession().getProvider(AlternativeLookupProvider.class);
        String federatedClientId = clientAssertionState.getToken().getSubject();
        ClientModel client = lookupProvider.lookupClientFromClientAttributes(context.getSession(), Map.of("jwt.credential.sub", federatedClientId));
        IdentityProviderModel identityProvider = context.getSession().identityProviders().getByAlias(client.getAttribute("jwt.credential.issuer"));
        return new ClientAssertionIdentityProviderFactory.LookupResult(client, identityProvider);
    }
}

