"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiOutsideClickDetector = void 0;
var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));
var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));
var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));
var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));
var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));
var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = require("react");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _accessibility = require("../../services/accessibility");
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _createSuper(t) { var r = _isNativeReflectConstruct(); return function () { var e, o = (0, _getPrototypeOf2.default)(t); if (r) { var s = (0, _getPrototypeOf2.default)(this).constructor; e = Reflect.construct(o, arguments, s); } else e = o.apply(this, arguments); return (0, _possibleConstructorReturn2.default)(this, e); }; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); } /*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */ /*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var EuiOutsideClickDetector = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(EuiOutsideClickDetector, _Component);
  var _super = _createSuper(EuiOutsideClickDetector);
  function EuiOutsideClickDetector(props) {
    var _this;
    (0, _classCallCheck2.default)(this, EuiOutsideClickDetector);
    _this = _super.call(this, props);

    // the id is used to identify which EuiOutsideClickDetector
    // is the source of a click event; as the click event bubbles
    // up and reaches the click detector's child component the
    // id value is stamped on the event. This id is inspected
    // in the document's click handler, and if the id doesn't
    // exist or doesn't match this detector's id, then trigger
    // the outsideClick callback.
    //
    // Taking this approach instead of checking if the event's
    // target element exists in this component's DOM sub-tree is
    // necessary for handling clicks originating from children
    // rendered through React's portals (EuiPortal). The id tracking
    // works because React guarantees the event bubbles through the
    // virtual DOM and executes EuiClickDetector's onClick handler,
    // stamping the id even though the event originates outside
    // this component's reified DOM tree.
    // We are working with the assumption that a click event is
    // equivalent to a sequential, compound press and release of
    // the pointing device (mouse, finger, stylus, etc.).
    // A click event's target can be imprecise, as the value will be
    // the closest common ancestor of the press (mousedown, touchstart)
    // and release (mouseup, touchend) events (often <body />) if
    // the the target of each event differs.
    // We need the actual event targets to make the correct decisions
    // about user intention. So, consider the down/start and up/end
    // items below as the deconstruction of a click event.
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "id", void 0);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "capturedDownIds", void 0);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onClickOutside", function (e) {
      var _this$props = _this.props,
        isDisabled = _this$props.isDisabled,
        onOutsideClick = _this$props.onOutsideClick;
      if (isDisabled) {
        _this.capturedDownIds = [];
        return;
      }
      var event = e;
      if (event.euiGeneratedBy && event.euiGeneratedBy.includes(_this.id) || _this.capturedDownIds.includes(_this.id)) {
        _this.capturedDownIds = [];
        return;
      }
      _this.capturedDownIds = [];
      return onOutsideClick(event);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onChildClick", function (event, cb) {
      // to support nested click detectors, build an array
      // of detector ids that have been encountered;
      if (event.nativeEvent.hasOwnProperty('euiGeneratedBy')) {
        event.nativeEvent.euiGeneratedBy.push(_this.id);
      } else {
        event.nativeEvent.euiGeneratedBy = [_this.id];
      }
      if (cb) cb(event);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onChildMouseDown", function (event) {
      _this.onChildClick(event, function (e) {
        var nativeEvent = e.nativeEvent;
        _this.capturedDownIds = nativeEvent.euiGeneratedBy;
        if (_this.props.onMouseDown) _this.props.onMouseDown(e);
        if (_this.props.onTouchStart) _this.props.onTouchStart(e);
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onChildMouseUp", function (event) {
      _this.onChildClick(event, function (e) {
        if (_this.props.onMouseUp) _this.props.onMouseUp(e);
        if (_this.props.onTouchEnd) _this.props.onTouchEnd(e);
      });
    });
    _this.id = (0, _accessibility.htmlIdGenerator)()();
    _this.capturedDownIds = [];
    return _this;
  }
  (0, _createClass2.default)(EuiOutsideClickDetector, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      document.addEventListener('mouseup', this.onClickOutside);
      document.addEventListener('touchend', this.onClickOutside);
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      document.removeEventListener('mouseup', this.onClickOutside);
      document.removeEventListener('touchend', this.onClickOutside);
    }
  }, {
    key: "render",
    value: function render() {
      var props = _objectSpread(_objectSpread({}, this.props.children.props), {
        onMouseDown: this.onChildMouseDown,
        onTouchStart: this.onChildMouseDown,
        onMouseUp: this.onChildMouseUp,
        onTouchEnd: this.onChildMouseUp
      });
      var child = _react.Children.only(this.props.children);
      return /*#__PURE__*/(0, _react.cloneElement)(child, props);
    }
  }]);
  return EuiOutsideClickDetector;
}(_react.Component);
exports.EuiOutsideClickDetector = EuiOutsideClickDetector;
EuiOutsideClickDetector.propTypes = {
  /**
     * ReactNode to render as this component's content
     */
  children: _propTypes.default.element.isRequired,
  onOutsideClick: _propTypes.default.func.isRequired,
  isDisabled: _propTypes.default.bool,
  onMouseDown: _propTypes.default.func,
  onMouseUp: _propTypes.default.func,
  onTouchStart: _propTypes.default.func,
  onTouchEnd: _propTypes.default.func
};