/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cluster;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.HealthStatus;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch.cluster.health.AwarenessAttributeStats;
import org.opensearch.client.opensearch.cluster.health.IndexHealthStats;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class HealthResponse
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, HealthResponse> {
    private final int activePrimaryShards;
    private final int activeShards;
    @Nullable
    private final String activeShardsPercent;
    private final double activeShardsPercentAsNumber;
    @Nonnull
    private final Map<String, AwarenessAttributeStats> awarenessAttributes;
    @Nonnull
    private final String clusterName;
    private final int delayedUnassignedShards;
    @Nullable
    private final Boolean discoveredClusterManager;
    @Nullable
    private final Boolean discoveredMaster;
    @Nonnull
    private final Map<String, IndexHealthStats> indices;
    private final int initializingShards;
    private final int numberOfDataNodes;
    private final int numberOfInFlightFetch;
    private final int numberOfNodes;
    private final int numberOfPendingTasks;
    private final int relocatingShards;
    @Nonnull
    private final HealthStatus status;
    @Nullable
    private final Time taskMaxWaitingInQueue;
    private final long taskMaxWaitingInQueueMillis;
    private final boolean timedOut;
    private final int unassignedShards;
    public static final JsonpDeserializer<HealthResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, HealthResponse::setupHealthResponseDeserializer);

    private HealthResponse(Builder builder) {
        this.activePrimaryShards = ApiTypeHelper.requireNonNull(builder.activePrimaryShards, this, "activePrimaryShards");
        this.activeShards = ApiTypeHelper.requireNonNull(builder.activeShards, this, "activeShards");
        this.activeShardsPercent = builder.activeShardsPercent;
        this.activeShardsPercentAsNumber = ApiTypeHelper.requireNonNull(builder.activeShardsPercentAsNumber, this, "activeShardsPercentAsNumber");
        this.awarenessAttributes = ApiTypeHelper.unmodifiable(builder.awarenessAttributes);
        this.clusterName = ApiTypeHelper.requireNonNull(builder.clusterName, this, "clusterName");
        this.delayedUnassignedShards = ApiTypeHelper.requireNonNull(builder.delayedUnassignedShards, this, "delayedUnassignedShards");
        this.discoveredClusterManager = builder.discoveredClusterManager;
        this.discoveredMaster = builder.discoveredMaster;
        this.indices = ApiTypeHelper.unmodifiable(builder.indices);
        this.initializingShards = ApiTypeHelper.requireNonNull(builder.initializingShards, this, "initializingShards");
        this.numberOfDataNodes = ApiTypeHelper.requireNonNull(builder.numberOfDataNodes, this, "numberOfDataNodes");
        this.numberOfInFlightFetch = ApiTypeHelper.requireNonNull(builder.numberOfInFlightFetch, this, "numberOfInFlightFetch");
        this.numberOfNodes = ApiTypeHelper.requireNonNull(builder.numberOfNodes, this, "numberOfNodes");
        this.numberOfPendingTasks = ApiTypeHelper.requireNonNull(builder.numberOfPendingTasks, this, "numberOfPendingTasks");
        this.relocatingShards = ApiTypeHelper.requireNonNull(builder.relocatingShards, this, "relocatingShards");
        this.status = ApiTypeHelper.requireNonNull(builder.status, this, "status");
        this.taskMaxWaitingInQueue = builder.taskMaxWaitingInQueue;
        this.taskMaxWaitingInQueueMillis = ApiTypeHelper.requireNonNull(builder.taskMaxWaitingInQueueMillis, this, "taskMaxWaitingInQueueMillis");
        this.timedOut = ApiTypeHelper.requireNonNull(builder.timedOut, this, "timedOut");
        this.unassignedShards = ApiTypeHelper.requireNonNull(builder.unassignedShards, this, "unassignedShards");
    }

    public static HealthResponse of(Function<Builder, ObjectBuilder<HealthResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int activePrimaryShards() {
        return this.activePrimaryShards;
    }

    public final int activeShards() {
        return this.activeShards;
    }

    @Nullable
    public final String activeShardsPercent() {
        return this.activeShardsPercent;
    }

    public final double activeShardsPercentAsNumber() {
        return this.activeShardsPercentAsNumber;
    }

    @Nonnull
    public final Map<String, AwarenessAttributeStats> awarenessAttributes() {
        return this.awarenessAttributes;
    }

    @Nonnull
    public final String clusterName() {
        return this.clusterName;
    }

    public final int delayedUnassignedShards() {
        return this.delayedUnassignedShards;
    }

    @Nullable
    public final Boolean discoveredClusterManager() {
        return this.discoveredClusterManager;
    }

    @Nullable
    public final Boolean discoveredMaster() {
        return this.discoveredMaster;
    }

    @Nonnull
    public final Map<String, IndexHealthStats> indices() {
        return this.indices;
    }

    public final int initializingShards() {
        return this.initializingShards;
    }

    public final int numberOfDataNodes() {
        return this.numberOfDataNodes;
    }

    public final int numberOfInFlightFetch() {
        return this.numberOfInFlightFetch;
    }

    public final int numberOfNodes() {
        return this.numberOfNodes;
    }

    public final int numberOfPendingTasks() {
        return this.numberOfPendingTasks;
    }

    public final int relocatingShards() {
        return this.relocatingShards;
    }

    @Nonnull
    public final HealthStatus status() {
        return this.status;
    }

    @Nullable
    public final Time taskMaxWaitingInQueue() {
        return this.taskMaxWaitingInQueue;
    }

    public final long taskMaxWaitingInQueueMillis() {
        return this.taskMaxWaitingInQueueMillis;
    }

    public final boolean timedOut() {
        return this.timedOut;
    }

    public final int unassignedShards() {
        return this.unassignedShards;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("active_primary_shards");
        generator.write(this.activePrimaryShards);
        generator.writeKey("active_shards");
        generator.write(this.activeShards);
        if (this.activeShardsPercent != null) {
            generator.writeKey("active_shards_percent");
            generator.write(this.activeShardsPercent);
        }
        generator.writeKey("active_shards_percent_as_number");
        generator.write(this.activeShardsPercentAsNumber);
        if (ApiTypeHelper.isDefined(this.awarenessAttributes)) {
            generator.writeKey("awareness_attributes");
            generator.writeStartObject();
            for (Map.Entry<String, AwarenessAttributeStats> entry : this.awarenessAttributes.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("cluster_name");
        generator.write(this.clusterName);
        generator.writeKey("delayed_unassigned_shards");
        generator.write(this.delayedUnassignedShards);
        if (this.discoveredClusterManager != null) {
            generator.writeKey("discovered_cluster_manager");
            generator.write(this.discoveredClusterManager.booleanValue());
        }
        if (this.discoveredMaster != null) {
            generator.writeKey("discovered_master");
            generator.write(this.discoveredMaster.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.indices)) {
            generator.writeKey("indices");
            generator.writeStartObject();
            for (Map.Entry<String, ToCopyableBuilder<AwarenessAttributeStats.Builder, AwarenessAttributeStats>> entry : this.indices.entrySet()) {
                generator.writeKey(entry.getKey());
                ((IndexHealthStats)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("initializing_shards");
        generator.write(this.initializingShards);
        generator.writeKey("number_of_data_nodes");
        generator.write(this.numberOfDataNodes);
        generator.writeKey("number_of_in_flight_fetch");
        generator.write(this.numberOfInFlightFetch);
        generator.writeKey("number_of_nodes");
        generator.write(this.numberOfNodes);
        generator.writeKey("number_of_pending_tasks");
        generator.write(this.numberOfPendingTasks);
        generator.writeKey("relocating_shards");
        generator.write(this.relocatingShards);
        generator.writeKey("status");
        this.status.serialize(generator, mapper);
        if (this.taskMaxWaitingInQueue != null) {
            generator.writeKey("task_max_waiting_in_queue");
            this.taskMaxWaitingInQueue.serialize(generator, mapper);
        }
        generator.writeKey("task_max_waiting_in_queue_millis");
        generator.write(this.taskMaxWaitingInQueueMillis);
        generator.writeKey("timed_out");
        generator.write(this.timedOut);
        generator.writeKey("unassigned_shards");
        generator.write(this.unassignedShards);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupHealthResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::activePrimaryShards, JsonpDeserializer.integerDeserializer(), "active_primary_shards");
        op.add(Builder::activeShards, JsonpDeserializer.integerDeserializer(), "active_shards");
        op.add(Builder::activeShardsPercent, JsonpDeserializer.stringDeserializer(), "active_shards_percent");
        op.add(Builder::activeShardsPercentAsNumber, JsonpDeserializer.doubleDeserializer(), "active_shards_percent_as_number");
        op.add(Builder::awarenessAttributes, JsonpDeserializer.stringMapDeserializer(AwarenessAttributeStats._DESERIALIZER), "awareness_attributes");
        op.add(Builder::clusterName, JsonpDeserializer.stringDeserializer(), "cluster_name");
        op.add(Builder::delayedUnassignedShards, JsonpDeserializer.integerDeserializer(), "delayed_unassigned_shards");
        op.add(Builder::discoveredClusterManager, JsonpDeserializer.booleanDeserializer(), "discovered_cluster_manager");
        op.add(Builder::discoveredMaster, JsonpDeserializer.booleanDeserializer(), "discovered_master");
        op.add(Builder::indices, JsonpDeserializer.stringMapDeserializer(IndexHealthStats._DESERIALIZER), "indices");
        op.add(Builder::initializingShards, JsonpDeserializer.integerDeserializer(), "initializing_shards");
        op.add(Builder::numberOfDataNodes, JsonpDeserializer.integerDeserializer(), "number_of_data_nodes");
        op.add(Builder::numberOfInFlightFetch, JsonpDeserializer.integerDeserializer(), "number_of_in_flight_fetch");
        op.add(Builder::numberOfNodes, JsonpDeserializer.integerDeserializer(), "number_of_nodes");
        op.add(Builder::numberOfPendingTasks, JsonpDeserializer.integerDeserializer(), "number_of_pending_tasks");
        op.add(Builder::relocatingShards, JsonpDeserializer.integerDeserializer(), "relocating_shards");
        op.add(Builder::status, HealthStatus._DESERIALIZER, "status");
        op.add(Builder::taskMaxWaitingInQueue, Time._DESERIALIZER, "task_max_waiting_in_queue");
        op.add(Builder::taskMaxWaitingInQueueMillis, JsonpDeserializer.longDeserializer(), "task_max_waiting_in_queue_millis");
        op.add(Builder::timedOut, JsonpDeserializer.booleanDeserializer(), "timed_out");
        op.add(Builder::unassignedShards, JsonpDeserializer.integerDeserializer(), "unassigned_shards");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Integer.hashCode(this.activePrimaryShards);
        result = 31 * result + Integer.hashCode(this.activeShards);
        result = 31 * result + Objects.hashCode(this.activeShardsPercent);
        result = 31 * result + Double.hashCode(this.activeShardsPercentAsNumber);
        result = 31 * result + Objects.hashCode(this.awarenessAttributes);
        result = 31 * result + this.clusterName.hashCode();
        result = 31 * result + Integer.hashCode(this.delayedUnassignedShards);
        result = 31 * result + Objects.hashCode(this.discoveredClusterManager);
        result = 31 * result + Objects.hashCode(this.discoveredMaster);
        result = 31 * result + Objects.hashCode(this.indices);
        result = 31 * result + Integer.hashCode(this.initializingShards);
        result = 31 * result + Integer.hashCode(this.numberOfDataNodes);
        result = 31 * result + Integer.hashCode(this.numberOfInFlightFetch);
        result = 31 * result + Integer.hashCode(this.numberOfNodes);
        result = 31 * result + Integer.hashCode(this.numberOfPendingTasks);
        result = 31 * result + Integer.hashCode(this.relocatingShards);
        result = 31 * result + this.status.hashCode();
        result = 31 * result + Objects.hashCode(this.taskMaxWaitingInQueue);
        result = 31 * result + Long.hashCode(this.taskMaxWaitingInQueueMillis);
        result = 31 * result + Boolean.hashCode(this.timedOut);
        result = 31 * result + Integer.hashCode(this.unassignedShards);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HealthResponse other = (HealthResponse)o;
        return this.activePrimaryShards == other.activePrimaryShards && this.activeShards == other.activeShards && Objects.equals(this.activeShardsPercent, other.activeShardsPercent) && this.activeShardsPercentAsNumber == other.activeShardsPercentAsNumber && Objects.equals(this.awarenessAttributes, other.awarenessAttributes) && this.clusterName.equals(other.clusterName) && this.delayedUnassignedShards == other.delayedUnassignedShards && Objects.equals(this.discoveredClusterManager, other.discoveredClusterManager) && Objects.equals(this.discoveredMaster, other.discoveredMaster) && Objects.equals(this.indices, other.indices) && this.initializingShards == other.initializingShards && this.numberOfDataNodes == other.numberOfDataNodes && this.numberOfInFlightFetch == other.numberOfInFlightFetch && this.numberOfNodes == other.numberOfNodes && this.numberOfPendingTasks == other.numberOfPendingTasks && this.relocatingShards == other.relocatingShards && this.status.equals(other.status) && Objects.equals(this.taskMaxWaitingInQueue, other.taskMaxWaitingInQueue) && this.taskMaxWaitingInQueueMillis == other.taskMaxWaitingInQueueMillis && this.timedOut == other.timedOut && this.unassignedShards == other.unassignedShards;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, HealthResponse> {
        private Integer activePrimaryShards;
        private Integer activeShards;
        @Nullable
        private String activeShardsPercent;
        private Double activeShardsPercentAsNumber;
        @Nullable
        private Map<String, AwarenessAttributeStats> awarenessAttributes;
        private String clusterName;
        private Integer delayedUnassignedShards;
        @Nullable
        private Boolean discoveredClusterManager;
        @Nullable
        private Boolean discoveredMaster;
        @Nullable
        private Map<String, IndexHealthStats> indices;
        private Integer initializingShards;
        private Integer numberOfDataNodes;
        private Integer numberOfInFlightFetch;
        private Integer numberOfNodes;
        private Integer numberOfPendingTasks;
        private Integer relocatingShards;
        private HealthStatus status;
        @Nullable
        private Time taskMaxWaitingInQueue;
        private Long taskMaxWaitingInQueueMillis;
        private Boolean timedOut;
        private Integer unassignedShards;

        public Builder() {
        }

        private Builder(HealthResponse o) {
            this.activePrimaryShards = o.activePrimaryShards;
            this.activeShards = o.activeShards;
            this.activeShardsPercent = o.activeShardsPercent;
            this.activeShardsPercentAsNumber = o.activeShardsPercentAsNumber;
            this.awarenessAttributes = Builder._mapCopy(o.awarenessAttributes);
            this.clusterName = o.clusterName;
            this.delayedUnassignedShards = o.delayedUnassignedShards;
            this.discoveredClusterManager = o.discoveredClusterManager;
            this.discoveredMaster = o.discoveredMaster;
            this.indices = Builder._mapCopy(o.indices);
            this.initializingShards = o.initializingShards;
            this.numberOfDataNodes = o.numberOfDataNodes;
            this.numberOfInFlightFetch = o.numberOfInFlightFetch;
            this.numberOfNodes = o.numberOfNodes;
            this.numberOfPendingTasks = o.numberOfPendingTasks;
            this.relocatingShards = o.relocatingShards;
            this.status = o.status;
            this.taskMaxWaitingInQueue = o.taskMaxWaitingInQueue;
            this.taskMaxWaitingInQueueMillis = o.taskMaxWaitingInQueueMillis;
            this.timedOut = o.timedOut;
            this.unassignedShards = o.unassignedShards;
        }

        private Builder(Builder o) {
            this.activePrimaryShards = o.activePrimaryShards;
            this.activeShards = o.activeShards;
            this.activeShardsPercent = o.activeShardsPercent;
            this.activeShardsPercentAsNumber = o.activeShardsPercentAsNumber;
            this.awarenessAttributes = Builder._mapCopy(o.awarenessAttributes);
            this.clusterName = o.clusterName;
            this.delayedUnassignedShards = o.delayedUnassignedShards;
            this.discoveredClusterManager = o.discoveredClusterManager;
            this.discoveredMaster = o.discoveredMaster;
            this.indices = Builder._mapCopy(o.indices);
            this.initializingShards = o.initializingShards;
            this.numberOfDataNodes = o.numberOfDataNodes;
            this.numberOfInFlightFetch = o.numberOfInFlightFetch;
            this.numberOfNodes = o.numberOfNodes;
            this.numberOfPendingTasks = o.numberOfPendingTasks;
            this.relocatingShards = o.relocatingShards;
            this.status = o.status;
            this.taskMaxWaitingInQueue = o.taskMaxWaitingInQueue;
            this.taskMaxWaitingInQueueMillis = o.taskMaxWaitingInQueueMillis;
            this.timedOut = o.timedOut;
            this.unassignedShards = o.unassignedShards;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder activePrimaryShards(int value) {
            this.activePrimaryShards = value;
            return this;
        }

        @Nonnull
        public final Builder activeShards(int value) {
            this.activeShards = value;
            return this;
        }

        @Nonnull
        public final Builder activeShardsPercent(@Nullable String value) {
            this.activeShardsPercent = value;
            return this;
        }

        @Nonnull
        public final Builder activeShardsPercentAsNumber(double value) {
            this.activeShardsPercentAsNumber = value;
            return this;
        }

        @Nonnull
        public final Builder awarenessAttributes(Map<String, AwarenessAttributeStats> map) {
            this.awarenessAttributes = Builder._mapPutAll(this.awarenessAttributes, map);
            return this;
        }

        @Nonnull
        public final Builder awarenessAttributes(String key, AwarenessAttributeStats value) {
            this.awarenessAttributes = Builder._mapPut(this.awarenessAttributes, key, value);
            return this;
        }

        @Nonnull
        public final Builder awarenessAttributes(String key, Function<AwarenessAttributeStats.Builder, ObjectBuilder<AwarenessAttributeStats>> fn) {
            return this.awarenessAttributes(key, fn.apply(new AwarenessAttributeStats.Builder()).build());
        }

        @Nonnull
        public final Builder clusterName(String value) {
            this.clusterName = value;
            return this;
        }

        @Nonnull
        public final Builder delayedUnassignedShards(int value) {
            this.delayedUnassignedShards = value;
            return this;
        }

        @Nonnull
        public final Builder discoveredClusterManager(@Nullable Boolean value) {
            this.discoveredClusterManager = value;
            return this;
        }

        @Nonnull
        public final Builder discoveredMaster(@Nullable Boolean value) {
            this.discoveredMaster = value;
            return this;
        }

        @Nonnull
        public final Builder indices(Map<String, IndexHealthStats> map) {
            this.indices = Builder._mapPutAll(this.indices, map);
            return this;
        }

        @Nonnull
        public final Builder indices(String key, IndexHealthStats value) {
            this.indices = Builder._mapPut(this.indices, key, value);
            return this;
        }

        @Nonnull
        public final Builder indices(String key, Function<IndexHealthStats.Builder, ObjectBuilder<IndexHealthStats>> fn) {
            return this.indices(key, fn.apply(new IndexHealthStats.Builder()).build());
        }

        @Nonnull
        public final Builder initializingShards(int value) {
            this.initializingShards = value;
            return this;
        }

        @Nonnull
        public final Builder numberOfDataNodes(int value) {
            this.numberOfDataNodes = value;
            return this;
        }

        @Nonnull
        public final Builder numberOfInFlightFetch(int value) {
            this.numberOfInFlightFetch = value;
            return this;
        }

        @Nonnull
        public final Builder numberOfNodes(int value) {
            this.numberOfNodes = value;
            return this;
        }

        @Nonnull
        public final Builder numberOfPendingTasks(int value) {
            this.numberOfPendingTasks = value;
            return this;
        }

        @Nonnull
        public final Builder relocatingShards(int value) {
            this.relocatingShards = value;
            return this;
        }

        @Nonnull
        public final Builder status(HealthStatus value) {
            this.status = value;
            return this;
        }

        @Nonnull
        public final Builder taskMaxWaitingInQueue(@Nullable Time value) {
            this.taskMaxWaitingInQueue = value;
            return this;
        }

        @Nonnull
        public final Builder taskMaxWaitingInQueue(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.taskMaxWaitingInQueue(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder taskMaxWaitingInQueueMillis(long value) {
            this.taskMaxWaitingInQueueMillis = value;
            return this;
        }

        @Nonnull
        public final Builder timedOut(boolean value) {
            this.timedOut = value;
            return this;
        }

        @Nonnull
        public final Builder unassignedShards(int value) {
            this.unassignedShards = value;
            return this;
        }

        @Override
        @Nonnull
        public HealthResponse build() {
            this._checkSingleUse();
            return new HealthResponse(this);
        }
    }
}

