-- Copyright © 2008-2025 Pioneer Developers. See AUTHORS.txt for details
-- Licensed under the terms of the GPL v3. See licenses/GPL-3.txt

-- used:
-- firstnames https://www.ssa.gov/oact/babynames/decades/century.html
-- lastnames https://www.thoughtco.com/most-common-us-surnames-1422656

local CultureName = require './common'

local male = {
	"James",
	"Robert",
	"John",
	"Michael",
	"William",
	"David",
	"Richard",
	"Joseph",
	"Thomas",
	"Charles",
	"Christopher",
	"Daniel",
	"Matthew",
	"Anthony",
	"Mark",
	"Donald",
	"Steven",
	"Paul",
	"Andrew",
	"Joshua",
	"Kenneth",
	"Kevin",
	"Brian",
	"George",
	"Edward",
	"Ronald",
	"Timothy",
	"Jason",
	"Jeffrey",
	"Ryan",
	"Jacob",
	"Gary",
	"Nicholas",
	"Eric",
	"Jonathan",
	"Stephen",
	"Larry",
	"Justin",
	"Scott",
	"Brandon",
	"Benjamin",
	"Samuel",
	"Gregory",
	"Frank",
	"Alexander",
	"Raymond",
	"Patrick",
	"Jack",
	"Dennis",
	"Jerry",
	"Tyler",
	"Aaron",
	"Jose",
	"Adam",
	"Henry",
	"Nathan",
	"Douglas",
	"Zachary",
	"Peter",
	"Kyle",
	"Walter",
	"Ethan",
	"Jeremy",
	"Harold",
	"Keith",
	"Christian",
	"Roger",
	"Noah",
	"Gerald",
	"Carl",
	"Terry",
	"Sean",
	"Austin",
	"Arthur",
	"Lawrence",
	"Jesse",
	"Dylan",
	"Bryan",
	"Joe",
	"Jordan",
	"Billy",
	"Bruce",
	"Albert",
	"Willie",
	"Gabriel",
	"Logan",
	"Alan",
	"Juan",
	"Wayne",
	"Roy",
	"Ralph",
	"Randy",
	"Eugene",
	"Vincent",
	"Russell",
	"Elijah",
	"Louis",
	"Bobby",
	"Philip",
	"Johnny",
}

local female = {
	"Mary",
	"Patricia",
	"Jennifer",
	"Linda",
	"Elizabeth",
	"Barbara",
	"Susan",
	"Jessica",
	"Sarah",
	"Karen",
	"Nancy",
	"Lisa",
	"Betty",
	"Margaret",
	"Sandra",
	"Ashley",
	"Kimberly",
	"Emily",
	"Donna",
	"Michelle",
	"Dorothy",
	"Carol",
	"Amanda",
	"Melissa",
	"Deborah",
	"Stephanie",
	"Rebecca",
	"Sharon",
	"Laura",
	"Cynthia",
	"Kathleen",
	"Amy",
	"Shirley",
	"Angela",
	"Helen",
	"Anna",
	"Brenda",
	"Pamela",
	"Nicole",
	"Emma",
	"Samantha",
	"Katherine",
	"Christine",
	"Debra",
	"Rachel",
	"Catherine",
	"Carolyn",
	"Janet",
	"Ruth",
	"Maria",
	"Heather",
	"Diane",
	"Virginia",
	"Julie",
	"Joyce",
	"Victoria",
	"Olivia",
	"Kelly",
	"Christina",
	"Lauren",
	"Joan",
	"Evelyn",
	"Judith",
	"Megan",
	"Cheryl",
	"Andrea",
	"Hannah",
	"Martha",
	"Jacqueline",
	"Frances",
	"Gloria",
	"Ann",
	"Teresa",
	"Kathryn",
	"Sara",
	"Janice",
	"Jean",
	"Alice",
	"Madison",
	"Doris",
	"Abigail",
	"Julia",
	"Judy",
	"Grace",
	"Denise",
	"Amber",
	"Marilyn",
	"Beverly",
	"Danielle",
	"Theresa",
	"Sophia",
	"Marie",
	"Diana",
	"Brittany",
	"Natalie",
	"Isabella",
	"Charlotte",
	"Rose",
	"Alexis",
	"Kayla",
}


local surname = {
	"Smith",
	"Johnson",
	"Williams",
	"Brown",
	"Jones",
	"Garcia",
	"Miller",
	"Davis",
	"Rodriguez",
	"Martinez",
	"Hernandez",
	"Lopez",
	"Spanish",
	"Gonzales",
	"Wilson",
	"Anderson",
	"Thomas",
	"Taylor",
	"Moore",
	"Jackson",
	"Martin",
	"Lee",
	"Perez",
	"Thompson",
	"White",
	"Harris",
	"Sanchez",
	"Clark",
	"Ramirez",
	"Lewis",
	"Robinson",
	"Walker",
	"Young",
	"Allen",
	"King",
	"Wright",
	"Scott",
	"Torres",
	"Nguyen",
	"Hill",
	"Flores",
	"Green",
	"Adams",
	"Nelson",
	"Baker",
	"Hall",
	"Rivera",
	"Campbell",
	"Mitchell",
	"Carter",
	"Roberts",
	"Gomez",
	"Phillips",
	"Evans",
	"Turner",
	"Diaz",
	"Parker",
	"Cruz",
	"Edwards",
	"Collins",
	"Reyes",
	"Stewart",
	"Morris",
	"Morales",
	"Murphy",
	"Cook",
	"Rogers",
	"Gutierrez",
	"Ortiz",
	"Morgan",
	"Cooper",
	"Peterson",
	"Bailey",
	"Reed",
	"Kelly",
	"Howard",
	"Ramos",
	"Kim",
	"Cox",
	"Ward",
	"Richardson",
	"Watson",
	"Brooks",
	"Chavez",
	"Wood",
	"James",
	"Bennet",
	"Gray",
	"Mendoza",
	"Ruiz",
	"Hughes",
	"Price",
	"Alvarez",
	"Castillo",
	"Sanders",
	"Patel",
	"Myers",
	"Long",
	"Ross",
	"Foster",
	"Jimenez",
}

local USA = CultureName.New({
	male = male,
	female = female,
	surname = surname,
	name = "American",
	code = "us",
})

return USA
