/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin;

import net.sourceforge.plantuml.klimt.Fashion;
import net.sourceforge.plantuml.klimt.UPath;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.UEllipse;
import net.sourceforge.plantuml.klimt.shape.ULine;

public class ActorStickMan
extends AbstractTextBlock
implements TextBlock {
    private final double armsY = 8.0;
    private final double armsLenght = 13.0;
    private final double bodyLenght = 27.0;
    private final double legsX = 13.0;
    private final double legsY = 15.0;
    private final double headDiam = 16.0;
    private final Fashion fashion;
    private final boolean actorBusiness;

    ActorStickMan(Fashion fashion, boolean actorBusiness) {
        this.fashion = fashion;
        this.actorBusiness = actorBusiness;
    }

    @Override
    public void drawU(UGraphic ug) {
        double startX = Math.max(13.0, 13.0) - 8.0 + this.thickness();
        UEllipse head = UEllipse.build(16.0, 16.0);
        double centerX = startX + 8.0;
        UPath path = UPath.none();
        path.moveTo(0.0, 0.0);
        path.lineTo(0.0, 27.0);
        path.moveTo(-13.0, 8.0);
        path.lineTo(13.0, 8.0);
        path.moveTo(0.0, 27.0);
        path.lineTo(-13.0, 42.0);
        path.moveTo(0.0, 27.0);
        path.lineTo(13.0, 42.0);
        if (this.fashion.getDeltaShadow() != 0.0) {
            head.setDeltaShadow(this.fashion.getDeltaShadow());
            path.setDeltaShadow(this.fashion.getDeltaShadow());
        }
        ug = this.fashion.apply(ug);
        ug.apply(new UTranslate(startX, this.thickness())).draw(head);
        if (this.actorBusiness) {
            this.specialBusiness(ug.apply(new UTranslate(startX + 8.0, this.thickness() + 8.0)));
        }
        ug.apply(new UTranslate(centerX, 16.0 + this.thickness())).apply(HColors.none().bg()).draw(path);
    }

    private void specialBusiness(UGraphic ug) {
        double alpha = 1.030835089459151;
        XPoint2D p1 = this.getOnCircle(1.8162332528565992);
        XPoint2D p2 = this.getOnCircle(-0.24543692606170264);
        ug = ug.apply(UTranslate.point(p1));
        ug.draw(new ULine(p2.getX() - p1.getX(), p2.getY() - p1.getY()));
    }

    private XPoint2D getOnCircle(double alpha) {
        double x = 8.0 * Math.cos(alpha);
        double y = 8.0 * Math.sin(alpha);
        return new XPoint2D(x, y);
    }

    private double thickness() {
        return this.fashion.getStroke().getThickness();
    }

    public double getPreferredWidth() {
        return Math.max(13.0, 13.0) * 2.0 + 2.0 * this.thickness();
    }

    public double getPreferredHeight() {
        return 58.0 + 2.0 * this.thickness() + this.fashion.getDeltaShadow() + 1.0;
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        return new XDimension2D(this.getPreferredWidth(), this.getPreferredHeight());
    }
}

