/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api.recursive.comparison;

import org.assertj.core.api.recursive.comparison.ComparisonDifference;
import org.assertj.core.api.recursive.comparison.DualValue;
import org.assertj.core.internal.UnambiguousRepresentation;
import org.assertj.core.presentation.Representation;

public class ComparisonKeyDifference
extends ComparisonDifference {
    static final String TEMPLATE_FOR_KEY_DIFFERENCE = "map key difference:%n- actual key  : %s%n- expected key: %s";
    final Object actualKey;
    final Object expectedKey;

    public ComparisonKeyDifference(DualValue dualValue, Object actualKey, Object expectedKey) {
        super(dualValue);
        this.actualKey = actualKey;
        this.expectedKey = expectedKey;
    }

    @Override
    public String toString() {
        return "ComparisonDifference [path=%s, actualKey=%s, expectedKey=%s]".formatted(this.concatenatedPath, this.actualKey, this.expectedKey);
    }

    @Override
    public String multiLineDescription(Representation representation) {
        UnambiguousRepresentation unambiguousRepresentation = new UnambiguousRepresentation(representation, this.actual, this.expected);
        UnambiguousRepresentation unambiguousKeyRepresentation = new UnambiguousRepresentation(representation, this.actualKey, this.expectedKey);
        return String.format("%s differ:%n- actual value  : %s%n- expected value: %s%s%nmap key difference:%n- actual key  : %s%n- expected key: %s", this.fieldPathDescription(), unambiguousRepresentation.getActual(), unambiguousRepresentation.getExpected(), "", unambiguousKeyRepresentation.getActual(), unambiguousKeyRepresentation.getExpected());
    }
}

