/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation.docstrings;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ProcessingContext;
import com.jetbrains.python.documentation.docstrings.DocStringFormat;
import com.jetbrains.python.documentation.docstrings.DocStringParser;
import com.jetbrains.python.documentation.docstrings.DocStringTagCompletionContributor;
import com.jetbrains.python.documentation.docstrings.GoogleCodeStyleDocString;
import com.jetbrains.python.documentation.docstrings.NumpyDocString;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class DocStringSectionHeaderCompletionContributor
extends CompletionContributor
implements DumbAware {
    public DocStringSectionHeaderCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(DocStringTagCompletionContributor.DOCSTRING_PATTERN), (CompletionProvider)new CompletionProvider<CompletionParameters>(this){

            protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (result == null) {
                    1.$$$reportNull$$$0(2);
                }
                PsiFile file = parameters.getOriginalFile();
                PsiElement stringNode = parameters.getOriginalPosition();
                assert (stringNode != null);
                int offset = parameters.getOffset();
                DocStringFormat format = DocStringParser.getConfiguredDocStringFormat((PsiElement)file);
                if (format != DocStringFormat.GOOGLE && format != DocStringFormat.NUMPY) {
                    return;
                }
                if (format == DocStringFormat.GOOGLE && file.findReferenceAt(offset) != null) {
                    return;
                }
                Document document = parameters.getEditor().getDocument();
                TextRange linePrefixRange = new TextRange(document.getLineStartOffset(document.getLineNumber(offset)), offset);
                String prefix = StringUtil.trimLeading((String)document.getText(linePrefixRange));
                result = result.withPrefixMatcher(prefix).caseInsensitive();
                List names = format == DocStringFormat.GOOGLE ? GoogleCodeStyleDocString.PREFERRED_SECTION_HEADERS : NumpyDocString.PREFERRED_SECTION_HEADERS;
                for (String tag : names) {
                    result.addElement((LookupElement)LookupElementBuilder.create((String)tag));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/python/documentation/docstrings/DocStringSectionHeaderCompletionContributor$1";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }
}

