#  Copyright 2000-2025 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.

from typing import Any

def skip_if(predicate, reason: Any | None = ...): ...
def fails_if(predicate, reason: Any | None = ...): ...

class compound:
    fails: Any
    skips: Any
    tags: Any
    def __init__(self) -> None: ...
    def __add__(self, other): ...
    def as_skips(self): ...
    def add(self, *others): ...
    def not_(self): ...
    @property
    def enabled(self): ...
    def enabled_for_config(self, config): ...
    def matching_config_reasons(self, config): ...
    def include_test(self, include_tags, exclude_tags): ...
    def __call__(self, fn): ...
    def fail_if(self) -> None: ...

def requires_tag(tagname): ...
def tags(tagnames): ...
def only_if(predicate, reason: Any | None = ...): ...
def succeeds_if(predicate, reason: Any | None = ...): ...

class Predicate:
    @classmethod
    def as_predicate(cls, predicate, description: Any | None = ...): ...

class BooleanPredicate(Predicate):
    value: Any
    description: Any
    def __init__(self, value, description: Any | None = ...) -> None: ...
    def __call__(self, config): ...

class SpecPredicate(Predicate):
    db: Any
    op: Any
    spec: Any
    description: Any
    def __init__(self, db, op: Any | None = ..., spec: Any | None = ..., description: Any | None = ...) -> None: ...
    def __call__(self, config): ...

class LambdaPredicate(Predicate):
    lambda_: Any
    args: Any
    kw: Any
    description: Any
    def __init__(self, lambda_, description: Any | None = ..., args: Any | None = ..., kw: Any | None = ...): ...
    def __call__(self, config): ...

class NotPredicate(Predicate):
    predicate: Any
    description: Any
    def __init__(self, predicate, description: Any | None = ...) -> None: ...
    def __call__(self, config): ...

class OrPredicate(Predicate):
    predicates: Any
    description: Any
    def __init__(self, predicates, description: Any | None = ...) -> None: ...
    def __call__(self, config): ...

def db_spec(*dbs): ...
def open(): ...
def closed(): ...
def fails(reason: Any | None = ...): ...
def future(fn, *arg): ...
def fails_on(db, reason: Any | None = ...): ...
def fails_on_everything_except(*dbs): ...
def skip(db, reason: Any | None = ...): ...
def only_on(dbs, reason: Any | None = ...): ...
def exclude(db, op, spec, reason: Any | None = ...): ...
def against(config, *queries): ...
