# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

from typing import Dict, Union, Iterable, Optional
from typing_extensions import Literal, Required, TypeAlias, TypedDict

from ..._types import SequenceNotStr
from .easy_input_message_param import EasyInputMessageParam
from .response_output_message_param import ResponseOutputMessageParam
from .response_reasoning_item_param import ResponseReasoningItemParam
from .response_custom_tool_call_param import ResponseCustomToolCallParam
from .response_computer_tool_call_param import ResponseComputerToolCallParam
from .response_function_tool_call_param import ResponseFunctionToolCallParam
from .response_function_web_search_param import ResponseFunctionWebSearchParam
from .response_compaction_item_param_param import ResponseCompactionItemParamParam
from .response_file_search_tool_call_param import ResponseFileSearchToolCallParam
from .response_custom_tool_call_output_param import ResponseCustomToolCallOutputParam
from .response_code_interpreter_tool_call_param import ResponseCodeInterpreterToolCallParam
from .response_input_message_content_list_param import ResponseInputMessageContentListParam
from .response_function_call_output_item_list_param import ResponseFunctionCallOutputItemListParam
from .response_function_shell_call_output_content_param import ResponseFunctionShellCallOutputContentParam
from .response_computer_tool_call_output_screenshot_param import ResponseComputerToolCallOutputScreenshotParam

__all__ = [
    "ResponseInputItemParam",
    "Message",
    "ComputerCallOutput",
    "ComputerCallOutputAcknowledgedSafetyCheck",
    "FunctionCallOutput",
    "ImageGenerationCall",
    "LocalShellCall",
    "LocalShellCallAction",
    "LocalShellCallOutput",
    "ShellCall",
    "ShellCallAction",
    "ShellCallOutput",
    "ApplyPatchCall",
    "ApplyPatchCallOperation",
    "ApplyPatchCallOperationCreateFile",
    "ApplyPatchCallOperationDeleteFile",
    "ApplyPatchCallOperationUpdateFile",
    "ApplyPatchCallOutput",
    "McpListTools",
    "McpListToolsTool",
    "McpApprovalRequest",
    "McpApprovalResponse",
    "McpCall",
    "ItemReference",
]


class Message(TypedDict, total=False):
    content: Required[ResponseInputMessageContentListParam]
    """
    A list of one or many input items to the model, containing different content
    types.
    """

    role: Required[Literal["user", "system", "developer"]]
    """The role of the message input. One of `user`, `system`, or `developer`."""

    status: Literal["in_progress", "completed", "incomplete"]
    """The status of item.

    One of `in_progress`, `completed`, or `incomplete`. Populated when items are
    returned via API.
    """

    type: Literal["message"]
    """The type of the message input. Always set to `message`."""


class ComputerCallOutputAcknowledgedSafetyCheck(TypedDict, total=False):
    id: Required[str]
    """The ID of the pending safety check."""

    code: Optional[str]
    """The type of the pending safety check."""

    message: Optional[str]
    """Details about the pending safety check."""


class ComputerCallOutput(TypedDict, total=False):
    call_id: Required[str]
    """The ID of the computer tool call that produced the output."""

    output: Required[ResponseComputerToolCallOutputScreenshotParam]
    """A computer screenshot image used with the computer use tool."""

    type: Required[Literal["computer_call_output"]]
    """The type of the computer tool call output. Always `computer_call_output`."""

    id: Optional[str]
    """The ID of the computer tool call output."""

    acknowledged_safety_checks: Optional[Iterable[ComputerCallOutputAcknowledgedSafetyCheck]]
    """
    The safety checks reported by the API that have been acknowledged by the
    developer.
    """

    status: Optional[Literal["in_progress", "completed", "incomplete"]]
    """The status of the message input.

    One of `in_progress`, `completed`, or `incomplete`. Populated when input items
    are returned via API.
    """


class FunctionCallOutput(TypedDict, total=False):
    call_id: Required[str]
    """The unique ID of the function tool call generated by the model."""

    output: Required[Union[str, ResponseFunctionCallOutputItemListParam]]
    """Text, image, or file output of the function tool call."""

    type: Required[Literal["function_call_output"]]
    """The type of the function tool call output. Always `function_call_output`."""

    id: Optional[str]
    """The unique ID of the function tool call output.

    Populated when this item is returned via API.
    """

    status: Optional[Literal["in_progress", "completed", "incomplete"]]
    """The status of the item.

    One of `in_progress`, `completed`, or `incomplete`. Populated when items are
    returned via API.
    """


class ImageGenerationCall(TypedDict, total=False):
    id: Required[str]
    """The unique ID of the image generation call."""

    result: Required[Optional[str]]
    """The generated image encoded in base64."""

    status: Required[Literal["in_progress", "completed", "generating", "failed"]]
    """The status of the image generation call."""

    type: Required[Literal["image_generation_call"]]
    """The type of the image generation call. Always `image_generation_call`."""


class LocalShellCallAction(TypedDict, total=False):
    command: Required[SequenceNotStr[str]]
    """The command to run."""

    env: Required[Dict[str, str]]
    """Environment variables to set for the command."""

    type: Required[Literal["exec"]]
    """The type of the local shell action. Always `exec`."""

    timeout_ms: Optional[int]
    """Optional timeout in milliseconds for the command."""

    user: Optional[str]
    """Optional user to run the command as."""

    working_directory: Optional[str]
    """Optional working directory to run the command in."""


class LocalShellCall(TypedDict, total=False):
    id: Required[str]
    """The unique ID of the local shell call."""

    action: Required[LocalShellCallAction]
    """Execute a shell command on the server."""

    call_id: Required[str]
    """The unique ID of the local shell tool call generated by the model."""

    status: Required[Literal["in_progress", "completed", "incomplete"]]
    """The status of the local shell call."""

    type: Required[Literal["local_shell_call"]]
    """The type of the local shell call. Always `local_shell_call`."""


class LocalShellCallOutput(TypedDict, total=False):
    id: Required[str]
    """The unique ID of the local shell tool call generated by the model."""

    output: Required[str]
    """A JSON string of the output of the local shell tool call."""

    type: Required[Literal["local_shell_call_output"]]
    """The type of the local shell tool call output. Always `local_shell_call_output`."""

    status: Optional[Literal["in_progress", "completed", "incomplete"]]
    """The status of the item. One of `in_progress`, `completed`, or `incomplete`."""


class ShellCallAction(TypedDict, total=False):
    commands: Required[SequenceNotStr[str]]
    """Ordered shell commands for the execution environment to run."""

    max_output_length: Optional[int]
    """
    Maximum number of UTF-8 characters to capture from combined stdout and stderr
    output.
    """

    timeout_ms: Optional[int]
    """Maximum wall-clock time in milliseconds to allow the shell commands to run."""


class ShellCall(TypedDict, total=False):
    action: Required[ShellCallAction]
    """The shell commands and limits that describe how to run the tool call."""

    call_id: Required[str]
    """The unique ID of the shell tool call generated by the model."""

    type: Required[Literal["shell_call"]]
    """The type of the item. Always `shell_call`."""

    id: Optional[str]
    """The unique ID of the shell tool call.

    Populated when this item is returned via API.
    """

    status: Optional[Literal["in_progress", "completed", "incomplete"]]
    """The status of the shell call.

    One of `in_progress`, `completed`, or `incomplete`.
    """


class ShellCallOutput(TypedDict, total=False):
    call_id: Required[str]
    """The unique ID of the shell tool call generated by the model."""

    output: Required[Iterable[ResponseFunctionShellCallOutputContentParam]]
    """
    Captured chunks of stdout and stderr output, along with their associated
    outcomes.
    """

    type: Required[Literal["shell_call_output"]]
    """The type of the item. Always `shell_call_output`."""

    id: Optional[str]
    """The unique ID of the shell tool call output.

    Populated when this item is returned via API.
    """

    max_output_length: Optional[int]
    """
    The maximum number of UTF-8 characters captured for this shell call's combined
    output.
    """


class ApplyPatchCallOperationCreateFile(TypedDict, total=False):
    diff: Required[str]
    """Unified diff content to apply when creating the file."""

    path: Required[str]
    """Path of the file to create relative to the workspace root."""

    type: Required[Literal["create_file"]]
    """The operation type. Always `create_file`."""


class ApplyPatchCallOperationDeleteFile(TypedDict, total=False):
    path: Required[str]
    """Path of the file to delete relative to the workspace root."""

    type: Required[Literal["delete_file"]]
    """The operation type. Always `delete_file`."""


class ApplyPatchCallOperationUpdateFile(TypedDict, total=False):
    diff: Required[str]
    """Unified diff content to apply to the existing file."""

    path: Required[str]
    """Path of the file to update relative to the workspace root."""

    type: Required[Literal["update_file"]]
    """The operation type. Always `update_file`."""


ApplyPatchCallOperation: TypeAlias = Union[
    ApplyPatchCallOperationCreateFile, ApplyPatchCallOperationDeleteFile, ApplyPatchCallOperationUpdateFile
]


class ApplyPatchCall(TypedDict, total=False):
    call_id: Required[str]
    """The unique ID of the apply patch tool call generated by the model."""

    operation: Required[ApplyPatchCallOperation]
    """
    The specific create, delete, or update instruction for the apply_patch tool
    call.
    """

    status: Required[Literal["in_progress", "completed"]]
    """The status of the apply patch tool call. One of `in_progress` or `completed`."""

    type: Required[Literal["apply_patch_call"]]
    """The type of the item. Always `apply_patch_call`."""

    id: Optional[str]
    """The unique ID of the apply patch tool call.

    Populated when this item is returned via API.
    """


class ApplyPatchCallOutput(TypedDict, total=False):
    call_id: Required[str]
    """The unique ID of the apply patch tool call generated by the model."""

    status: Required[Literal["completed", "failed"]]
    """The status of the apply patch tool call output. One of `completed` or `failed`."""

    type: Required[Literal["apply_patch_call_output"]]
    """The type of the item. Always `apply_patch_call_output`."""

    id: Optional[str]
    """The unique ID of the apply patch tool call output.

    Populated when this item is returned via API.
    """

    output: Optional[str]
    """
    Optional human-readable log text from the apply patch tool (e.g., patch results
    or errors).
    """


class McpListToolsTool(TypedDict, total=False):
    input_schema: Required[object]
    """The JSON schema describing the tool's input."""

    name: Required[str]
    """The name of the tool."""

    annotations: Optional[object]
    """Additional annotations about the tool."""

    description: Optional[str]
    """The description of the tool."""


class McpListTools(TypedDict, total=False):
    id: Required[str]
    """The unique ID of the list."""

    server_label: Required[str]
    """The label of the MCP server."""

    tools: Required[Iterable[McpListToolsTool]]
    """The tools available on the server."""

    type: Required[Literal["mcp_list_tools"]]
    """The type of the item. Always `mcp_list_tools`."""

    error: Optional[str]
    """Error message if the server could not list tools."""


class McpApprovalRequest(TypedDict, total=False):
    id: Required[str]
    """The unique ID of the approval request."""

    arguments: Required[str]
    """A JSON string of arguments for the tool."""

    name: Required[str]
    """The name of the tool to run."""

    server_label: Required[str]
    """The label of the MCP server making the request."""

    type: Required[Literal["mcp_approval_request"]]
    """The type of the item. Always `mcp_approval_request`."""


class McpApprovalResponse(TypedDict, total=False):
    approval_request_id: Required[str]
    """The ID of the approval request being answered."""

    approve: Required[bool]
    """Whether the request was approved."""

    type: Required[Literal["mcp_approval_response"]]
    """The type of the item. Always `mcp_approval_response`."""

    id: Optional[str]
    """The unique ID of the approval response"""

    reason: Optional[str]
    """Optional reason for the decision."""


class McpCall(TypedDict, total=False):
    id: Required[str]
    """The unique ID of the tool call."""

    arguments: Required[str]
    """A JSON string of the arguments passed to the tool."""

    name: Required[str]
    """The name of the tool that was run."""

    server_label: Required[str]
    """The label of the MCP server running the tool."""

    type: Required[Literal["mcp_call"]]
    """The type of the item. Always `mcp_call`."""

    approval_request_id: Optional[str]
    """
    Unique identifier for the MCP tool call approval request. Include this value in
    a subsequent `mcp_approval_response` input to approve or reject the
    corresponding tool call.
    """

    error: Optional[str]
    """The error from the tool call, if any."""

    output: Optional[str]
    """The output from the tool call."""

    status: Literal["in_progress", "completed", "incomplete", "calling", "failed"]
    """The status of the tool call.

    One of `in_progress`, `completed`, `incomplete`, `calling`, or `failed`.
    """


class ItemReference(TypedDict, total=False):
    id: Required[str]
    """The ID of the item to reference."""

    type: Optional[Literal["item_reference"]]
    """The type of item to reference. Always `item_reference`."""


ResponseInputItemParam: TypeAlias = Union[
    EasyInputMessageParam,
    Message,
    ResponseOutputMessageParam,
    ResponseFileSearchToolCallParam,
    ResponseComputerToolCallParam,
    ComputerCallOutput,
    ResponseFunctionWebSearchParam,
    ResponseFunctionToolCallParam,
    FunctionCallOutput,
    ResponseReasoningItemParam,
    ResponseCompactionItemParamParam,
    ImageGenerationCall,
    ResponseCodeInterpreterToolCallParam,
    LocalShellCall,
    LocalShellCallOutput,
    ShellCall,
    ShellCallOutput,
    ApplyPatchCall,
    ApplyPatchCallOutput,
    McpListTools,
    McpApprovalRequest,
    McpApprovalResponse,
    McpCall,
    ResponseCustomToolCallOutputParam,
    ResponseCustomToolCallParam,
    ItemReference,
]
