/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.loader.attributes.model;

import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import schemacrawler.loader.attributes.model.ObjectAttributes;
import schemacrawler.loader.attributes.model.TableAttributes;

public class WeakAssociationAttributes
extends ObjectAttributes {
    private static final long serialVersionUID = 8305929253225133307L;
    private final TableAttributes dependentTable;
    private final TableAttributes referencedTable;
    private final Map<String, String> columnReferences;

    @ConstructorProperties(value={"name", "remarks", "attributes", "referenced-table", "referencing-table", "column-references"})
    public WeakAssociationAttributes(String name, List<String> remarks, Map<String, String> attributes, TableAttributes referencedTable, TableAttributes dependentTable, Map<String, String> columnReferences) {
        super(name, remarks, attributes);
        this.referencedTable = Objects.requireNonNull(referencedTable, "No referenced table provided");
        this.dependentTable = Objects.requireNonNull(dependentTable, "No referencing table provided");
        if (columnReferences == null || columnReferences.isEmpty()) {
            throw new IllegalArgumentException("No column references provided");
        }
        this.columnReferences = columnReferences;
    }

    public Map<String, String> getColumnReferences() {
        return this.columnReferences;
    }

    public TableAttributes getReferencedTable() {
        return this.referencedTable;
    }

    public TableAttributes getDependentTable() {
        return this.dependentTable;
    }
}

