/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.firebirdsql.encodings.Encoding;
import org.firebirdsql.encodings.EncodingDefinition;
import org.firebirdsql.encodings.IEncodingFactory;
import org.firebirdsql.extern.decimal.Decimal128;
import org.firebirdsql.extern.decimal.Decimal64;
import org.firebirdsql.gds.JaybirdSystemProperties;
import org.firebirdsql.gds.ng.DatatypeCoder;
import org.firebirdsql.gds.ng.EncodingSpecificDatatypeCoder;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public class DefaultDatatypeCoder
implements DatatypeCoder {
    private static final Logger logger = LoggerFactory.getLogger(DefaultDatatypeCoder.class);
    private static final int DEFAULT_DATATYPE_CODER_CACHE_SIZE = 10;
    private static final int DATATYPE_CODER_CACHE_SIZE = Math.max(1, JaybirdSystemProperties.getDatatypeCoderCacheSize(10));
    private static final int LOG_CACHE_MAINTENANCE_WARNING = 10;
    private final IEncodingFactory encodingFactory;
    private final Encoding encoding;
    private final ConcurrentMap<EncodingDefinition, DatatypeCoder> encodingSpecificDatatypeCoders = new ConcurrentHashMap<EncodingDefinition, DatatypeCoder>(DATATYPE_CODER_CACHE_SIZE);
    private final Lock cacheMaintenanceLock = new ReentrantLock();
    private int cacheMaintenanceCount = 0;

    public static DefaultDatatypeCoder forEncodingFactory(IEncodingFactory encodingFactory) {
        return encodingFactory.getOrCreateDatatypeCoder(DefaultDatatypeCoder.class);
    }

    public DefaultDatatypeCoder(IEncodingFactory encodingFactory) {
        this.encodingFactory = Objects.requireNonNull(encodingFactory, "encodingFactory");
        this.encoding = encodingFactory.getDefaultEncoding();
    }

    @Override
    public int sizeOfShort() {
        return 4;
    }

    @Override
    public byte[] encodeShort(short value) {
        return this.encodeInt(value);
    }

    @Override
    public byte[] encodeShort(int value) {
        return this.encodeShort((short)value);
    }

    @Override
    public void encodeShort(int value, byte[] target, int fromIndex) {
        this.encodeInt(value, target, fromIndex);
    }

    @Override
    public short decodeShort(byte[] byte_int) {
        return (short)this.decodeInt(byte_int);
    }

    @Override
    public short decodeShort(byte[] bytes, int fromIndex) {
        return (short)this.decodeInt(bytes, fromIndex);
    }

    @Override
    public byte[] encodeInt(int value) {
        byte[] ret = new byte[4];
        this.encodeInt(value, ret, 0);
        return ret;
    }

    @Override
    public void encodeInt(int value, byte[] target, int fromIndex) {
        target[fromIndex] = (byte)(value >>> 24 & 0xFF);
        target[fromIndex + 1] = (byte)(value >>> 16 & 0xFF);
        target[fromIndex + 2] = (byte)(value >>> 8 & 0xFF);
        target[fromIndex + 3] = (byte)(value & 0xFF);
    }

    @Deprecated
    protected byte[] intToBytes(int value) {
        return this.encodeInt(value);
    }

    @Override
    public int decodeInt(byte[] byte_int) {
        return ((byte_int[0] & 0xFF) << 24) + ((byte_int[1] & 0xFF) << 16) + ((byte_int[2] & 0xFF) << 8) + (byte_int[3] & 0xFF);
    }

    @Override
    public int decodeInt(byte[] bytes, int fromIndex) {
        return ((bytes[fromIndex] & 0xFF) << 24) + ((bytes[fromIndex + 1] & 0xFF) << 16) + ((bytes[fromIndex + 2] & 0xFF) << 8) + (bytes[fromIndex + 3] & 0xFF);
    }

    @Override
    public byte[] encodeLong(long value) {
        byte[] ret = new byte[]{(byte)(value >>> 56 & 0xFFL), (byte)(value >>> 48 & 0xFFL), (byte)(value >>> 40 & 0xFFL), (byte)(value >>> 32 & 0xFFL), (byte)(value >>> 24 & 0xFFL), (byte)(value >>> 16 & 0xFFL), (byte)(value >>> 8 & 0xFFL), (byte)(value & 0xFFL)};
        return ret;
    }

    @Override
    public long decodeLong(byte[] byte_int) {
        return ((long)(byte_int[0] & 0xFF) << 56) + ((long)(byte_int[1] & 0xFF) << 48) + ((long)(byte_int[2] & 0xFF) << 40) + ((long)(byte_int[3] & 0xFF) << 32) + ((long)(byte_int[4] & 0xFF) << 24) + ((long)(byte_int[5] & 0xFF) << 16) + ((long)(byte_int[6] & 0xFF) << 8) + (long)(byte_int[7] & 0xFF);
    }

    @Override
    public byte[] encodeFloat(float value) {
        return this.encodeInt(Float.floatToIntBits(value));
    }

    @Override
    public float decodeFloat(byte[] byte_int) {
        return Float.intBitsToFloat(this.decodeInt(byte_int));
    }

    @Override
    public byte[] encodeDouble(double value) {
        return this.encodeLong(Double.doubleToLongBits(value));
    }

    @Override
    public double decodeDouble(byte[] byte_int) {
        return Double.longBitsToDouble(this.decodeLong(byte_int));
    }

    @Override
    public final byte[] encodeString(String value) {
        return this.encoding.encodeToCharset(value);
    }

    @Override
    public final Writer createWriter(OutputStream outputStream) {
        return this.encoding.createWriter(outputStream);
    }

    @Override
    public final String decodeString(byte[] value) {
        return this.encoding.decodeFromCharset(value);
    }

    @Override
    public final Reader createReader(InputStream inputStream) {
        return this.encoding.createReader(inputStream);
    }

    @Override
    public Timestamp encodeTimestamp(Timestamp value, Calendar cal, boolean invertTimeZone) {
        if (cal == null) {
            return value;
        }
        long time = value.getTime() + (long)this.calculateOffset(cal, invertTimeZone);
        return new Timestamp(time);
    }

    private int calculateOffset(Calendar cal, boolean invertTimeZone) {
        return (invertTimeZone ? -1 : 1) * (cal.getTimeZone().getRawOffset() - Calendar.getInstance().getTimeZone().getRawOffset());
    }

    @Override
    public byte[] encodeTimestampRaw(DatatypeCoder.RawDateTimeStruct raw) {
        return new datetime(raw).toTimestampBytes();
    }

    @Override
    public byte[] encodeTimestampCalendar(Timestamp value, Calendar c) {
        datetime d = new datetime(value, c);
        return d.toTimestampBytes();
    }

    @Override
    public Timestamp decodeTimestamp(Timestamp value, Calendar cal, boolean invertTimeZone) {
        if (cal == null) {
            return value;
        }
        long time = value.getTime() - (long)this.calculateOffset(cal, invertTimeZone);
        return new Timestamp(time);
    }

    @Override
    public DatatypeCoder.RawDateTimeStruct decodeTimestampRaw(byte[] byte_long) {
        datetime d = this.fromLongBytes(byte_long);
        return d.getRaw();
    }

    @Override
    public Timestamp decodeTimestampCalendar(byte[] byte_long, Calendar c) {
        datetime d = this.fromLongBytes(byte_long);
        return d.toTimestamp(c);
    }

    @Override
    public Time encodeTime(Time d, Calendar cal, boolean invertTimeZone) {
        if (cal == null) {
            return d;
        }
        long time = d.getTime() + (long)this.calculateOffset(cal, invertTimeZone);
        return new Time(time);
    }

    @Override
    public byte[] encodeTimeRaw(DatatypeCoder.RawDateTimeStruct raw) {
        return new datetime(raw).toTimeBytes();
    }

    @Override
    public byte[] encodeTimeCalendar(Time d, Calendar c) {
        datetime dt = new datetime(d, c);
        return dt.toTimeBytes();
    }

    @Override
    public Time decodeTime(Time d, Calendar cal, boolean invertTimeZone) {
        if (cal == null) {
            return d;
        }
        long time = d.getTime() - (long)this.calculateOffset(cal, invertTimeZone);
        return new Time(time);
    }

    @Override
    public DatatypeCoder.RawDateTimeStruct decodeTimeRaw(byte[] int_byte) {
        datetime d = new datetime(null, int_byte);
        return d.getRaw();
    }

    @Override
    public Time decodeTimeCalendar(byte[] int_byte, Calendar c) {
        datetime dt = new datetime(null, int_byte);
        return dt.toTime(c);
    }

    @Override
    public Date encodeDate(Date d, Calendar cal) {
        if (cal == null) {
            return d;
        }
        cal.setTime(d);
        return new Date(cal.getTime().getTime());
    }

    @Override
    public byte[] encodeDateRaw(DatatypeCoder.RawDateTimeStruct raw) {
        return new datetime(raw).toDateBytes();
    }

    @Override
    public byte[] encodeDateCalendar(Date d, Calendar c) {
        datetime dt = new datetime(d, c);
        return dt.toDateBytes();
    }

    @Override
    public Date decodeDate(Date d, Calendar cal) {
        if (cal == null || d == null) {
            return d;
        }
        cal.setTime(d);
        return new Date(cal.getTime().getTime());
    }

    @Override
    public DatatypeCoder.RawDateTimeStruct decodeDateRaw(byte[] byte_int) {
        datetime d = new datetime(byte_int, null);
        return d.getRaw();
    }

    @Override
    public Date decodeDateCalendar(byte[] byte_int, Calendar c) {
        datetime dt = new datetime(byte_int, null);
        return dt.toDate(c);
    }

    @Override
    public boolean decodeBoolean(byte[] data) {
        return data[0] != 0;
    }

    @Override
    public byte[] encodeBoolean(boolean value) {
        return new byte[]{(byte)(value ? 1 : 0)};
    }

    @Override
    public LocalTime decodeLocalTime(byte[] data) {
        datetime dt = new datetime(null, data);
        return dt.toLocalTime();
    }

    @Override
    public byte[] encodeLocalTime(LocalTime value) {
        datetime dt = new datetime(null, value);
        return dt.toTimeBytes();
    }

    @Override
    public LocalDate decodeLocalDate(byte[] data) {
        datetime dt = new datetime(data, null);
        return dt.toLocalDate();
    }

    @Override
    public byte[] encodeLocalDate(LocalDate value) {
        datetime dt = new datetime(value, null);
        return dt.toDateBytes();
    }

    @Override
    public LocalDateTime decodeLocalDateTime(byte[] data) {
        datetime dt = this.fromLongBytes(data);
        return dt.toLocalDateTime();
    }

    @Override
    public byte[] encodeLocalDateTime(LocalDateTime value) {
        datetime dt = new datetime(value);
        return dt.toTimestampBytes();
    }

    @Override
    public Decimal64 decodeDecimal64(byte[] data) {
        return Decimal64.parseBytes(data);
    }

    @Override
    public byte[] encodeDecimal64(Decimal64 decimal64) {
        return decimal64.toBytes();
    }

    @Override
    public Decimal128 decodeDecimal128(byte[] data) {
        return Decimal128.parseBytes(data);
    }

    @Override
    public byte[] encodeDecimal128(Decimal128 decimal128) {
        return decimal128.toBytes();
    }

    @Override
    public BigInteger decodeInt128(byte[] data) {
        return new BigInteger(data);
    }

    @Override
    public byte[] encodeInt128(BigInteger bigInteger) {
        if (bigInteger.bitLength() > 127) {
            throw new IllegalArgumentException("Received BigInteger value requires more than 16 bytes storage");
        }
        byte[] minimumBytes = bigInteger.toByteArray();
        if (minimumBytes.length == 16) {
            return minimumBytes;
        }
        byte[] int128Bytes = new byte[16];
        int startOfMinimum = 16 - minimumBytes.length;
        if (bigInteger.signum() == -1) {
            Arrays.fill(int128Bytes, 0, startOfMinimum, (byte)-1);
        }
        System.arraycopy(minimumBytes, 0, int128Bytes, startOfMinimum, minimumBytes.length);
        return int128Bytes;
    }

    @Override
    public final IEncodingFactory getEncodingFactory() {
        return this.encodingFactory;
    }

    @Override
    public final EncodingDefinition getEncodingDefinition() {
        return this.encodingFactory.getDefaultEncodingDefinition();
    }

    @Override
    public final Encoding getEncoding() {
        return this.encoding;
    }

    @Override
    public final DatatypeCoder forEncodingDefinition(EncodingDefinition encodingDefinition) {
        if (this.getEncodingDefinition().equals(encodingDefinition)) {
            return this;
        }
        return this.getOrCreateForEncodingDefinition(encodingDefinition);
    }

    @Override
    public DatatypeCoder unwrap() {
        return this;
    }

    private DatatypeCoder getOrCreateForEncodingDefinition(EncodingDefinition encodingDefinition) {
        DatatypeCoder coder = (DatatypeCoder)this.encodingSpecificDatatypeCoders.get(encodingDefinition);
        if (coder != null) {
            return coder;
        }
        return this.createForEncodingDefinition(encodingDefinition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatatypeCoder createForEncodingDefinition(EncodingDefinition encodingDefinition) {
        EncodingSpecificDatatypeCoder newCoder = new EncodingSpecificDatatypeCoder(this, encodingDefinition);
        DatatypeCoder coder = this.encodingSpecificDatatypeCoders.putIfAbsent(encodingDefinition, newCoder);
        if (coder != null) {
            return coder;
        }
        try {
            EncodingSpecificDatatypeCoder encodingSpecificDatatypeCoder = newCoder;
            return encodingSpecificDatatypeCoder;
        }
        finally {
            if (this.encodingSpecificDatatypeCoders.size() > DATATYPE_CODER_CACHE_SIZE) {
                this.performCacheMaintenance();
            }
        }
    }

    private void performCacheMaintenance() {
        if (this.cacheMaintenanceLock.tryLock()) {
            try {
                this.encodingSpecificDatatypeCoders.clear();
                ++this.cacheMaintenanceCount;
            }
            finally {
                this.cacheMaintenanceLock.unlock();
            }
            if (this.cacheMaintenanceCount % 10 == 1 && logger.isWarnEnabled()) {
                logger.warn("Cleared encoding specific datatype coder cache (current reset count: " + this.cacheMaintenanceCount + "). Consider setting system property " + "org.firebirdsql.datatypeCoderCacheSize" + " to a value higher than the current maximum size of " + DATATYPE_CODER_CACHE_SIZE);
            }
        }
    }

    @Override
    public final boolean equals(Object o) {
        if (!(o instanceof DatatypeCoder)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        DatatypeCoder other = (DatatypeCoder)o;
        if (o instanceof EncodingSpecificDatatypeCoder) {
            return this.getEncodingDefinition().equals(other.getEncodingDefinition()) && this.getClass() == other.unwrap().getClass();
        }
        return this.getEncodingDefinition().equals(other.getEncodingDefinition()) && this.getClass() == other.getClass();
    }

    @Override
    public final int hashCode() {
        return Objects.hash(this.getClass(), this.getEncodingDefinition());
    }

    private datetime fromLongBytes(byte[] byte_long) {
        if (byte_long.length < 8) {
            throw new IllegalArgumentException("Bad parameter to decode, require byte array of at least length 8");
        }
        int encodedDate = this.decodeInt(byte_long);
        int encodedTime = this.decodeInt(byte_long, 4);
        return new datetime(encodedDate, encodedTime);
    }

    private class datetime {
        private final DatatypeCoder.RawDateTimeStruct raw;

        datetime(LocalDateTime localDateTime) {
            this(localDateTime.toLocalDate(), localDateTime.toLocalTime());
        }

        datetime(LocalDate localDate, LocalTime localTime) {
            this.raw = new DatatypeCoder.RawDateTimeStruct();
            if (localDate != null) {
                this.raw.year = localDate.getYear();
                this.raw.month = localDate.getMonthValue();
                this.raw.day = localDate.getDayOfMonth();
            }
            if (localTime != null) {
                this.raw.hour = localTime.getHour();
                this.raw.minute = localTime.getMinute();
                this.raw.second = localTime.getSecond();
                this.raw.setFractionsFromNanos(localTime.getNano());
            }
        }

        datetime(Timestamp value, Calendar cOrig) {
            Calendar c = (Calendar)cOrig.clone();
            c.setTime(value);
            this.raw = new DatatypeCoder.RawDateTimeStruct();
            this.raw.year = c.get(1);
            this.raw.month = c.get(2) + 1;
            this.raw.day = c.get(5);
            this.raw.hour = c.get(11);
            this.raw.minute = c.get(12);
            this.raw.second = c.get(13);
            this.raw.setFractionsFromNanos(value.getNanos());
        }

        datetime(Date value, Calendar cOrig) {
            Calendar c = (Calendar)cOrig.clone();
            c.setTime(value);
            this.raw = new DatatypeCoder.RawDateTimeStruct();
            this.raw.year = c.get(1);
            this.raw.month = c.get(2) + 1;
            this.raw.day = c.get(5);
        }

        datetime(Time value, Calendar cOrig) {
            Calendar c = (Calendar)cOrig.clone();
            c.setTime(value);
            this.raw = new DatatypeCoder.RawDateTimeStruct();
            this.raw.hour = c.get(11);
            this.raw.minute = c.get(12);
            this.raw.second = c.get(13);
            this.raw.fractions = c.get(14) * 10;
        }

        datetime(int encodedDate, int encodedTime) {
            this.raw = new DatatypeCoder.RawDateTimeStruct(encodedDate, true, encodedTime, true);
        }

        datetime(byte[] date, byte[] time) {
            int encodedDate = date != null ? DefaultDatatypeCoder.this.decodeInt(date) : 0;
            int encodedTime = time != null ? DefaultDatatypeCoder.this.decodeInt(time) : 0;
            this.raw = new DatatypeCoder.RawDateTimeStruct(encodedDate, date != null, encodedTime, time != null);
        }

        datetime(DatatypeCoder.RawDateTimeStruct raw) {
            this.raw = new DatatypeCoder.RawDateTimeStruct(raw);
        }

        DatatypeCoder.RawDateTimeStruct getRaw() {
            return new DatatypeCoder.RawDateTimeStruct(this.raw);
        }

        byte[] toTimeBytes() {
            return DefaultDatatypeCoder.this.encodeInt(this.raw.getEncodedTime());
        }

        byte[] toDateBytes() {
            return DefaultDatatypeCoder.this.encodeInt(this.raw.getEncodedDate());
        }

        byte[] toTimestampBytes() {
            byte[] result = new byte[8];
            DefaultDatatypeCoder.this.encodeInt(this.raw.getEncodedDate(), result, 0);
            DefaultDatatypeCoder.this.encodeInt(this.raw.getEncodedTime(), result, 4);
            return result;
        }

        LocalDateTime toLocalDateTime() {
            return LocalDateTime.of(this.toLocalDate(), this.toLocalTime());
        }

        LocalDate toLocalDate() {
            return LocalDate.of(this.raw.year, this.raw.month, this.raw.day);
        }

        LocalTime toLocalTime() {
            return LocalTime.of(this.raw.hour, this.raw.minute, this.raw.second, this.raw.getFractionsAsNanos());
        }

        Time toTime(Calendar cOrig) {
            Calendar c = (Calendar)cOrig.clone();
            c.set(1, 1970);
            c.set(2, 0);
            c.set(5, 1);
            c.set(11, this.raw.hour);
            c.set(12, this.raw.minute);
            c.set(13, this.raw.second);
            c.set(14, this.raw.fractions / 10);
            return new Time(c.getTimeInMillis());
        }

        Timestamp toTimestamp(Calendar cOrig) {
            Calendar c = (Calendar)cOrig.clone();
            c.set(1, this.raw.year);
            c.set(2, this.raw.month - 1);
            c.set(5, this.raw.day);
            c.set(11, this.raw.hour);
            c.set(12, this.raw.minute);
            c.set(13, this.raw.second);
            Timestamp timestamp = new Timestamp(c.getTimeInMillis());
            timestamp.setNanos(this.raw.getFractionsAsNanos());
            return timestamp;
        }

        Date toDate(Calendar cOrig) {
            Calendar c = (Calendar)cOrig.clone();
            c.set(1, this.raw.year);
            c.set(2, this.raw.month - 1);
            c.set(5, this.raw.day);
            c.set(11, 0);
            c.set(12, 0);
            c.set(13, 0);
            c.set(14, 0);
            return new Date(c.getTimeInMillis());
        }
    }
}

