/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.internal.nativeimage;

import com.github.ajalt.mordant.internal.MppImpls;
import com.github.ajalt.mordant.internal.Size;
import com.github.ajalt.mordant.internal.nativeimage.PosixLibC;
import kotlin.Metadata;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.jetbrains.annotations.Nullable;

@Platforms(value={Platform.LINUX.class, Platform.MACOS.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\b\u0010\b\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lcom/github/ajalt/mordant/internal/nativeimage/NativeImagePosixMppImpls;", "Lcom/github/ajalt/mordant/internal/MppImpls;", "()V", "getTerminalSize", "Lcom/github/ajalt/mordant/internal/Size;", "stderrInteractive", "", "stdinInteractive", "stdoutInteractive", "mordant"})
public final class NativeImagePosixMppImpls
implements MppImpls {
    @Override
    public boolean stdoutInteractive() {
        return PosixLibC.INSTANCE.isatty(PosixLibC.INSTANCE.STDOUT_FILENO());
    }

    @Override
    public boolean stdinInteractive() {
        return PosixLibC.INSTANCE.isatty(PosixLibC.INSTANCE.STDIN_FILENO());
    }

    @Override
    public boolean stderrInteractive() {
        return PosixLibC.INSTANCE.isatty(PosixLibC.INSTANCE.STDERR_FILENO());
    }

    @Override
    @Nullable
    public Size getTerminalSize() {
        PosixLibC.winsize size2 = (PosixLibC.winsize)StackValue.get(PosixLibC.winsize.class);
        return PosixLibC.INSTANCE.ioctl(0, PosixLibC.INSTANCE.TIOCGWINSZ(), size2) < 0 ? null : new Size(size2.getWs_col(), size2.getWs_row());
    }

    @Override
    public boolean fastIsTty() {
        return MppImpls.DefaultImpls.fastIsTty(this);
    }
}

