/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket;

import java.util.Locale;
import java.util.ServiceLoader;
import org.apache.tomcat.websocket.Authenticator;
import org.apache.tomcat.websocket.BasicAuthenticator;
import org.apache.tomcat.websocket.DigestAuthenticator;

public class AuthenticatorFactory {
    public static Authenticator getAuthenticator(String string) {
        Authenticator authenticator = null;
        switch (string.toLowerCase(Locale.ENGLISH)) {
            case "basic": {
                authenticator = new BasicAuthenticator();
                break;
            }
            case "digest": {
                authenticator = new DigestAuthenticator();
                break;
            }
            default: {
                authenticator = AuthenticatorFactory.loadAuthenticators(string);
            }
        }
        return authenticator;
    }

    private static Authenticator loadAuthenticators(String string) {
        ServiceLoader<Authenticator> serviceLoader = ServiceLoader.load(Authenticator.class);
        for (Authenticator authenticator : serviceLoader) {
            if (!authenticator.getSchemeName().equalsIgnoreCase(string)) continue;
            return authenticator;
        }
        return null;
    }
}

