h15610
s 00000/00000/01493
d R 6.1 91/12/09 22:40:10 root 6 5
c (1) Fixed bug where 'c'c & 's' in Hebrew mode reversed English strings.  
c (2) Fixed bug where if you typed ^X while editing in a 'c' command, vi.iv might  
c     append the contents of another line to the current line.  
c (3) Preserve & recover now work with vi.iv.
e
s 00567/00555/00926
d D 5.1 90/04/24 14:34:23 haim 5 4
c (1) 'c & 's commands no longer reverse English strings while in Hebrew mode.
c *** CHANGED *** 91/12/09 21:00:07 haim
c (1) Fixed bug where directions of secondary language strings would
c be reversed if cancelled a command sequence (e.g., 'c', 'd', 'y').
c [function operate in ex_voper.c]
c (2) Fixed bug where substitute command would sometimes result in a
c segmentation fault.  [function subschang in ex_re.c]
c (3) Added other checks for null pointers [especially in ex_RL.c]
e
s 00000/00000/01481
d D 4.1 90/02/09 09:59:28 haim 4 3
c (1) created new termcap definitions vt100iv & suniv. Renamed the old
c termcap defintion to vi100iv.
c (2) Added use of TERMIV, EXINITIV, & .exrciv.
c *** CHANGED *** 90/02/09 10:22:19 haim
c (1) created new termcap definitions vt100iv & suniv. Renamed the old
e
s 00000/00000/01481
d D 3.1 90/01/01 14:16:22 haim 3 2
c Fixed the following bugs: [1] echoing previous lines during insert
c mode, [2] cursor stuck in corner when inserting LR text in RL view,
c [3] prints "ERROR" instead of correct messages.
c Also deleted unused entries from termcap.
e
s 00025/00008/01456
d D 2.1 89/12/27 09:21:57 haim 2 1
c First version installed on the Technion Computer Science Faculty 
c (TCSF) CS network.  usuable, but has some bugs, the worst of which 
c is that in insert mode, when you start a new line, previous lines 
c are echoed on that new line.  Installed by Haim Roman 11/1989.
c *** CHANGED *** 89/12/27 12:09:16 haim
c 
e
s 01464/00000/00000
d D 1.1 89/12/26 15:06:15 haim 1 0
c Inherited by Haim Roman from Yael Dubinsky approximately 10/1989.  Yael 
c started the installation on the Technion Computer Science computers, 
c but had to leave before completing the installation.
c *** CHANGED *** 89/12/26 15:18:59 haim
c date and time created 89/12/26 15:06:15 by haim
e
u
U
f e 0
t
T
I 1
D 2
/*
E 2
I 2
D 5
/*=============================================================
 * FILE: ex_vmain
 * ------------------------------------------------------------
E 5
I 5
/*
 * ============================================================= 
 * FILE:  ex_vmain 
 * ------------------------------------------------------------ 
E 5
 * EDIT HISTORY:
 * 
D 5
 * 11/1989		HAIM ROMAN, COMPUTER SCIENCE DEPT., TECHNION
 * (1) added comments
E 5
I 5
 * 11/1989		HAIM ROMAN, COMPUTER SCIENCE DEPT., TECHNION 
 * (1) added comments 
E 5
 * ------------------------------------------------------------
 * DESCRIPTION:
D 5
 *
 * This is the main routine for visual.
 * We here decode the count and possible named buffer specification
 * preceding a command and interpret a few of the commands.
 * Commands which involve a target (i.e. an operator) are decoded
E 5
I 5
 * 
 * This is the main routine for visual. We here decode the count and possible
 * named buffer specification preceding a command and interpret a few of the
 * commands. Commands which involve a target (i.e. an operator) are decoded
E 5
 * in the routine operate in ex_voperate.c.
D 5
 * ------------------------------------------------------------
E 2
 * Copyright (c) 1980 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
I 2
 *=========================================================
E 5
I 5
 * ------------------------------------------------------------ 
 * Copyright (c) 1980 Regents of the University of California. All
 * rights reserved.  The Berkeley software License Agreement specifies
 * the terms and conditions for redistribution.
 * =========================================================
E 5
 * DATA DECLARATIONS
D 5
 *=========================================================
E 5
I 5
 * =========================================================
E 5
E 2
 */

#ifndef lint
D 5
static char *sccsid = "@(#)ex_vmain.c	7.7 (Berkeley) 6/7/85";
E 5
I 5
static char    *sccsid = "@(#)ex_vmain.c	7.7 (Berkeley) 6/7/85";
E 5
#endif not lint

#include "ex.h"
#include "ex_tty.h"
#include "ex_vis.h"
#include "ex_RL.h"

D 2
/*
 * This is the main routine for visual.
 * We here decode the count and possible named buffer specification
 * preceding a command and interpret a few of the commands.
 * Commands which involve a target (i.e. an operator) are decoded
 * in the routine operate in ex_voperate.c.
 */
E 2

I 2
D 5
		/* this is redefined just before function "vzop" */
E 5
I 5
/* this is redefined just before function "vzop" */
E 5
E 2
#define	forbid(a)	{ if (a) goto fonfon; }
D 5
extern char *shcurs;
E 5
I 5
extern char    *shcurs;
E 5

I 2
D 5
/*==================================================================
 * FUNCTIONS
 *==================================================================
E 5
I 5
/*
 * ==================================================================
 * VMAIN -- MAIN VISUAL MODE ROUTINE
 * ==================================================================
E 5
 */
E 2
vmain()
{
D 5
	register int c, cnt, i;
	char esave[TUBECOLS], ch[2];
	char *oglobp;
	short d;
	line *addr;
	int ind, nlput;
	int shouldpo = 0;
E 5
I 5
	/*------------------------------------------
	 * DATA
	 *---------------------------------------
	 */
	register int    c, cnt, i;
	char            esave[TUBECOLS], ch[2];
	char           *oglobp;
	short           d;
	line           *addr;
	int             ind, nlput;
	int             shouldpo = 0;
E 5
	/* odirect added by Uri Habusha for vi.iv */
D 5
	int onumber, olist, odirect , (*OPline)(), (*OPutchar)();
	bool isp = 0;
	int chanf = 0;
E 5
I 5
	int             onumber, olist, odirect, (*OPline) (), (*OPutchar) ();
	bool            isp = 0;
	int             chanf = 0;
E 5

I 5
	/*-------------------------------------------------
	 * ACTION
	 *-------------------------------------------------
	 */
E 5
	vch_mac = VC_NOTINMAC;

	/*
D 5
	 * If we started as a vi command (on the command line)
	 * then go process initial commands (recover, next or tag).
E 5
I 5
	 * If we started as a vi command (on the command line) then go
	 * process initial commands (recover, next or tag).
E 5
	 */

	if (initev) {
		oglobp = globp;
		globp = initev;
		hadcnt = cnt = 0;
		i = tchng;
		addr = dot;
D 5
		INdirect = value(RIGHTLEFT); 
E 5
I 5
		INdirect = value(RIGHTLEFT);
E 5
		goto doinit;
D 5
	} else
	if (INdirect){
	    if (HE && !HF){
		prmsg(1, "PLEASE MANUALLY FLIP TERMINAL TO HEBREW MODE.");
		chLR = 1;
	    }
	    else if (!HE && !HF){
E 5
I 5
	} else if (INdirect) {
		if (HE && !HF) {
			prmsg(1, "PLEASE MANUALLY FLIP TERMINAL TO HEBREW MODE.");
			chLR = 1;
		} else if (!HE && !HF) {
E 5
			prmsg(1, "USING SLOW MODE. PLEASE MANUALLY FLIP TERMINAL TO HEBREW MODE.");
			chLR = 1;
D 5
	        }
		else if (!HE)
E 5
I 5
		} else if (!HE)
E 5
			prmsg(1, "USING SLOW MODE.");
D 5
	}else
			if (!INdirect && !HN)
				prmsg(1, "PLEASE MANUALLY FLIP TERMINAL TO LATIN MODE.");
E 5
I 5
	} else if (!INdirect && !HN)
		prmsg(1, "PLEASE MANUALLY FLIP TERMINAL TO LATIN MODE.");
E 5

	/*
D 5
	 * NB:
E 5
I 5
	 * Since the routine is very long, I'll summarize the
	 * structure from here to the end.
E 5
	 *
D 5
	 * The current line is always in the line buffer linebuf,
	 * and the cursor at the position cursor.  You should do
	 * a vsave() before moving off the line to make sure the disk
	 * copy is updated if it has changed, and a getDOT() to get
	 * the line back if you mung linebuf.  The motion
	 * routines in ex_vwind.c handle most of this.
E 5
I 5
	 *	from here to the end is enclosed in a giant 'for'
	 *	loop.  I'm not sure what causes this loop to end,
	 *	though I suspect it will be commands to quit visual
	 *	mode or the editor, or maybe error conditions.
	 *
	 *	for (????)
	 *		introductory stuff.
	 *		switch statement, depending on the command.
	 *		operate function -- this function does
	 *			much/most of the work.  In many cases,
	 *			the preceding switch statement just
	 *			prepares for the call to 'operate'.
	 *
	 *	(Haim Roman, 34/04/90)
	 * NB:
	 * 
	 * The current line is always in the line buffer linebuf, and the cursor
	 * at the position cursor.  You should do a vsave() before moving off
	 * the line to make sure the disk copy is updated if it has changed,
	 * and a getDOT() to get the line back if you mung linebuf.  The
	 * motion routines in ex_vwind.c handle most of this.
E 5
	 */
	for (;;) {
		/*
D 5
		 * Decode a visual command.
		 * First sync the temp file if there has been a reasonable
		 * amount of change.  Clear state for decoding of next
		 * command.
E 5
I 5
		 * Decode a visual command. First sync the temp file if there
		 * has been a reasonable amount of change.  Clear state for
		 * decoding of next command.
E 5
		 */
		TSYNC();
		vglobp = 0;
		vreg = 0;
		hold = 0;
		seenprompt = 1;
		wcursor = 0;
		Xhadcnt = hadcnt = 0;
		Xcnt = cnt = 1;
		splitw = 0;
		if (i = holdupd) {
			if (state == VISUAL)
				ignore(peekkey());
			holdupd = 0;
D 5
/*
			if (LINE(0) < ZERO) {
				vclear();
				vcnt = 0;
				i = 3;
			}
*/
E 5
I 5
			/*
			 * if (LINE(0) < ZERO) { vclear(); vcnt = 0; i = 3; }
			 */
E 5
			if (state != VISUAL) {
				vcnt = 0;
				vsave();
				vrepaint(cursor);
			} else if (i == 3)
				vredraw(WTOP);
			else
				vsync(WTOP);
			vfixcurs();
		}
D 5

E 5
		/*
		 * Gobble up counts and named buffer specifications.
		 */
		for (;;) {
D 5
looptop:
E 5
I 5
	looptop:
E 5
#ifdef MDEBUG
			if (trace)
D 5
				fprintf(trace, "pc=%c",peekkey());
E 5
I 5
				fprintf(trace, "pc=%c", peekkey());
E 5
#endif
			if (DIdirect == RL)
				setLR();
			if (isdigit(peekkey()) && peekkey() != '0') {
				hadcnt = 1;
				cnt = vgetcnt();
D 5
				forbid (cnt <= 0);
E 5
I 5
				forbid(cnt <= 0);
E 5
			}
			if (peekkey() != '"')
				break;
			ignore(getkey()), c = getkey();
			/*
D 5
			 * Buffer names be letters or digits.
			 * But not '0' as that is the source of
			 * an 'empty' named buffer spec in the routine
			 * kshift (see ex_temp.c).
E 5
I 5
			 * Buffer names be letters or digits. But not '0' as
			 * that is the source of an 'empty' named buffer spec
			 * in the routine kshift (see ex_temp.c).
E 5
			 */
D 5
			forbid (c == '0' || !isalpha(c) && !isdigit(c));
E 5
I 5
			forbid(c == '0' || !isalpha(c) && !isdigit(c));
E 5
			vreg = c;
		}
reread:
		/*
D 5
		 * Come to reread from below after some macro expansions.
		 * The call to map allows use of function key pads
		 * by performing a terminal dependent mapping of inputs.
E 5
I 5
		 * Come to reread from below after some macro expansions. The
		 * call to map allows use of function key pads by performing
		 * a terminal dependent mapping of inputs.
E 5
		 */
#ifdef MDEBUG
		if (trace)
D 5
			fprintf(trace,"pcb=%c,",peekkey());
E 5
I 5
			fprintf(trace, "pcb=%c,", peekkey());
E 5
#endif
		op = getkey();
		maphopcnt = 0;
		do {
			/*
D 5
			 * Keep mapping the char as long as it changes.
			 * This allows for double mappings, e.g., q to #,
			 * #1 to something else.
E 5
I 5
			 * Keep mapping the char as long as it changes. This
			 * allows for double mappings, e.g., q to #, #1 to
			 * something else.
E 5
			 */
			c = op;
D 5
			op = map(c,arrows);
E 5
I 5
			op = map(c, arrows);
E 5
#ifdef MDEBUG
			if (trace)
D 5
				fprintf(trace,"pca=%c,",c);
E 5
I 5
				fprintf(trace, "pca=%c,", c);
E 5
#endif
			/*
D 5
			 * Maybe the mapped to char is a count. If so, we have
			 * to go back to the "for" to interpret it. Likewise
			 * for a buffer name.
E 5
I 5
			 * Maybe the mapped to char is a count. If so, we
			 * have to go back to the "for" to interpret it.
			 * Likewise for a buffer name.
E 5
			 */
D 5
			if ((isdigit(c) && c!='0') || c == '"') {
E 5
I 5
			if ((isdigit(c) && c != '0') || c == '"') {
E 5
				ungetkey(c);
				goto looptop;
			}
			if (!value(REMAP)) {
				c = op;
				break;
			}
			if (++maphopcnt > 256)
				error("Infinite macro loop");
		} while (c != op);

		/*
D 5
		 * Begin to build an image of this command for possible
		 * later repeat in the buffer workcmd.  It will be copied
		 * to lastcmd by the routine setLAST
		 * if/when completely specified.
E 5
I 5
		 * Begin to build an image of this command for possible later
		 * repeat in the buffer workcmd.  It will be copied to
		 * lastcmd by the routine setLAST if/when completely
		 * specified.
E 5
		 */
		lastcp = workcmd;
		if (!vglobp)
			*lastcp++ = c;

		/*
		 * First level command decode.
		 */

		/* (c) . ADD  for vi.iv by Uri habusha */
		/*
D 5
		 * CTRL (x) change the direction of the text , from
		 * right to left in LR document and so on for RL
		 * document.
E 5
I 5
		 * CTRL (x) change the direction of the text , from right to
		 * left in LR document and so on for RL document.
E 5
		 */
		ch[0] = c;
D 5
		if (c == *svalue(CHLK)){
			INdirect = ! INdirect;
E 5
I 5
		if (c == *svalue(CHLK)) {
			INdirect = !INdirect;
E 5
			chadir();
D 5
			if(INdirect)
E 5
I 5
			if (INdirect)
E 5
				if (!HF)
					prmsg(1, "RL INSERT MODE. PLEASE MANUALLY FLIP TERMINAL TO HEBREW MODE.");
				else
D 5
					prmsg(1, "RL INSERT MODE."); 
E 5
I 5
					prmsg(1, "RL INSERT MODE.");
			else if (!HN)
				prmsg(1, "LR INSERT MODE. PLEASE MANUALLY FLIP TERMINAL TO LATIN MODE.");
E 5
			else
D 5
				if (!HN)
					prmsg(1, "LR INSERT MODE. PLEASE MANUALLY FLIP TERMINAL TO LATIN MODE.");
				else
					prmsg(1, "LR INSERT MODE."); 
					
E 5
I 5
				prmsg(1, "LR INSERT MODE.");

E 5
			continue;
		}
		switch (c) {

D 5
		/*
		 * ^L		Clear screen e.g. after transmission error.
		 */
E 5
I 5
			/*
			 * ^L		Clear screen e.g. after transmission
			 * error.
			 */
E 5

D 5
		/*
		 * ^R		Retype screen, getting rid of @ lines.
		 *		If in open, equivalent to ^L.
		 *		On terminals where the right arrow key sends
		 *		^L we make ^R act like ^L, since there is no
		 *		way to get ^L.  These terminals (adm31, tvi)
		 *		are intelligent so ^R is useless.  Soroc
		 *		will probably foul this up, but nobody has
		 *		one of them.
		 */
E 5
I 5
			/*
			 * ^R		Retype screen, getting rid of @
			 * lines. If in open, equivalent to ^L. On terminals
			 * where the right arrow key sends ^L we make ^R act
			 * like ^L, since there is no way to get ^L.  These
			 * terminals (adm31, tvi) are intelligent so ^R is
			 * useless.  Soroc will probably foul this up, but
			 * nobody has one of them.
			 */
E 5
		case CTRL(l):
		case CTRL(r):
D 5
			if (c == CTRL(l) || (KR && *KR==CTRL(l))) {
E 5
I 5
			if (c == CTRL(l) || (KR && *KR == CTRL(l))) {
E 5
				vclear();
				vdirty(0, vcnt);
			}
			if (state != VISUAL) {
				/*
D 5
				 * Get a clean line, throw away the
				 * memory of what is displayed now,
				 * and move back onto the current line.
E 5
I 5
				 * Get a clean line, throw away the memory of
				 * what is displayed now, and move back onto
				 * the current line.
E 5
				 */
				vclean();
				vcnt = 0;
				vmoveto(dot, cursor, 0);
				continue;
			}
			vredraw(WTOP);
			/*
D 5
			 * Weird glitch -- when we enter visual
			 * in a very small window we may end up with
			 * no lines on the screen because the line
			 * at the top is too long.  This forces the screen
			 * to be expanded to make room for it (after
			 * we have printed @'s ick showing we goofed).
E 5
I 5
			 * Weird glitch -- when we enter visual in a very
			 * small window we may end up with no lines on the
			 * screen because the line at the top is too long.
			 * This forces the screen to be expanded to make room
			 * for it (after we have printed @'s ick showing we
			 * goofed).
E 5
			 */
			if (vcnt == 0)
				vrepaint(cursor);
			vfixcurs();
			continue;

D 5
		/*
		 * $		Escape just cancels the current command
		 *		with a little feedback.
		 */
E 5
I 5
			/*
			 * $		Escape just cancels the current
			 * command with a little feedback.
			 */
E 5
		case ESCAPE:
			beep();
			continue;

D 5
		/*
		 * @   		Macros. Bring in the macro and put it
		 *		in vmacbuf, point vglobp there and punt.
		 */
		 case '@':
E 5
I 5
			/*
			 * @   		Macros. Bring in the macro and put it
			 * in vmacbuf, point vglobp there and punt.
			 */
		case '@':
E 5
			c = getesc();
			if (c == 0)
				continue;
			if (c == '@')
				c = lastmac;
			if (isupper(c))
				c = tolower(c);
			forbid(!islower(c));
			lastmac = c;
			vsave();
			CATCH
D 5
				char tmpbuf[BUFSIZ];
E 5
I 5
				char            tmpbuf[BUFSIZ];
E 5

D 5
				regbuf(c,tmpbuf,sizeof(vmacbuf));
				macpush(tmpbuf, 1);
E 5
I 5
			regbuf(c, tmpbuf, sizeof(vmacbuf));
			macpush(tmpbuf, 1);
E 5
			ONERR
				lastmac = 0;
D 5
				splitw = 0;
				getDOT();
				vrepaint(cursor);
				continue;
E 5
I 5
			splitw = 0;
			getDOT();
			vrepaint(cursor);
			continue;
E 5
			ENDCATCH
D 5
			vmacp = vmacbuf;
E 5
I 5
				vmacp = vmacbuf;
E 5
			goto reread;

D 5
		/*
		 * .		Repeat the last (modifying) open/visual command.
		 */
E 5
I 5
			/*
			 * .		Repeat the last (modifying)
			 * open/visual command.
			 */
E 5
		case '.':
			/*
D 5
			 * Check that there was a last command, and
			 * take its count and named buffer unless they
			 * were given anew.  Special case if last command
			 * referenced a numeric named buffer -- increment
			 * the number and go to a named buffer again.
			 * This allows a sequence like "1pu.u.u...
			 * to successively look for stuff in the kill chain
			 * much as one does in EMACS with C-Y and M-Y.
E 5
I 5
			 * Check that there was a last command, and take its
			 * count and named buffer unless they were given
			 * anew.  Special case if last command referenced a
			 * numeric named buffer -- increment the number and
			 * go to a named buffer again. This allows a sequence
			 * like "1pu.u.u... to successively look for stuff in
			 * the kill chain much as one does in EMACS with C-Y
			 * and M-Y.
E 5
			 */
D 5
			forbid (lastcmd[0] == 0);
E 5
I 5
			forbid(lastcmd[0] == 0);
E 5
			if (hadcnt)
				lastcnt = cnt;
			if (vreg)
				lastreg = vreg;
			else if (isdigit(lastreg) && lastreg < '9')
				lastreg++;
			vreg = lastreg;
			cnt = lastcnt;
			hadcnt = lasthad;
			vglobp = lastcmd;
			goto reread;

D 5
		/*
		 * ^U		Scroll up.  A count sticks around for
		 *		future scrolls as the scroll amount.
		 *		Attempt to hold the indentation from the
		 *		top of the screen (in logical lines).
		 *
		 * BUG:		A ^U near the bottom of the screen
		 *		on a dumb terminal (which can't roll back)
		 *		causes the screen to be cleared and then
		 *		redrawn almost as it was.  In this case
		 *		one should simply move the cursor.
		 */
E 5
I 5
			/*
			 * ^U		Scroll up.  A count sticks around for
			 * future scrolls as the scroll amount. Attempt to
			 * hold the indentation from the top of the screen
			 * (in logical lines).
			 * 
			 * BUG:		A ^U near the bottom of the screen on
			 * a dumb terminal (which can't roll back) causes the
			 * screen to be cleared and then redrawn almost as it
			 * was.  In this case one should simply move the
			 * cursor.
			 */
E 5
		case CTRL(u):
			if (hadcnt)
				vSCROLL = cnt;
			cnt = vSCROLL;
			if (state == VISUAL)
				ind = vcline, cnt += ind;
			else
				ind = 0;
			vmoving = 0;
			vup(cnt, ind, 1);
			vnline(NOSTR);
			continue;

D 5
		/*
		 * ^D		Scroll down.  Like scroll up.
		 */
E 5
I 5
			/*
			 * ^D		Scroll down.  Like scroll up.
			 */
E 5
		case CTRL(d):
#ifdef TRACE
D 5
		if (trace)
			fprintf(trace, "before vdown in ^D, dot=%d, wdot=%d, dol=%d\n", lineno(dot), lineno(wdot), lineno(dol));
E 5
I 5
			if (trace)
				fprintf(trace, "before vdown in ^D, dot=%d, wdot=%d, dol=%d\n", lineno(dot), lineno(wdot), lineno(dol));
E 5
#endif
			if (hadcnt)
				vSCROLL = cnt;
			cnt = vSCROLL;
			if (state == VISUAL)
				ind = vcnt - vcline - 1, cnt += ind;
			else
				ind = 0;
			vmoving = 0;
			vdown(cnt, ind, 1);
#ifdef TRACE
D 5
		if (trace)
			fprintf(trace, "before vnline in ^D, dot=%d, wdot=%d, dol=%d\n", lineno(dot), lineno(wdot), lineno(dol));
E 5
I 5
			if (trace)
				fprintf(trace, "before vnline in ^D, dot=%d, wdot=%d, dol=%d\n", lineno(dot), lineno(wdot), lineno(dol));
E 5
#endif
			vnline(NOSTR);
#ifdef TRACE
D 5
		if (trace)
			fprintf(trace, "after vnline in ^D, dot=%d, wdot=%d, dol=%d\n", lineno(dot), lineno(wdot), lineno(dol));
E 5
I 5
			if (trace)
				fprintf(trace, "after vnline in ^D, dot=%d, wdot=%d, dol=%d\n", lineno(dot), lineno(wdot), lineno(dol));
E 5
#endif
			continue;

D 5
		/*
		 * ^E		Glitch the screen down (one) line.
		 *		Cursor left on same line in file.
		 */
E 5
I 5
			/*
			 * ^E		Glitch the screen down (one) line.
			 * Cursor left on same line in file.
			 */
E 5
		case CTRL(e):
			if (state != VISUAL)
				continue;
			if (!hadcnt)
				cnt = 1;
			/* Bottom line of file already on screen */
D 5
			forbid(lineDOL()-lineDOT() <= vcnt-1-vcline);
E 5
I 5
			forbid(lineDOL() - lineDOT() <= vcnt - 1 - vcline);
E 5
			ind = vcnt - vcline - 1 + cnt;
			vdown(ind, ind, 1);
			vnline(cursor);
			continue;

D 5
		/*
		 * ^Y		Like ^E but up
		 */
E 5
I 5
			/*
			 * ^Y		Like ^E but up
			 */
E 5
		case CTRL(y):
			if (state != VISUAL)
				continue;
			if (!hadcnt)
				cnt = 1;
D 5
			forbid(lineDOT()-1<=vcline); /* line 1 already there */
E 5
I 5
			forbid(lineDOT() - 1 <= vcline);	/* line 1 already there */
E 5
			ind = vcline + cnt;
			vup(ind, ind, 1);
			vnline(cursor);
			continue;


D 5
		/*
		 * m		Mark position in mark register given
		 *		by following letter.  Return is
		 *		accomplished via ' or `; former
		 *		to beginning of line where mark
		 *		was set, latter to column where marked.
		 */
E 5
I 5
			/*
			 * m		Mark position in mark register given
			 * by following letter.  Return is accomplished via '
			 * or `; former to beginning of line where mark was
			 * set, latter to column where marked.
			 */
E 5
		case 'm':
			/*
D 5
			 * Getesc is generally used when a character
			 * is read as a latter part of a command
			 * to allow one to hit rubout/escape to cancel
			 * what you have typed so far.  These characters
			 * are mapped to 0 by the subroutine.
E 5
I 5
			 * Getesc is generally used when a character is read
			 * as a latter part of a command to allow one to hit
			 * rubout/escape to cancel what you have typed so
			 * far.  These characters are mapped to 0 by the
			 * subroutine.
E 5
			 */
			c = getesc();
			if (c == 0)
				continue;

			/*
D 5
			 * Markreg checks that argument is a letter
			 * and also maps ' and ` to the end of the range
			 * to allow '' or `` to reference the previous
			 * context mark.
E 5
I 5
			 * Markreg checks that argument is a letter and also
			 * maps ' and ` to the end of the range to allow ''
			 * or `` to reference the previous context mark.
E 5
			 */
			c = markreg(c);
D 5
			forbid (c == 0);
E 5
I 5
			forbid(c == 0);
E 5
			vsave();
D 5
			names[c - 'a'] = (*dot &~ 01);
E 5
I 5
			names[c - 'a'] = (*dot & ~01);
E 5
			ncols[c - 'a'] = cursor;
			anymarks = 1;
			continue;

D 5
		/*
		 * ^F		Window forwards, with 2 lines of continuity.
		 *		Count repeats.
		 */
E 5
I 5
			/*
			 * ^F		Window forwards, with 2 lines of
			 * continuity. Count repeats.
			 */
E 5
		case CTRL(f):
			vsave();
			if (vcnt > 2) {
D 5
				addr = dot + (vcnt - vcline) - 2 + (cnt-1)*basWLINES;
E 5
I 5
				addr = dot + (vcnt - vcline) - 2 + (cnt - 1) * basWLINES;
E 5
				forbid(addr > dol);
				dot = addr;
				vcnt = vcline = 0;
			}
			vzop(0, 0, '+');
			continue;

D 5
		/*
		 * ^B		Window backwards, with 2 lines of continuity.
		 *		Inverse of ^F.
		 */
E 5
I 5
			/*
			 * ^B		Window backwards, with 2 lines of
			 * continuity. Inverse of ^F.
			 */
E 5
		case CTRL(b):
			vsave();
			if (one + vcline != dot && vcnt > 2) {
D 5
				addr = dot - vcline + 2 - (cnt-1)*basWLINES;
				forbid (addr <= zero);
E 5
I 5
				addr = dot - vcline + 2 - (cnt - 1) * basWLINES;
				forbid(addr <= zero);
E 5
				dot = addr;
				vcnt = vcline = 0;
			}
			vzop(0, 0, '^');
			continue;

D 5
		/*
		 * z		Screen adjustment, taking a following character:
		 *			z<CR>		current line to top
		 *			z<NL>		like z<CR>
		 *			z-		current line to bottom
		 *		also z+, z^ like ^F and ^B.
		 *		A preceding count is line to use rather
		 *		than current line.  A count between z and
		 *		specifier character changes the screen size
		 *		for the redraw.
		 *
		 */
E 5
I 5
			/*
			 * z		Screen adjustment, taking a following
			 * character: z<CR>		current line to top
			 * z<NL>		like z<CR> z- t line to
			 * bottom also z+, z^ like ^F and ^B. A preceding
			 * count is line to use rather than current line.  A
			 * count between z and specifier character changes
			 * the screen size for the redraw.
			 * 
			 */
E 5
		case 'z':
			if (state == VISUAL) {
				i = vgetcnt();
				if (i > 0)
					vsetsiz(i);
				c = getesc();
				if (c == 0)
					continue;
			}
			vsave();
			vzop(hadcnt, cnt, c);
			continue;

D 5
		/*
		 * Y		Yank lines, abbreviation for y_ or yy.
		 *		Yanked lines can be put later if no
		 *		changes intervene, or can be put in named
		 *		buffers and put anytime in this session.
		 */
E 5
I 5
			/*
			 * Y		Yank lines, abbreviation for y_ or
			 * yy. Yanked lines can be put later if no changes
			 * intervene, or can be put in named buffers and put
			 * anytime in this session.
			 */
E 5
		case 'Y':
			ungetkey('_');
			c = 'y';
			break;

D 5
		/*
		 * J		Join lines, 2 by default.  Count is number
		 *		of lines to join (no join operator sorry.)
		 */
E 5
I 5
			/*
			 * J		Join lines, 2 by default.  Count is
			 * number of lines to join (no join operator sorry.)
			 */
E 5
		case 'J':
D 5
			forbid (dot == dol);
E 5
I 5
			forbid(dot == dol);
E 5
			if (cnt == 1)
				cnt = 2;
			if (cnt > (i = dol - dot + 1))
				cnt = i;
			vsave();
			vmacchng(1);
			setLAST();
			cursor = strend(linebuf);
			vremote(cnt, join, 0);
			notenam = "join";
			vmoving = 0;
			killU();
			vreplace(vcline, cnt, 1);
			if (!*cursor && cursor > linebuf)
				cursor--;
			if (notecnt == 2)
				notecnt = 0;
			vrepaint(cursor);
			continue;

D 5
		/*
		 * S		Substitute text for whole lines, abbrev for c_.
		 *		Count is number of lines to change.
		 */
E 5
I 5
			/*
			 * S		Substitute text for whole lines,
			 * abbrev for c_. Count is number of lines to change.
			 */
E 5
		case 'S':
			ungetkey('_');
			c = 'c';
			break;

D 5
		/*
		 * O		Create a new line above current and accept new
		 *		input text, to an escape, there.
		 *		A count specifies, for dumb terminals when
		 *		slowopen is not set, the number of physical
		 *		line space to open on the screen.
		 *
		 * o		Like O, but opens lines below.
		 */
E 5
I 5
			/*
			 * O		Create a new line above current and
			 * accept new input text, to an escape, there. A
			 * count specifies, for dumb terminals when slowopen
			 * is not set, the number of physical line space to
			 * open on the screen.
			 * 
			 * o		Like O, but opens lines below.
			 */
E 5
		case 'O':
		case 'o':
			vmacchng(1);
			voOpen(c, cnt);
			continue;

D 5
		/*
		 * C		Change text to end of line, short for c$.
		 */
E 5
I 5
			/*
			 * C		Change text to end of line, short for
			 * c$.
			 */
E 5
		case 'C':
			if (*cursor) {
				if (INdirect == Mdirect)
					ungetkey('$'), c = 'c';
				else
					ungetkey('^'), c = 'c';
				break;
			}
			goto appnd;

D 5
		/*
		 * ~	Switch case of letter under cursor
		 */
E 5
I 5
			/*
			 * ~	Switch case of letter under cursor
			 */
E 5
		case '~':
			{
D 5
				char mbuf[240], *hp;
				bool flag1,flag2;
				int i= 0;
				int d;
E 5
I 5
				char            mbuf[240], *hp;
				bool            flag1, flag2;
				int             i = 0;
				int             d;
E 5
				setLAST();
				hp = cursor;
				if (cnt > 80)
					cnt = 80;
D 5
				while (cnt--){
E 5
I 5
				while (cnt--) {
E 5
					mbuf[i++] = 'r';
					d = *hp;
					if ((!RL_letter(d)) && (isalpha(*hp)))
D 5
					/* toggle the case */
E 5
I 5
						/* toggle the case */
E 5
						mbuf[i++] = *hp++ ^ ' ';
					else {
						/*
D 5
						 *  toggle Uper Case
						 * that write in RL
						 * mode to lower case
					     	 */
E 5
I 5
						 * toggle Uper Case that
						 * write in RL mode to lower
						 * case
						 */
E 5
						d = *hp;
						if ((RL_letter(d)) && isupper(*hp & TRIM))
							mbuf[i++] = (*hp++ & TRIM) ^ ' ';
						else
							mbuf[i++] = *hp++;
					}
D 5
					if (isRLtext) 
						mbuf[i++] = hp==linebuf ? 0 : ' ';
E 5
I 5
					if (isRLtext)
						mbuf[i++] = hp == linebuf ? 0 : ' ';
E 5
					else
D 5
						mbuf[i++] = hp[0]==0 ? 0 : ' ';
E 5
I 5
						mbuf[i++] = hp[0] == 0 ? 0 : ' ';
E 5
				}
				mbuf[i] = 0;
				macpush(mbuf, 1);
			}
			continue;
D 5
				
		/*
		 * A		Append at end of line, short for $a.
		 */
E 5
I 5

			/*
			 * A		Append at end of line, short for $a.
			 */
E 5
		case 'A':
			setshcurs();
			operate('$', 1);
D 5
appnd:
E 5
I 5
	appnd:
E 5
			/* fall into ... */

D 5
		/*
		 * a		Appends text after cursor.  Text can continue
		 *		through arbitrary number of lines.
		 */
E 5
I 5
			/*
			 * a		Appends text after cursor.  Text can
			 * continue through arbitrary number of lines.
			 */
E 5
		case 'a':
D 5
Rappnd:
E 5
I 5
	Rappnd:
E 5
			if (c == 'A')
				c == 'a';
			else
D 5
 				setshcurs();
E 5
I 5
				setshcurs();
E 5
			if (*cursor && c != 'R') {
				if (state == HARDOPEN)
					putchar(*cursor);
				shcurs++;
				cursor++;
D 5
			} 
E 5
I 5
			}
E 5
			goto insrt;

D 5
		/*
		 * I		Insert at beginning of whitespace of line,
		 *		short for ^i.
		 */
E 5
I 5
			/*
			 * I		Insert at beginning of whitespace of
			 * line, short for ^i.
			 */
E 5
		case 'I':
			setshcurs();
			operate('^', 1);
			/* fall into ... */

D 5
		/*
		 * R		Replace characters, one for one, by input
		 *		(logically), like repeated r commands.
		 *
		 * BUG:		This is like the typeover mode of many other
		 *		editors, and is only rarely useful.  Its
		 *		implementation is a hack in a low level
		 *		routine and it doesn't work very well, e.g.
		 *		you can't move around within a R, etc.
		 */
E 5
I 5
			/*
			 * R		Replace characters, one for one, by
			 * input (logically), like repeated r commands.
			 * 
			 * BUG:		This is like the typeover mode of
			 * many other editors, and is only rarely useful. Its
			 * implementation is a hack in a low level routine
			 * and it doesn't work very well, e.g. you can't move
			 * around within a R, etc.
			 */
E 5
		case 'R':
			if (isecondlang)
				goto Rappnd;
			/* fall into... */

D 5
		/*
		 * i		Insert text to an escape in the buffer.
		 *		Text is arbitrary.  This command reminds of
		 *		the i command in bare teco.
		 */
E 5
I 5
			/*
			 * i		Insert text to an escape in the
			 * buffer. Text is arbitrary.  This command reminds
			 * of the i command in bare teco.
			 */
E 5
		case 'i':
			if (c == 'I')
D 5
				c =='i';
E 5
I 5
				c == 'i';
E 5
			else
				setshcurs();
D 5
insrt:
E 5
I 5
	insrt:
E 5
			/*
D 5
			 * Common code for all the insertion commands.
			 * Save for redo, position cursor, prepare for append
			 * at command and in visual undo.  Note that nothing
			 * is doomed, unless R when all is, and save the
			 * current line in a the undo temporary buffer.
E 5
I 5
			 * Common code for all the insertion commands. Save
			 * for redo, position cursor, prepare for append at
			 * command and in visual undo.  Note that nothing is
			 * doomed, unless R when all is, and save the current
			 * line in a the undo temporary buffer.
E 5
			 */
			CP(vutmp, linebuf);
D 5
			if (ishef){
E 5
I 5
			if (ishef) {
E 5
				changseclan(vutmp, Mdirect);
				selbuf(1);
			}
			vmacchng(1);
			setLAST();
			vcursat(cursor);
			prepapp();
			vnoapp();
			doomed = c == 'R' ? 10000 : 0;
D 5
			if(FIXUNDO)
E 5
I 5
			if (FIXUNDO)
E 5
				vundkind = VCHNG;
			if (isRLtext)
				colRL = strcolrl();
			vmoving = 0;

			/*
D 5
			 * If this is a repeated command, then suppress
			 * fake insert mode on dumb terminals which looks
E 5
I 5
			 * If this is a repeated command, then suppress fake
			 * insert mode on dumb terminals which looks
E 5
			 * ridiculous and wastes lots of time even at 9600B.
			 */
			if (vglobp)
				hold = HOLDQIK;
D 5
			/*if (isp && (c == 'a' || c == 'i'))
				c = 'p';*/
E 5
I 5
			/*
			 * if (isp && (c == 'a' || c == 'i')) c = 'p';
			 */
E 5
			vappend(c, cnt, 0, isp);
			isp = 0;
			continue;

D 5
		/*
		 * ^?		An attention, normally a ^?, just beeps.
		 *		If you are a vi command within ex, then
		 *		two ATTN's will drop you back to command mode.
		 */
E 5
I 5
			/*
			 * ^?		An attention, normally a ^?, just
			 * beeps. If you are a vi command within ex, then two
			 * ATTN's will drop you back to command mode.
			 */
E 5
		case ATTN:
			beep();
			if (initev || peekkey() != ATTN)
				continue;
			/* fall into... */

D 5
		/*
		 * ^\		A quit always gets command mode.
		 */
E 5
I 5
			/*
			 * ^\		A quit always gets command mode.
			 */
E 5
		case QUIT:
			/*
D 5
			 * Have to be careful if we were called
			 *	g/xxx/vi
			 * since a return will just start up again.
			 * So we simulate an interrupt.
E 5
I 5
			 * Have to be careful if we were called g/xxx/vi
			 * since a return will just start up again. So we
			 * simulate an interrupt.
E 5
			 */
			if (inglobal)
				onintr();
			/* fall into... */

#ifdef notdef
D 5
		/*
		 * q		Quit back to command mode, unless called as
		 *		vi on command line in which case dont do it
		 */
E 5
I 5
			/*
			 * q		Quit back to command mode, unless
			 * called as vi on command line in which case dont do
			 * it
			 */
E 5
		case 'q':	/* quit */
			if (initev) {
				vsave();
				CATCH
					error("Q gets ex command mode, :q leaves vi");
				ENDCATCH
D 5
				splitw = 0;
E 5
I 5
					splitw = 0;
E 5
				getDOT();
				vrepaint(cursor);
				continue;
			}
#endif
			/* fall into... */

D 5
		/*
		 * Q		Is like q, but always gets to command mode
		 *		even if command line invocation was as vi.
		 */
E 5
I 5
			/*
			 * Q		Is like q, but always gets to command
			 * mode even if command line invocation was as vi.
			 */
E 5
		case 'Q':
			if (Mdirect)
				fixcurslr();
			vsave();
			/*
D 5
			 * If we are in the middle of a macro, throw away
			 * the rest and fix up undo.
			 * This code copied from getbr().
E 5
I 5
			 * If we are in the middle of a macro, throw away the
			 * rest and fix up undo. This code copied from
			 * getbr().
E 5
			 */
			if (vmacp) {
				vmacp = 0;
D 5
				if (inopen == -1)	/* don't screw up undo for esc esc */
E 5
I 5
				if (inopen == -1)	/* don't screw up undo
							 * for esc esc */
E 5
					vundkind = VMANY;
D 5
				inopen = 1;	/* restore old setting now that macro done */
E 5
I 5
				inopen = 1;	/* restore old setting now
						 * that macro done */
E 5
			}
			return;


D 5
		/*
		 * ZZ		Like :x
		 */
		 case 'Z':
E 5
I 5
			/*
			 * ZZ		Like :x
			 */
		case 'Z':
E 5
			forbid(getkey() != 'Z');
			oglobp = globp;
			globp = "x";
			vclrech(0);
			goto gogo;
D 5
			
		/*
		 * P		Put back text before cursor or before current
		 *		line.  If text was whole lines goes back
		 *		as whole lines.  If part of a single line
		 *		or parts of whole lines splits up current
		 *		line to form many new lines.
		 *		May specify a named buffer, or the delete
		 *		saving buffers 1-9.
		 *
		 * p		Like P but after rather than before.
		 */
E 5
I 5

			/*
			 * P		Put back text before cursor or before
			 * current line.  If text was whole lines goes back
			 * as whole lines.  If part of a single line or parts
			 * of whole lines splits up current line to form many
			 * new lines. May specify a named buffer, or the
			 * delete saving buffers 1-9.
			 * 
			 * p		Like P but after rather than before.
			 */
E 5
		case 'P':
		case 'p':
			vmoving = 0;
#ifdef notdef
D 5
			forbid (!vreg && value(UNDOMACRO) && inopen < 0);
E 5
I 5
			forbid(!vreg && value(UNDOMACRO) && inopen < 0);
E 5
#endif
			/*
D 5
			 * If previous delete was partial line, use an
			 * append or insert to put it back so as to
			 * use insert mode on intelligent terminals.
E 5
I 5
			 * If previous delete was partial line, use an append
			 * or insert to put it back so as to use insert mode
			 * on intelligent terminals.
E 5
			 */
			if (!vreg && DEL[0]) {
D 5
				forbid ((DEL[0] & (QUOTE|TRIM)) == OVERBUF);
		
E 5
I 5
				forbid((DEL[0] & (QUOTE | TRIM)) == OVERBUF);

E 5
				vglobp = DEL;
D 5
			/*	isp = 1;*/
E 5
I 5
				/* isp = 1; */
E 5
				ungetkey(c == 'p' ? 'a' : 'i');
				goto reread;
			}
D 5

E 5
			/*
D 5
			 * If a register wasn't specified, then make
			 * sure there is something to put back.
E 5
I 5
			 * If a register wasn't specified, then make sure
			 * there is something to put back.
E 5
			 */
D 5
			forbid (!vreg && unddol == dol);
E 5
I 5
			forbid(!vreg && unddol == dol);
E 5
			/*
D 5
			 * If we just did a macro the whole buffer is in
			 * the undo save area.  We don't want to put THAT.
E 5
I 5
			 * If we just did a macro the whole buffer is in the
			 * undo save area.  We don't want to put THAT.
E 5
			 */
D 5
			forbid (vundkind == VMANY && undkind==UNDALL);
E 5
I 5
			forbid(vundkind == VMANY && undkind == UNDALL);
E 5
			vsave();
			vmacchng(1);
			setLAST();
			i = 0;
			if (vreg && partreg(vreg) || !vreg && pkill[0]) {
				/*
D 5
				 * Restoring multiple lines which were partial
				 * lines; will leave cursor in middle
E 5
I 5
				 * Restoring multiple lines which were
				 * partial lines; will leave cursor in middle
E 5
				 * of line after shoving restored text in to
				 * split the current line.
				 */
				i++;
				if (c == 'p' && *cursor)
					cursor++;
			} else {
				/*
				 * In whole line case, have to back up dot
D 5
				 * for P; also want to clear cursor so
				 * cursor will eventually be positioned
				 * at the beginning of the first put line.
E 5
I 5
				 * for P; also want to clear cursor so cursor
				 * will eventually be positioned at the
				 * beginning of the first put line.
E 5
				 */
				cursor = 0;
				if (c == 'P') {
					dot--, vcline--;
					c = 'p';
				}
			}
			killU();

			/*
D 5
			 * The call to putreg can potentially
			 * bomb since there may be nothing in a named buffer.
			 * We thus put a catch in here.  If we didn't and
			 * there was an error we would end up in command mode.
E 5
I 5
			 * The call to putreg can potentially bomb since
			 * there may be nothing in a named buffer. We thus
			 * put a catch in here.  If we didn't and there was
			 * an error we would end up in command mode.
E 5
			 */
			addr = dol;	/* old dol */
			CATCH
				vremote(1, vreg ? putreg : put, vreg);
			ONERR
				if (vreg == -1) {
D 5
					splitw = 0;
					if (op == 'P')
						dot++, vcline++;
					goto pfixup;
				}
E 5
I 5
				splitw = 0;
				if (op == 'P')
					dot++, vcline++;
				goto pfixup;
			}
E 5
			ENDCATCH
D 5
			splitw = 0;
E 5
I 5
				splitw = 0;
E 5
			nlput = dol - addr + 1;
			if (!i) {
				/*
D 5
				 * Increment undap1, undap2 to make up
				 * for their incorrect initialization in the
E 5
I 5
				 * Increment undap1, undap2 to make up for
				 * their incorrect initialization in the
E 5
				 * routine vremote before calling put/putreg.
				 */
				if (FIXUNDO)
					undap1++, undap2++;
				vcline++;
				nlput--;

				/*
				 * After a put want current line first line,
				 * and dot was made the last line put in code
D 5
				 * run so far.  This is why we increment vcline
				 * above and decrease dot here.
E 5
I 5
				 * run so far.  This is why we increment
				 * vcline above and decrease dot here.
E 5
				 */
				dot -= nlput - 1;
			}
#ifdef TRACE
			if (trace)
				fprintf(trace, "vreplace(%d, %d, %d), undap1=%d, undap2=%d, dot=%d\n", vcline, i, nlput, lineno(undap1), lineno(undap2), lineno(dot));
#endif
			vreplace(vcline, i, nlput);
			if (state != VISUAL) {
				/*
D 5
				 * Special case in open mode.
				 * Force action on the screen when a single
				 * line is put even if it is identical to
				 * the current line, e.g. on YP; otherwise
				 * you can't tell anything happened.
E 5
I 5
				 * Special case in open mode. Force action on
				 * the screen when a single line is put even
				 * if it is identical to the current line,
				 * e.g. on YP; otherwise you can't tell
				 * anything happened.
E 5
				 */
				vjumpto(dot, cursor, '.');
				continue;
			}
D 5
pfixup:
E 5
I 5
	pfixup:
E 5
			vrepaint(cursor);
			vfixcurs();
			continue;

D 5
		/*
		 * ^^		Return to previous file.
		 *		Like a :e #, and thus can be used after a
		 *		"No Write" diagnostic.
		 */
E 5
I 5
			/*
			 * ^^		Return to previous file. Like a :e #,
			 * and thus can be used after a "No Write"
			 * diagnostic.
			 */
E 5
		case CTRL(^):
D 5
			forbid (hadcnt);
E 5
I 5
			forbid(hadcnt);
E 5
			vsave();
			ckaw();
			oglobp = globp;
			if (value(AUTOWRITE))
				globp = "e! #";
			else
				globp = "e #";
			goto gogo;

D 5
		/*
		 * ^]		Takes word after cursor as tag, and then does
		 *		tag command.  Read ``go right to''.
		 */
E 5
I 5
			/*
			 * ^]		Takes word after cursor as tag, and
			 * then does tag command.  Read ``go right to''.
			 */
E 5
		case CTRL(]):
			grabtag();
			oglobp = globp;
			globp = "tag";
			goto gogo;

D 5
		/*
		 * &		Like :&
		 */
		 case '&':
E 5
I 5
			/*
			 * &		Like :&
			 */
		case '&':
E 5
			oglobp = globp;
			globp = "&";
			goto gogo;
D 5
			
		/*
		 * ^G		Bring up a status line at the bottom of
		 *		the screen, like a :file command.
		 *
		 * BUG:		Was ^S but doesn't work in cbreak mode
		 */
E 5
I 5

			/*
			 * ^G		Bring up a status line at the bottom
			 * of the screen, like a :file command.
			 * 
			 * BUG:		Was ^S but doesn't work in cbreak
			 * mode
			 */
E 5
		case CTRL(g):
			oglobp = globp;
			globp = "file";
D 5
gogo:
E 5
I 5
	gogo:
E 5
			addr = dot;
			vsave();
			goto doinit;

#ifdef SIGTSTP
D 5
		/*
		 * ^Z:	suspend editor session and temporarily return
		 * 	to shell.  Only works with Berkeley/IIASA process
		 *	control in kernel.
		 */
E 5
I 5
			/*
			 * ^Z:	suspend editor session and temporarily return
			 * to shell.  Only works with Berkeley/IIASA process
			 * control in kernel.
			 */
E 5
		case CTRL(z):
			forbid(dosusp == 0 || !ldisc);
			vsave();
			oglobp = globp;
			globp = "stop";
			goto gogo;
#endif

D 5
		/*
		 * :		Read a command from the echo area and
		 *		execute it in command mode.
		 */
E 5
I 5
			/*
			 * :		Read a command from the echo area and
			 * execute it in command mode.
			 */
E 5
		case ':':
D 5
			/* (c) . ADD by Uri habusha for vi.iv .Date :21-jan-88 */
E 5
I 5
			/*
			 * (c) . ADD by Uri habusha for vi.iv .Date
			 * :21-jan-88
			 */
E 5
			if (INdirect == RL) {
				chanf = 1;
				INdirect = LR;
				setLR();
D 5
				if (!HF){
E 5
I 5
				if (!HF) {
E 5
					prmsg(1, "PLEASE MANUALLY FLIP TERMINAL TO LATIN MODE.");
					sleep(2);
				}
D 5
			}	
E 5
I 5
			}
E 5
			/* END for vi.iv */
D 5
			forbid (hadcnt);
E 5
I 5
			forbid(hadcnt);
E 5
			vsave();
			i = tchng;
			addr = dot;
			if (readecho(c)) {
				esave[0] = 0;
				goto fixup;
			}
			getDOT();
			/*
			 * Use the visual undo buffer to store the global
D 5
			 * string for command mode, since it is idle right now.
E 5
I 5
			 * string for command mode, since it is idle right
			 * now.
E 5
			 */
D 5
			oglobp = globp; strcpy(vutmp, genbuf+1); globp = vutmp;
doinit:
E 5
I 5
			oglobp = globp;
			strcpy(vutmp, genbuf + 1);
			globp = vutmp;
	doinit:
E 5
			esave[0] = 0;
			fixech();

			/*
D 5
			 * Have to finagle around not to lose last
			 * character after this command (when run from ex
			 * command mode).  This is clumsy.
E 5
I 5
			 * Have to finagle around not to lose last character
			 * after this command (when run from ex command
			 * mode).  This is clumsy.
E 5
			 */
D 5
			d = peekc; ungetchar(0);
E 5
I 5
			d = peekc;
			ungetchar(0);
E 5
			if (shouldpo) {
				/*
				 * So after a "Hit return..." ":", we do
				 * another "Hit return..." the next time
				 */
				pofix();
				shouldpo = 0;
			}
			CATCH
D 5
				/*
				 * Save old values of options so we can
				 * notice when they change; switch into
				 * cooked mode so we are interruptible.
				 */
E 5
I 5
			/*
			 * Save old values of options so we can notice when
			 * they change; switch into cooked mode so we are
			 * interruptible.
			 */
E 5
				onumber = value(NUMBER);
D 5
				olist = value(LIST);
				odirect = value(RIGHTLEFT);
				omark = value(MARKSL);
				OPline = Pline;
				OPutchar = Putchar;
E 5
I 5
			olist = value(LIST);
			odirect = value(RIGHTLEFT);
			omark = value(MARKSL);
			OPline = Pline;
			OPutchar = Putchar;
E 5
#ifndef CBREAK
D 5
				vcook();
E 5
I 5
			vcook();
E 5
#endif
D 5
				commands(1, 1);
				/*
				 * Fix cursor motion for RL text after
				 * we change it in fixech procedure.
				 * Added for vi.iv at 17/6/88.
				 */
				if (isRLtext && Plod != plodRL)
					fixcursrl();
				if (dot == zero && dol > zero)
					dot = one;
E 5
I 5
			commands(1, 1);
			/*
			 * Fix cursor motion for RL text after we change it
			 * in fixech procedure. Added for vi.iv at 17/6/88.
			 */
			if (isRLtext && Plod != plodRL)
				fixcursrl();
			if (dot == zero && dol > zero)
				dot = one;
E 5
#ifndef CBREAK
D 5
				vraw();
E 5
I 5
			vraw();
E 5
#endif
			ONERR
#ifndef CBREAK
				vraw();
#endif
D 5
				copy(esave, vtube[WECHO], TUBECOLS);
E 5
I 5
			copy(esave, vtube[WECHO], TUBECOLS);
E 5
			ENDCATCH
D 5
			fixol();
E 5
I 5
				fixol();
E 5
			Pline = OPline;
			Putchar = OPutchar;
			ungetchar(d);
			globp = oglobp;

			/*
D 5
			 * If we ended up with no lines in the buffer, make
			 * a line, and don't consider the buffer changed.
E 5
I 5
			 * If we ended up with no lines in the buffer, make a
			 * line, and don't consider the buffer changed.
E 5
			 */
			if (dot == zero) {
				fixzero();
				sync();
			}
			splitw = 0;
			if (chanf) {
				chanf = 0;
				INdirect = RL;
D 5
			}	

E 5
I 5
			}
E 5
			/*
			 * Special case: did list/number options change?
			 */
			if (onumber != value(NUMBER))
				setnumb(value(NUMBER));
			if (olist != value(LIST))
				setlist(value(LIST));
			if (omark != value(MARKSL))
				omark = 1;
D 5
			if (odirect != value(RIGHTLEFT)){
E 5
I 5
			if (odirect != value(RIGHTLEFT)) {
E 5
				vclear();
				setmotion(value(RIGHTLEFT));
D 5
				if(INdirect){ 
				    if (HE && !HF){
					prmsg(1, "PLEASE MANUALLY FLIP TERMINAL TO HEBREW MODE.");
					chLR = 1;
				    }
				    else if (!HE && !HF){
E 5
I 5
				if (INdirect) {
					if (HE && !HF) {
						prmsg(1, "PLEASE MANUALLY FLIP TERMINAL TO HEBREW MODE.");
						chLR = 1;
					} else if (!HE && !HF) {
E 5
						prmsg(1, "USING SLOW MODE. PLEASE MANUALLY FLIP TERMINAL TO HEBREW MODE.");
						chLR = 1;
D 5
				    	}
						else if (!HE)
							prmsg(1, "USING SLOW MODE.");
				}else
					if (!INdirect && !HN)
						prmsg(1, "PLEASE MANUALLY FLIP TERMINAL TO LATIN MODE.");
E 5
I 5
					} else if (!HE)
						prmsg(1, "USING SLOW MODE.");
				} else if (!INdirect && !HN)
					prmsg(1, "PLEASE MANUALLY FLIP TERMINAL TO LATIN MODE.");
E 5
			}
D 5

fixup:
E 5
I 5
	fixup:
E 5
			/*
D 5
			 * If a change occurred, other than
			 * a write which clears changes, then
			 * we should allow an undo even if .
			 * didn't move.
			 *
			 * BUG: You can make this wrong by
			 * tricking around with multiple commands
			 * on one line of : escape, and including
			 * a write command there, but its not
			 * worth worrying about.
E 5
I 5
			 * If a change occurred, other than a write which
			 * clears changes, then we should allow an undo even
			 * if . didn't move.
			 * 
			 * BUG: You can make this wrong by tricking around with
			 * multiple commands on one line of : escape, and
			 * including a write command there, but its not worth
			 * worrying about.
E 5
			 */
D 5
			if (FIXUNDO && tchng && tchng != i); 
				vundkind = VMANY, cursor = 0;
E 5
I 5
			if (FIXUNDO && tchng && tchng != i);
			vundkind = VMANY, cursor = 0;
E 5

			/*
D 5
			 * If we are about to do another :, hold off
			 * updating of screen.
E 5
I 5
			 * If we are about to do another :, hold off updating
			 * of screen.
E 5
			 */
			if (vcnt < 0 && Peekkey == ':') {
				getDOT();
				shouldpo = 1;
				continue;
			}
			shouldpo = 0;

			/*
D 5
			 * In the case where the file being edited is
			 * new; e.g. if the initial state hasn't been
			 * saved yet, then do so now.
E 5
I 5
			 * In the case where the file being edited is new;
			 * e.g. if the initial state hasn't been saved yet,
			 * then do so now.
E 5
			 */
			if (unddol == truedol) {
				vundkind = VNONE;
				Vlines = lineDOL();
				if (!inglobal)
					savevis();
				addr = zero;
				vcnt = 0;
				if (esave[0] == 0)
					copy(esave, vtube[WECHO], TUBECOLS);
			}
D 5

E 5
			/*
D 5
			 * If the current line moved reset the cursor position.
E 5
I 5
			 * If the current line moved reset the cursor
			 * position.
E 5
			 */
			if (dot != addr) {
				vmoving = 0;
				cursor = 0;
			}
D 5

E 5
			/*
D 5
			 * If current line is not on screen or if we are
			 * in open mode and . moved, then redraw.
E 5
I 5
			 * If current line is not on screen or if we are in
			 * open mode and . moved, then redraw.
E 5
			 */
			i = vcline + (dot - addr);
			if (i < 0 || i >= vcnt && i >= -vcnt || state != VISUAL && dot != addr) {
				if (state == CRTOPEN)
					vup1();
				if (vcnt > 0)
					vcnt = 0;
				vjumpto(dot, (char *) 0, '.');
			} else {
				/*
D 5
				 * Current line IS on screen.
				 * If we did a [Hit return...] then
				 * restore vcnt and clear screen if in visual
E 5
I 5
				 * Current line IS on screen. If we did a
				 * [Hit return...] then restore vcnt and
				 * clear screen if in visual
E 5
				 */
				vcline = i;
				if (vcnt < 0) {
					vcnt = -vcnt;
					if (state == VISUAL)
						vclear();
					else if (state == CRTOPEN) {
						vcnt = 0;
					}
				}
D 5

E 5
				/*
				 * Limit max value of vcnt based on $
				 */
				i = vcline + lineDOL() - lineDOT() + 1;
				if (i < vcnt)
					vcnt = i;
D 5
				
E 5
I 5

E 5
				/*
				 * Dirty and repaint.
				 */
				vdirty(0, LINES);
				vrepaint(cursor);
				omark = 0;
			}

			/*
D 5
			 * If in visual, put back the echo area
			 * if it was clobberred.
E 5
I 5
			 * If in visual, put back the echo area if it was
			 * clobberred.
E 5
			 */
			if (state == VISUAL) {
D 5
				int sdc = destcol, sdl = destline;
E 5
I 5
				int             sdc = destcol, sdl = destline;
E 5

				splitw++;
				/*
D 5
				 *  We want that in echo area it will
				 * print in LR direction .
				 * Added for vi.iv at 18/7/88.
E 5
I 5
				 * We want that in echo area it will print in
				 * LR direction . Added for vi.iv at 18/7/88.
E 5
				 */
				if (isRLtext && Plod != plod)
					fixcurslr();
				vigoto(WECHO, 0);
				if ((isRL || isRLtext) && SO && SE)
					putpad(SO);
				for (i = 0; i < TUBECOLS - 1; i++) {
					if (esave[i] == 0)
						break;
					vputchar(esave[i]);
				}
				if ((isRL || isRLtext) && SO && SE)
					putpad(SE);
				splitw = 0;
				/*
D 5
				 *  Return to normal printing direction.
				 * Added for vi.iv at 18/7/88.
E 5
I 5
				 * Return to normal printing direction. Added
				 * for vi.iv at 18/7/88.
E 5
				 */
				if (isRLtext && Plod == plod)
					fixcursrl();
				vgoto(sdl, sdc);
			}
			continue;

D 5
		/*
		 * u		undo the last changing command.
		 */
E 5
I 5
			/*
			 * u		undo the last changing command.
			 */
E 5
		case 'u':
			vundo(1);
			continue;

D 5
		/*
		 * U		restore current line to initial state.
		 */
E 5
I 5
			/*
			 * U		restore current line to initial
			 * state.
			 */
E 5
		case 'U':
			vUndo();
			continue;

D 5
fonfon:
E 5
I 5
	fonfon:
E 5
			beep();
			vmacp = 0;
			inopen = 1;	/* might have been -1 */
			continue;
D 5
		}
E 5
I 5
		}		/* end of switch (c) */
E 5

		/*
D 5
		 * Rest of commands are decoded by the operate
		 * routine.
E 5
I 5
		 * Rest of commands are decoded by the operate routine.
E 5
		 */
		operate(c, cnt);
D 5
	}
E 5
I 5
	}			/* end of for (;;) */
E 5
}

I 5
/*=======================================================
 * OTHER FUNCTIONS
 *======================================================
 */

E 5
/*
 * Grab the word after the cursor so we can look for it as a tag.
 */
grabtag()
{
D 5
	register char *cp, *dp;
E 5
I 5
	register char  *cp, *dp;
E 5

	cp = vpastwh(cursor);
	if (*cp) {
		dp = lasttag;
		do {
			if (dp < &lasttag[sizeof lasttag - 2])
				*dp++ = *cp;
			cp++;
		} while (isalpha(*cp) || isdigit(*cp) || *cp == '_'
#ifdef LISPCODE
D 5
			|| (value(LISP) && *cp == '-')
E 5
I 5
			 || (value(LISP) && *cp == '-')
E 5
#endif LISPCODE
			);
		*dp++ = 0;
	}
}

/*
D 5
 * Before appending lines, set up addr1 and
 * the command mode undo information.
E 5
I 5
 * Before appending lines, set up addr1 and the command mode undo
 * information.
E 5
 */
prepapp()
{

	addr1 = dot;
	deletenone();
	addr1++;
	appendnone();
}

/*
D 5
 * Execute function f with the address bounds addr1
 * and addr2 surrounding cnt lines starting at dot.
E 5
I 5
 * Execute function f with the address bounds addr1 and addr2 surrounding cnt
 * lines starting at dot.
E 5
 */
vremote(cnt, f, arg)
D 5
	int cnt, (*f)(), arg;
E 5
I 5
	int             cnt, (*f) (), arg;
E 5
{
D 5
	register int oing = inglobal;
E 5
I 5
	register int    oing = inglobal;
E 5

	addr1 = dot;
	addr2 = dot + cnt - 1;
	inglobal = 0;
	if (FIXUNDO)
		undap1 = undap2 = dot;
D 5
	(*f)(arg);
E 5
I 5
	(*f) (arg);
E 5
	inglobal = oing;
	if (FIXUNDO)
		vundkind = VMANY;
	vmcurs = 0;
}

/*
 * Save the current contents of linebuf, if it has changed.
 */
vsave()
{
D 5
	char temp[LBSIZE];
E 5
I 5
	char            temp[LBSIZE];
E 5

	CP(temp, linebuf);
	if (convto && ishef)
		changseclan(temp, Mdirect);
	if (FIXUNDO && vundkind == VCHNG || vundkind == VCAPU) {
		/*
D 5
		 * If the undo state is saved in the temporary buffer
		 * vutmp, then we sync this into the temp file so that
		 * we will be able to undo even after we have moved off
		 * the line.  It would be possible to associate a line
		 * with vutmp but we assume that vutmp is only associated
		 * with line dot (e.g. in case ':') above, so beware.
E 5
I 5
		 * If the undo state is saved in the temporary buffer vutmp,
		 * then we sync this into the temp file so that we will be
		 * able to undo even after we have moved off the line.  It
		 * would be possible to associate a line with vutmp but we
		 * assume that vutmp is only associated with line dot (e.g.
		 * in case ':') above, so beware.
E 5
		 */
		prepapp();
		strcLIN(vutmp);
		putmark(dot);
		vremote(1, yank, 0);
		vundkind = VMCHNG;
		notecnt = 0;
		undkind = UNDCHANGE;
	}
	/*
	 * Get the line out of the temp file and do nothing if it hasn't
D 5
	 * changed.  This may seem like a loss, but the line will
	 * almost always be in a read buffer so this may well avoid disk i/o.
E 5
I 5
	 * changed.  This may seem like a loss, but the line will almost
	 * always be in a read buffer so this may well avoid disk i/o.
E 5
	 */
	getDOT();
	if (convto)
		convto = 0;
	if (strcmp(linebuf, temp) == 0)
		return;
	strcLIN(temp);
	putmark(dot);
}

I 2
D 5
	/* this was originally defined near the beginning of the file */
E 5
I 5
/* this was originally defined near the beginning of the file */
E 5
E 2
#undef	forbid
#define	forbid(a)	if (a) { beep(); return; }

/*
D 5
 * Do a z operation.
 * Code here is rather long, and very uninteresting.
E 5
I 5
 * Do a z operation. Code here is rather long, and very uninteresting.
E 5
 */
vzop(hadcnt, cnt, c)
D 5
	bool hadcnt;
	int cnt;
	register int c;
E 5
I 5
	bool            hadcnt;
	int             cnt;
	register int    c;
E 5
{
D 5
	register line *addr;
E 5
I 5
	register line  *addr;
E 5

	if (state != VISUAL) {
		/*
D 5
		 * Z from open; always like a z=.
		 * This code is a mess and should be cleaned up.
E 5
I 5
		 * Z from open; always like a z=. This code is a mess and
		 * should be cleaned up.
E 5
		 */
		vmoveitup(1, 1);
		vgoto(outline, 0);
		ostop(normf);
		setoutt();
		addr2 = dot;
		vclear();
		destline = WECHO;
		zop2(Xhadcnt ? Xcnt : value(WINDOW) - 1, '=');
		if (state == CRTOPEN)
			putnl();
		putNFL();
		termreset();
		Outchar = vputchar;
		ignore(ostart());
		vcnt = 0;
		outline = destline = 0;
		vjumpto(dot, cursor, 0);
		return;
	}
	if (hadcnt) {
		addr = zero + cnt;
		if (addr < one)
			addr = one;
		if (addr > dol)
			addr = dol;
		markit(addr);
	} else
		switch (c) {

		case '+':
			addr = dot + vcnt - vcline;
			break;

		case '^':
			addr = dot - vcline - 1;
D 5
			forbid (addr < one);
E 5
I 5
			forbid(addr < one);
E 5
			c = '-';
			break;

		default:
			addr = dot;
			break;
		}
	switch (c) {

	case '.':
	case '-':
		break;

	case '^':
D 5
		forbid (addr <= one);
E 5
I 5
		forbid(addr <= one);
E 5
		break;

	case '+':
D 5
		forbid (addr >= dol);
E 5
I 5
		forbid(addr >= dol);
E 5
		/* fall into ... */

	case CR:
	case NL:
		c = CR;
		break;

	default:
		beep();
		return;
	}
	vmoving = 0;
	vjumpto(addr, NOSTR, c);
}
E 1
