/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JBM
extends JFrame {
    static JTabbedPane tabs = new JTabbedPane(1);
    final JPopupMenu popup = new JPopupMenu();
    int tabNum = 0;
    int currentTabIndex = 0;
    static Preferences prefs = Preferences.userRoot().node("JBibtexManager");

    void setInitialPreferences() {
        this.readPreferences();
        Globals.updateFont(Globals.FONTNAME, Globals.FONTSIZE);
        this.setSize(Globals.WINDOW_WIDTH, Globals.WINDOW_HEIGHT);
        Globals.updateBackgroundColor(Globals.BACKGROUND_R, Globals.BACKGROUND_G, Globals.BACKGROUND_B);
        Globals.updateForegroundColor(Globals.FOREGROUND_R, Globals.FOREGROUND_G, Globals.FOREGROUND_B);
    }

    void readPreferences() {
        Globals.FONTNAME = prefs.get(Globals.FONTNAME_PREF, Globals.FONTNAME_DEFAULT);
        Globals.FONTSIZE = prefs.getInt(Globals.FONTSIZE_PREF, Globals.FONTSIZE_DEFAULT);
        Globals.WINDOW_WIDTH = prefs.getInt(Globals.WINDOW_WIDTH_PREF, Globals.WINDOW_WIDTH_DEFAULT);
        Globals.WINDOW_HEIGHT = prefs.getInt(Globals.WINDOW_HEIGHT_PREF, Globals.WINDOW_HEIGHT_DEFAULT);
        Globals.BACKGROUND_R = prefs.getInt(Globals.BACKGROUND_R_PREF, Globals.BACKGROUND_R);
        Globals.BACKGROUND_G = prefs.getInt(Globals.BACKGROUND_G_PREF, Globals.BACKGROUND_G);
        Globals.BACKGROUND_B = prefs.getInt(Globals.BACKGROUND_B_PREF, Globals.BACKGROUND_B);
        Globals.FOREGROUND_R = prefs.getInt(Globals.FOREGROUND_R_PREF, Globals.FOREGROUND_R);
        Globals.FOREGROUND_G = prefs.getInt(Globals.FOREGROUND_G_PREF, Globals.FOREGROUND_G);
        Globals.FOREGROUND_B = prefs.getInt(Globals.FOREGROUND_B_PREF, Globals.FOREGROUND_B);
        Globals.BACKUP = prefs.getBoolean(Globals.BACKUP_PREF, true);
        Globals.TEMPLATE_ARTICLE = prefs.get(Globals.TEMPLATE_ARTICLE_PREF, Globals.TEMPLATE_ARTICLE);
        Globals.TEMPLATE_BOOK = prefs.get(Globals.TEMPLATE_BOOK_PREF, Globals.TEMPLATE_BOOK);
        Globals.TEMPLATE_INBOOK = prefs.get(Globals.TEMPLATE_INBOOK_PREF, Globals.TEMPLATE_INBOOK);
        Globals.TEMPLATE_BOOKLET = prefs.get(Globals.TEMPLATE_BOOKLET_PREF, Globals.TEMPLATE_BOOKLET);
        Globals.TEMPLATE_INCOLLECTION = prefs.get(Globals.TEMPLATE_INCOLLECTION_PREF, Globals.TEMPLATE_INCOLLECTION);
        Globals.TEMPLATE_INPROCEEDINGS = prefs.get(Globals.TEMPLATE_INPROCEEDINGS_PREF, Globals.TEMPLATE_INPROCEEDINGS);
        Globals.TEMPLATE_MANUAL = prefs.get(Globals.TEMPLATE_MANUAL_PREF, Globals.TEMPLATE_MANUAL);
        Globals.TEMPLATE_MASTERSTHESIS = prefs.get(Globals.TEMPLATE_MASTERSTHESIS_PREF, Globals.TEMPLATE_MASTERSTHESIS);
        Globals.TEMPLATE_MISC = prefs.get(Globals.TEMPLATE_MISC_PREF, Globals.TEMPLATE_MISC);
        Globals.TEMPLATE_PERIODICAL = prefs.get(Globals.TEMPLATE_PERIODICAL_PREF, Globals.TEMPLATE_PERIODICAL);
        Globals.TEMPLATE_PHDTHESIS = prefs.get(Globals.TEMPLATE_PHDTHESIS_PREF, Globals.TEMPLATE_PHDTHESIS);
        Globals.TEMPLATE_PROCEEDINGS = prefs.get(Globals.TEMPLATE_PROCEEDINGS_PREF, Globals.TEMPLATE_PROCEEDINGS);
        Globals.TEMPLATE_TECHREPORT = prefs.get(Globals.TEMPLATE_TECHREPORT_PREF, Globals.TEMPLATE_TECHREPORT);
        Globals.TEMPLATE_UNPUBLISHED = prefs.get(Globals.TEMPLATE_UNPUBLISHED_PREF, Globals.TEMPLATE_UNPUBLISHED);
    }

    void savePreferences() {
        prefs.put(Globals.FONTNAME_PREF, Globals.FONTNAME);
        prefs.putInt(Globals.FONTSIZE_PREF, Globals.FONTSIZE);
        prefs.putInt(Globals.WINDOW_WIDTH_PREF, this.getWidth());
        prefs.putInt(Globals.WINDOW_HEIGHT_PREF, this.getHeight());
        prefs.putInt(Globals.BACKGROUND_R_PREF, Globals.BACKGROUND_R);
        prefs.putInt(Globals.BACKGROUND_G_PREF, Globals.BACKGROUND_G);
        prefs.putInt(Globals.BACKGROUND_B_PREF, Globals.BACKGROUND_B);
        prefs.putInt(Globals.FOREGROUND_R_PREF, Globals.FOREGROUND_R);
        prefs.putInt(Globals.FOREGROUND_G_PREF, Globals.FOREGROUND_G);
        prefs.putInt(Globals.FOREGROUND_B_PREF, Globals.FOREGROUND_B);
        prefs.putBoolean(Globals.BACKUP_PREF, Globals.BACKUP);
        prefs.put(Globals.TEMPLATE_ARTICLE_PREF, Globals.TEMPLATE_ARTICLE);
        prefs.put(Globals.TEMPLATE_BOOK_PREF, Globals.TEMPLATE_BOOK);
        prefs.put(Globals.TEMPLATE_INBOOK_PREF, Globals.TEMPLATE_INBOOK);
        prefs.put(Globals.TEMPLATE_BOOKLET_PREF, Globals.TEMPLATE_BOOKLET);
        prefs.put(Globals.TEMPLATE_INCOLLECTION_PREF, Globals.TEMPLATE_INCOLLECTION);
        prefs.put(Globals.TEMPLATE_INPROCEEDINGS_PREF, Globals.TEMPLATE_INPROCEEDINGS);
        prefs.put(Globals.TEMPLATE_MANUAL_PREF, Globals.TEMPLATE_MANUAL);
        prefs.put(Globals.TEMPLATE_MASTERSTHESIS_PREF, Globals.TEMPLATE_MASTERSTHESIS);
        prefs.put(Globals.TEMPLATE_MISC_PREF, Globals.TEMPLATE_MISC);
        prefs.put(Globals.TEMPLATE_PERIODICAL_PREF, Globals.TEMPLATE_PERIODICAL);
        prefs.put(Globals.TEMPLATE_PHDTHESIS_PREF, Globals.TEMPLATE_PHDTHESIS);
        prefs.put(Globals.TEMPLATE_PROCEEDINGS_PREF, Globals.TEMPLATE_PROCEEDINGS);
        prefs.put(Globals.TEMPLATE_TECHREPORT_PREF, Globals.TEMPLATE_TECHREPORT);
        prefs.put(Globals.TEMPLATE_UNPUBLISHED_PREF, Globals.TEMPLATE_UNPUBLISHED);
        try {
            prefs.flush();
        }
        catch (BackingStoreException backingStoreException) {
            System.err.println("ERROR: Unable to store preferences");
        }
    }

    public static void setTabTitle(String string) {
        tabs.setTitleAt(tabs.getSelectedIndex(), string);
    }

    String makeTitle() {
        return "*blank*: " + this.tabNum++;
    }

    void newTab() {
        tabs.addTab(this.makeTitle(), new JBibtexManager());
    }

    void closeTab() {
        if (this.currentTabIndex >= 0) {
            JBibtexManager jBibtexManager = (JBibtexManager)tabs.getComponentAt(this.currentTabIndex);
            jBibtexManager.cleanUp();
            if (tabs.getTabCount() > 1) {
                tabs.remove(this.currentTabIndex);
            }
        }
    }

    void closeAllTabsAndExit() {
        int n = tabs.getTabCount() - 1;
        while (n >= 0) {
            this.currentTabIndex = n--;
            this.closeTab();
        }
        this.savePreferences();
        System.exit(-1);
    }

    void setupPopupMenu() {
        ImageIcon imageIcon = new ImageIcon("images16/Close16.gif");
        ImageIcon imageIcon2 = new ImageIcon("images16/New16.gif");
        JMenuItem jMenuItem = new JMenuItem("New Tab", imageIcon2);
        JMenuItem jMenuItem2 = new JMenuItem("Close Tab", imageIcon);
        JMenuItem jMenuItem3 = new JMenuItem("Close All Tabs and Exit", new ImageIcon(this.getClass().getResource("images16/Exit16.gif")));
        jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(84, 2));
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        tabs.getActionMap().put("new", new AbstractAction("new"){

            public void actionPerformed(ActionEvent actionEvent) {
                JBM.this.newTab();
            }
        });
        KeyStroke keyStroke = KeyStroke.getKeyStroke(84, 2);
        tabs.getInputMap(2).put(keyStroke, "new");
        tabs.getActionMap().put("close", new AbstractAction("close"){

            public void actionPerformed(ActionEvent actionEvent) {
                JBM.this.closeTab();
            }
        });
        keyStroke = KeyStroke.getKeyStroke(87, 2);
        tabs.getInputMap(2).put(keyStroke, "close");
        tabs.getActionMap().put("closeAllExit", new AbstractAction("closeAllExit"){

            public void actionPerformed(ActionEvent actionEvent) {
                JBM.this.closeAllTabsAndExit();
            }
        });
        keyStroke = KeyStroke.getKeyStroke(81, 2);
        tabs.getInputMap(2).put(keyStroke, "closeAllExit");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JBM.this.newTab();
            }
        });
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JBM.this.closeTab();
            }
        });
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JBM.this.closeAllTabsAndExit();
            }
        });
        this.popup.add(jMenuItem);
        this.popup.add(jMenuItem2);
        this.popup.add(new JSeparator());
        this.popup.add(jMenuItem3);
    }

    void setupTabs() {
        tabs.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    JBM.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    JBM.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        tabs.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
                JBM.this.currentTabIndex = jTabbedPane.getSelectedIndex();
            }
        });
    }

    public JBM() {
        this.setTitle("JBibtexManager");
        this.setInitialPreferences();
        this.setupPopupMenu();
        this.setupTabs();
        JFrame.setDefaultLookAndFeelDecorated(true);
        this.newTab();
        this.getContentPane().add(tabs);
        this.setDefaultCloseOperation(3);
        this.setIconImage(new ImageIcon(this.getClass().getResource("images16/JBMicon.gif")).getImage());
    }

    public static void main(String[] stringArray) {
        new JBM().setVisible(true);
    }
}

