/*
 *	This file contains data structure definitions that will be
 *	used by all device drivers.
 *
 *	Save / Restore structure:
 */

struct Graphics_State {
	struct Graphics_State *Pred;	/* Pointer to predecessor on stack */
	pointer Ident;			/* Identifier (unique address) */
	unsigned long Line_Width;	/* Line width, in 1/1024 pixels */
	unsigned int Dashline_Len;	/* Length of dashline specification */
	unsigned int Dashline_Spec[20];	/* Dashline specification */
	unsigned int Dashline_Phase;	/* Initial phase of line style */
	unsigned long Scaled_Spec[20];	/* Scaled dashline specification */
	unsigned long Scaled_Phase;	/* Scaled phase of endpoint of line drawn */
	long Graphics_X, Graphics_Y;	/* Endpoint of last line drawn */
	struct {
		unsigned int Red_Component;
		unsigned int Green_Component;
		unsigned int Blue_Component;
	} Color;
	unsigned int Flags;		/* Flags word */
#define XY_DEFINED    0x0001
#define CHANGE_LWIDTH 0x0002
#define CHANGE_LSTYLE 0x0004
};
struct Graphics_State *Graphics_SP = 0;
struct Graphics_State Current_State;
