


          MF(1)                INTERACTIVE UNIX System                MF(1)



          NAME
               mf, inimf  - Metafont, a language for alphabet design

          SYNOPSIS
               mmmmffff [ first line ]

               iiiinnnniiiimmmmffff [ first line ]

               vvvviiiirrrrmmmmffff [ first line ]

          DESCRIPTION
               METAFONT reads the program in the specified files and out-
               puts font rasters (in _g_f format) and font metrics (in _t_f_m
               format).  METAFONT capabilities and language are described
               in _T_h_e _M_E_T_A_F_O_N_T_b_o_o_k by Donald E. Knuth, published by
               Addison-Wesley.

               Like TeX , METAFONT is normally used with a large body of
               precompiled macros, and font generation in particular
               requires the support of several macro files.  The basic pro-
               gram as compiled is called _i_n_i_m_f; it can be used to precom-
               pile macros into a ._b_a_s_e file.  The _v_i_r_m_f variant is used to
               reload the ._b_a_s_e files quickly.  Typically, _v_i_r_m_f has links
               to it by the names of the various base files.  For example,
               if you link _f_o_o to _v_i_r_m_f and then execute the program _f_o_o,
               you get the base file _f_o_o._b_a_s_e.  You can load a different
               base by saying, e.g., _v_i_r_m_f&mybase.

               As described in _T_h_e _M_E_T_A_F_O_N_T_b_o_o_k, the command line (or first
               input line) should otherwise begin with a file name or a
               \controlsequence.  The normal usage is to say

                    mmmmffff  '\mode=<printengine>; [mag=magstep(_n);]' input
                    _f_o_n_t

               to start processing _f_o_n_t._m_f.  The single quotes are the best
               way of keeping your shell from misinterpreting the semi-
               colons and from removing the \ character, which is needed
               here to keep METAFONT from thinking that you want to produce
               a font called ``mode''. (Or you can just say mmmmffff and give the
               other stuff on the next line, without quotes.) Other control
               sequences, such as bbbbaaaattttcccchhhhmmmmooooddddeeee (for silent operation) can also
               appear. The name ``font'' will be the ``jobname'', and is
               used in forming output file names.  If METAFONT doesn't get
               a file name in the first line, the jobname is ``mfput''.
               The default extension, ._m_f, can be overridden by specifying
               an extension explicitly.

               A log of error messages goes into the file _j_o_b_n_a_m_e...._l_o_g.  The
               output files are _j_o_b_n_a_m_e...._t_f_m and _j_o_b_n_a_m_e....<number>_g_f, where
               <number> depends on the resolution and magnification of the
               font.  The ``mode'' in this example is shown generically as
               <printengine>, a symbolic term for which the name of an


          Rev. 9/25/90                                               Page 1






          MF(1)                INTERACTIVE UNIX System                MF(1)



               actual device or the name ``localfont'' (see below) must be
               substituted. If the mode is not specified or is not valid
               for your site, METAFONT will default to ``proof'' mode which
               produces large character images for use in font design and
               refinement.  Proof mode can be recognized by the suffix
               ._2_6_0_2_g_f after the jobname.  Examples of proof mode output
               can be found in _C_o_m_p_u_t_e_rModern_T_y_p_e_f_a_c_e_s, (Volume E of _C_o_m_p_u_-
               _t_e_r_sand_T_y_p_e_s_e_t_t_i_n_g), by Donald Knuth.  The system of _m_a_g_-
               _s_t_e_p_s is identical to the system used by TeX , with values
               generally in the range 0.5, 1.0, 2.0, 3.0, 4.0 and 5.0.  A
               listing of gf numbers for 118-dpi, 240-dpi and 300-dpi fonts
               is shown below.
                          MAGSTEP        118 dpi   240 dpi   300 dpi
                      mag=magstep(0)       118       240       300
                      mag=magstep(0.5)     129       263       329
                      mag=magstep(1)       142       288       360
                      mag=magstep(2)       170       346       432
                      mag=magstep(3)       204       415       518
                      mag=magstep(4)       245       498       622
                      mag=magstep(5)       294       597       746

               Magnification can also be specified not as a magstep but as
               an arbitrary value, such as 1.315, to create special charac-
               ter sizes.

               Before font production can begin, it is necessary to set up
               the appropriate base files.  The minimum set of components
               for font production for a given print-engine is the _p_l_a_i_n._m_f
               macro file and the local `mode_def' file.  The macros in
               _p_l_a_i_n._m_f can be studied in an appendix to the _M_E_T_A_F_O_N_T_b_o_o_k;
               they were developed by Donald Knuth, and this file should
               never be altered except when it is officially upgraded. Each
               mode_def specification helps adapt fonts to a particular
               print-engine.  There is a regular discussion of mode_defs in
               the journal of the TeX Users Group, _T_U_G_b_o_a_t; the local ones
               in use on this computer should be somewhere in the directory
               ////uuuussssrrrr////llllooooccccaaaallll////lllliiiibbbb////mmmmffff////iiiinnnnppppuuuuttttssss.  With only _p_l_a_i_n._m_f and the
               ``modes'' file loaded it is possible to create fonts of sim-
               ple characters, such as those used for the METAFONT logo,
               and those used for the LaTeX  line and circle fonts, but the
               production of Computer Modern fonts would be facilitated by
               making a _c_m_m_f._b_a_s_e file (which includes the macros in
               _c_m_b_a_s_e._m_f as well as those in _p_l_a_i_n._m_f).

               Several environment variables can be used to set up direc-
               tory paths to search when METAFONT opens a file for input.
               For example, the _c_s_h command
                   setenv MFINPUTS .:/usr/me/mylib:/usr/local/lib/mf/inputs
               or the _s_h command sequence
                   MFINPUTS=.:/usr/me/mylib:/usr/local/lib/mf/inputs
                   export MFINPUTS
               would cause all invocations of METAFONT and its derivatives
               to look for \input files first in the current directory,


          Rev. 9/25/90                                               Page 2






          MF(1)                INTERACTIVE UNIX System                MF(1)



               then in a hypothetical user's ``mylib'', and finally in the
               system library.  Normally, the user will place the command
               sequence which sets up the MFINPUTS environment variable in
               his or her ._l_o_g_i_n or ._p_r_o_f_i_l_e file.

               The _e response to METAFONT's error-recovery mode invokes the
               system default editor at the erroneous line of the source
               file.  There is an environment variable, MFEDIT, that over-
               rides the default editor. It should contain a string with
               "%s" indicating where the filename goes and "%d" indicating
               where the decimal linenumber (if any) goes.  For example, an
               MFEDIT string for the _v_i editor can be set with the _c_s_h com-
               mand
                       setenv MFEDIT "/usr/ucb/vi +%d %s"

               The environment variables section below lists the relevant
               environment variables, and their defaults.

               A convenient file in the library is _n_u_l_l._m_f, containing
               nothing.  When _m_f can't find the file it thinks you want to
               input, it keeps asking you for another file name;  respond-
               ing `null' gets you out of the loop if you don't want to
               input anything.

          ENVIRONMENT VARIABLES
               The default values for all environment variables are set at
               the time of compilation in a file _s_i_t_e._h.  See tttteeeexxxx(1) for
               the details of the searching.  If the environment variable
               TEXMFOUTPUT is set, METAFONT attempts to put its output
               files in it, if they cannot be put in the current directory.
               Again, see tttteeeexxxx(1).

               MFINPUTS
                    Search path for iiiinnnnppppuuuutttt and ooooppppeeeennnniiiinnnn files.  It should be
                    colon-separated, and start with ``.''.  Default:
                    ....::::////uuuussssrrrr////llllooooccccaaaallll////lllliiiibbbb////mmmmffff////iiiinnnnppppuuuuttttssss.

               MFINPUTS_SUBDIR
                    Search path for directories with subdirectories of
                    input files.  Default:  ////uuuussssrrrr////llllooooccccaaaallll////lllliiiibbbb////mmmmffff////iiiinnnnppppuuuuttttssss

               MFBASES
                    Search path for base files.  Default:
                    ....::::////uuuussssrrrr////llllooooccccaaaallll////lllliiiibbbb////mmmmffff////bbbbaaaasssseeeessss.

               MFPOOL
                    Search path for METAFONT internal strings.  Default:
                    ....::::////uuuussssrrrr////llllooooccccaaaallll////lllliiiibbbb////mmmmffff.

               MFEDIT
                    Command template for switching to editor.  Default:
                    ////uuuussssrrrr////bbbbiiiinnnn////vvvviiii+%d%%%%ssss.



          Rev. 9/25/90                                               Page 3






          MF(1)                INTERACTIVE UNIX System                MF(1)



          FONT UTILITIES
               A number of utility programs are available. The following is
               a partial list of available utilities and their purpose.
               Consult your local METAFONT guru for details.

               ggggffffttttooooppppkkkk    Takes a GF file and produces a more tightly packed
                         PK font file.

               ggggffffttttooooddddvvvviiii   Produces proof sheets for fonts.

               ggggffffttttyyyyppppeeee    Displays the contents of a GF file in mnemonics
                         and/or images.

               ppppkkkkttttyyyyppppeeee    Mnemonically displays the contents of a PK file.

               mmmmfffftttt       Formats a source file as shown in _C_o_m_p_u_t_e_r _M_o_d_e_r_n
                         _T_y_p_e_f_a_c_e_s.

          FILES
               /usr/local/lib/mf   METAFONT's library areas

               /usr/local/lib/mf/mf.pool
                                   Encoded text of METAFONT's messages

               /usr/local/lib/mf/bases/*.base
                                   METAFONT base files

               /usr/local/lib/mf/inputs/plain.mf
                                   The ``standard'' macro package

               /usr/local/lib/mf/inputs/(something).mf
                                   The file of ``mode_def''s for your
                                   site's various printers

               /usr/local/lib/mf/inputs/mf
                                   METAFONT sources for Computer Modern

          SUGGESTED READING
               Donald E. Knuth, _T_h_e _M_E_T_A_F_O_N_T_b_o_o_k (Volume C of  _C_o_m_p_u_t_e_r_s
               _a_n_d _T_y_p_e_s_e_t_t_i_n_g)
               Donald E. Knuth, _M_E_T_A_F_O_N_T: _T_h_e _P_r_o_g_r_a_m (Volume D of  _C_o_m_p_u_t_-
               _e_r_s _a_n_d _T_y_p_e_s_e_t_t_i_n_g)
               Donald E. Knuth, _C_o_m_p_u_t_e_r _M_o_d_e_r_n _T_y_p_e_f_a_c_e_s (Volume E of
               _C_o_m_p_u_t_e_r_s _a_n_d _T_y_p_e_s_e_t_t_i_n_g)
               _T_U_G_b_o_a_t (the publication of the TeX  Users Group)

          COMMENTS
               Warning: ``Type design can be hazardous to your other
               interests. Once you get hooked, you will develop intense
               feelings about letterforms; the medium will intrude on the
               messages that you read.  And you will perpetually be think-
               ing of improvements to the fonts that you see everywhere,
               especially those of your own design.''


          Rev. 9/25/90                                               Page 4






          MF(1)                INTERACTIVE UNIX System                MF(1)



          SEE ALSO
               gftopk(1), gftodvi(1), gftype(1), mft(1), pltotf(1),
               tftopl(1)

          BUGS
               On January 4, 1986 the ``final'' bug in METAFONT was
               discovered and removed. If an error still lurks in the code,
               D.E. Knuth promises to pay a finders fee which doubles every
               year to the first person who finds it. Happy hunting.

          AUTHORS
               METAFONT was designed by Donald E. Knuth, who implemented it
               using his WEB system for Pascal programs.  It was originally
               ported to Unix by Paul Richards at the University of Illi-
               nois at Urbana-Champaign.  This page written by Pierre
               MacKay (mostly).







































          Rev. 9/25/90                                               Page 5



