#!/bin/sh
# Next line starts wish: \
exec wish8.0 $0 $*

set ins(filelist) {ts ts_err includes.cfg texshell.cfg bitmaps help templates}
foreach f [glob *.tcl] {
  lappend ins(filelist) $f
}

if [catch {package require Tk 8}] {
  puts "Wrong Tcl/Tk version. You need Version 8.x"
  puts "Please download it from http://www.tclconsortium.com"
  exit
}

proc Install {} {
  global ins
  
  puts "Build ts from ts.in"
  set fi [open ts.in r]
  set fo [open ts w]
  while {![eof $fi]} {
    gets $fi line
    if [regexp {set TS_BASE} $line] {
      puts $fo "set TS_BASE $ins(lib)"
    } elseif [regexp {set params\(debug\)} $line] {
      puts $fo "set params(debug) 0"
    } else {
      puts $fo $line
    }
  }
  close $fo
  close $fi
  puts "Change permissions of binaries"
  foreach bin {ts ts_err} {
    file attributes $bin -permissions 0755
  }
  puts "Build install dir and copy files"
  catch {exec rm -rf $ins(lib)} err
  puts $err
  file mkdir $ins(lib)
  foreach f $ins(filelist) {
    file copy -force $f $ins(lib)
  }
  # set symbolic links
  foreach bin {ts ts_err} {
    file delete -force $ins(bin)/$bin
    catch {exec ln -s $ins(lib)/$bin $ins(bin)/$bin} err
    puts $err
  }
  exit
}

proc ide {} {
  global ins

  wm title . "TS setup"
  set ins(lib) /usr/local/lib/ts-9811
  set ins(bin) /usr/local/bin

  label .llib -text "Library path:"
  entry .elib -textvariable ins(lib)
  label .lbin -text "Binary path:"
  entry .ebin -textvariable ins(bin)
  button .binst -text "Install!" -command Install
  button .bexit -text Exit -command exit
  grid .llib -row 0 -column 0
  grid .elib -row 0 -column 1
  grid .lbin -row 1 -column 0
  grid .ebin -row 1 -column 1
  grid .binst -row 2 -column 0
  grid .bexit -row 2 -column 1
}

ide
