# ts_notebook.tcl
# Derived from Harrison/McLennan

proc notebook_create {w} {
  global nbInfo

  set nbInfo($w-count) 0
  set nbInfo($w-current) ""
  set nbInfo($w-pages) ""
  frame $w
  pack propagate $w 0
}

proc notebook_page {w name} {
  global nbInfo

  set page "$w.page[incr nbInfo($w-count)]"
  lappend nbInfo($w-pages) $page
  set nbInfo($w-page-$name) $page
  frame $page
  if {$nbInfo($w-count) == 1} {
    after idle [list notebook_display $w $name]
  }
  return $page
}

proc notebook_display {w name} {
  global nbInfo

  set page ""
  if {[info exists nbInfo($w-page-$name)]} {
    set page $nbInfo($w-page-$name)
  } elseif {[winfo exists $w.page$name]} {
    set page $w.page$name
  }
  if {$page == ""} {
    error "bad notebook page \"$name\""
  }
  notebook_fix_size $w
  if {$nbInfo($w-current) != ""} {
    pack forget $nbInfo($w-current)
  }
  pack $page -expand yes -fill both
  set nbInfo($w-current) $page
}

proc notebook_fix_size {win} {
  global nbInfo

  update idletasks
  set wmax 0
  set hmax 0
  foreach page $nbInfo($win-pages) {
    set w [winfo reqwidth $page]
    set h [winfo reqheight $page]
    if {$w > $wmax} {set wmax $w}
    if {$h > $hmax} {set hmax $h}
  }
  set bd [$win cget -borderwidth]
  set wmax [expr $wmax+2*$bd]
  set hmax [expr $hmax+2*$bd]
  $win configure -width $wmax -height $hmax
}
